/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.debug;

import lejos.nxt.Button;
import lejos.nxt.LCD;
import lejos.nxt.Sound;
import lejos.nxt.VM;
import lejos.nxt.debug.DebugInterface;

public class DebugMonitor {
    static String[] states = new String[]{"N", "D", "I", "R", "E", "W", "S"};

    static void displayException(DebugInterface info) {
        VM vm = VM.getVM();
        int base = vm.getImage().getImageBase();
        System.err.println("Java Exception");
        System.err.println("Class: " + vm.getVMClass(info.exception).getClassNo());
        String msg = info.exception.getMessage();
        if (msg != null && msg.length() > 0) {
            System.err.println("Msg: " + msg);
        }
        System.err.println(" at: " + info.method + "(" + info.pc + ")");
        int cnt = 0;
        VM.VMStackFrames stack = vm.getVMThread(info.thread).getStackFrames(info.frame - 1);
        for (VM.VMStackFrame sf : stack) {
            System.err.println(" at: " + sf.getVMMethod().getMethodNumber() + "(" + (sf.pc - base) + ")");
            if (cnt++ <= 5) continue;
            break;
        }
    }

    static void displayThreads(DebugInterface info) {
        VM vm = VM.getVM();
        VM.VMThreads threads = vm.getVMThreads();
        for (VM.VMThread thread : threads) {
            String out = "";
            out = out + thread.threadId;
            out = out + (thread.getJavaThread() == info.thread ? "*" : states[thread.state & 0x7F]);
            int cnt = 0;
            VM.VMStackFrames stack = thread.getStackFrames();
            for (VM.VMStackFrame frame : stack) {
                out = out + " " + frame.getVMMethod().getMethodNumber();
                if (++cnt < 3) continue;
                break;
            }
            System.err.println(out);
        }
    }

    public static void main(String[] args) throws Exception {
        DebugInterface monitor = DebugInterface.get();
        DebugInterface.eventOptions(1, 1);
        DebugInterface.eventOptions(2, 1);
        Thread prog = new Thread(){

            public void run() {
                VM.executeProgram(1);
            }
        };
        Thread.currentThread().setPriority(10);
        VM.setVMOptions(VM.getVMOptions() | 1);
        prog.start();
        while (true) {
            Thread.currentThread().setDaemon(true);
            int event = monitor.waitEvent(0);
            Thread.currentThread().setDaemon(false);
            LCD.clear();
            switch (event) {
                case 1: {
                    DebugMonitor.displayException(monitor);
                    break;
                }
                case 2: {
                    DebugMonitor.displayThreads(monitor);
                }
            }
            LCD.refresh();
            Sound.playTone(73, 150);
            Sound.pause(300);
            Sound.playTone(62, 500);
            while (Button.readButtons() != 0) {
                Thread.yield();
            }
            DebugInterface.eventOptions(2, 1);
            int pressed = Button.waitForPress();
            if ((Button.ESCAPE.getId() & pressed) != 0) {
                System.exit(1);
            }
            LCD.clear();
            monitor.clear();
            VM.resumeThread(null);
        }
    }
}

