/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import lejos.nxt.remote.AsciizCodec;
import lejos.nxt.remote.DeviceInfo;
import lejos.nxt.remote.FileInfo;
import lejos.nxt.remote.FirmwareInfo;
import lejos.nxt.remote.InputValues;
import lejos.nxt.remote.NXTCommRequest;
import lejos.nxt.remote.NXTProtocol;
import lejos.nxt.remote.OutputState;

public class NXTCommand
implements NXTProtocol {
    private NXTCommRequest nxtComm = null;
    private static NXTCommand singleton = null;
    private boolean verifyCommand = false;
    private boolean open = false;
    private static final String hexChars = "01234567890abcdef";
    private static final int MAX_BUFFER_SIZE = 58;

    public void setNXTComm(NXTCommRequest nxtComm) {
        this.open = true;
        this.nxtComm = nxtComm;
    }

    public void setVerify(boolean verify) {
        this.verifyCommand = verify;
    }

    private byte sendRequest(byte[] request, int replyLen) throws IOException {
        byte verify = 0;
        if (this.verifyCommand) {
            request[0] = 0;
        }
        byte[] reply = this.nxtComm.sendRequest(request, request[0] == 0 ? replyLen : 0);
        if (request[0] == 0) {
            verify = reply[2];
        }
        return verify;
    }

    private byte sendSystemRequest(byte[] request, int replyLen) throws IOException {
        byte verify = 0;
        if (this.verifyCommand) {
            request[0] = 1;
        }
        byte[] reply = this.nxtComm.sendRequest(request, request[0] == 1 ? replyLen : 0);
        if (request[0] == 1) {
            verify = reply[2];
        }
        return verify;
    }

    public byte startProgram(String fileName) throws IOException {
        byte[] request = new byte[]{-128, 0};
        request = this.appendString(request, fileName);
        return this.sendRequest(request, 22);
    }

    public byte stopProgram() throws IOException {
        byte[] request = new byte[]{-128, 1};
        return this.sendRequest(request, 3);
    }

    public String getCurrentProgramName() throws IOException {
        byte[] request = new byte[]{0, 17};
        byte[] reply = this.nxtComm.sendRequest(request, 23);
        return new StringBuffer(new String(reply)).delete(0, 2).toString();
    }

    public FileInfo openRead(String fileName) throws IOException {
        byte[] request = new byte[]{1, -128};
        request = this.appendString(request, fileName);
        byte[] reply = this.nxtComm.sendRequest(request, 8);
        FileInfo fileInfo = new FileInfo(fileName);
        fileInfo.status = reply[2];
        if (reply.length == 8) {
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[4] | (0xFF & reply[5]) << 8 | (0xFF & reply[6]) << 16 | (0xFF & reply[7]) << 24;
        }
        return fileInfo;
    }

    public byte openWrite(String fileName, int size) throws IOException {
        byte[] command = new byte[]{1, -127};
        byte[] asciiFileName = new byte[fileName.length()];
        for (int i = 0; i < fileName.length(); ++i) {
            asciiFileName[i] = (byte)fileName.charAt(i);
        }
        command = this.appendBytes(command, asciiFileName);
        byte[] request = new byte[22];
        System.arraycopy(command, 0, request, 0, command.length);
        byte[] fileLength = new byte[]{(byte)size, (byte)(size >>> 8), (byte)(size >>> 16), (byte)(size >>> 24)};
        request = this.appendBytes(request, fileLength);
        byte[] reply = this.nxtComm.sendRequest(request, 4);
        if (reply == null || reply.length != 4) {
            throw new IOException("Invalid return from OPEN WRITE");
        }
        if (reply[2] != 0) {
            if (reply[2] == -5) {
                throw new IOException("NXJ Flash Memory Full");
            }
            if (reply[2] == -4) {
                throw new IOException("NXJ Directory Full");
            }
            throw new IOException("OPEN WRITE failed");
        }
        return reply[3];
    }

    public byte closeFile(byte handle) throws IOException {
        byte[] request = new byte[]{-127, -124, handle};
        return this.sendSystemRequest(request, 4);
    }

    public byte delete(String fileName) throws IOException {
        byte[] request = new byte[]{1, -123};
        request = this.appendString(request, fileName);
        return this.sendSystemRequest(request, 23);
    }

    public FileInfo findFirstNXJ(String wildCard) throws IOException {
        byte[] request = new byte[]{1, -74};
        request = this.appendString(request, wildCard);
        byte[] reply = this.nxtComm.sendRequest(request, 32);
        FileInfo fileInfo = null;
        if (reply[2] == 0 && reply.length == 32) {
            StringBuffer name = new StringBuffer(new String(reply)).delete(0, 4);
            int lastPos = name.indexOf("\u0000");
            if (lastPos < 0 || lastPos > 20) {
                lastPos = 20;
            }
            name.delete(lastPos, name.length());
            fileInfo = new FileInfo(name.toString());
            fileInfo.status = 0;
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[24] | (0xFF & reply[25]) << 8 | (0xFF & reply[26]) << 16 | (0xFF & reply[27]) << 24;
            fileInfo.startPage = 0xFF & reply[28] | (0xFF & reply[29]) << 8 | (0xFF & reply[30]) << 16 | (0xFF & reply[31]) << 24;
        }
        return fileInfo;
    }

    public FileInfo findFirst(String wildCard) throws IOException {
        byte[] request = new byte[]{1, -122};
        request = this.appendString(request, wildCard);
        byte[] reply = this.nxtComm.sendRequest(request, 28);
        FileInfo fileInfo = null;
        if (reply[2] == 0 && reply.length == 28) {
            StringBuffer name = new StringBuffer(new String(reply)).delete(0, 4);
            int lastPos = name.indexOf("\u0000");
            if (lastPos < 0 || lastPos > 20) {
                lastPos = 20;
            }
            name.delete(lastPos, name.length());
            fileInfo = new FileInfo(name.toString());
            fileInfo.status = 0;
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[24] | (0xFF & reply[25]) << 8 | (0xFF & reply[26]) << 16 | (0xFF & reply[27]) << 24;
            fileInfo.startPage = -1;
        }
        return fileInfo;
    }

    public FileInfo findNextNXJ(byte handle) throws IOException {
        byte[] request = new byte[]{1, -73, handle};
        byte[] reply = this.nxtComm.sendRequest(request, 32);
        FileInfo fileInfo = null;
        if (reply[2] == 0 && reply.length == 32) {
            StringBuffer name = new StringBuffer(new String(reply)).delete(0, 4);
            int lastPos = name.indexOf("\u0000");
            if (lastPos < 0 || lastPos > 20) {
                lastPos = 20;
            }
            name.delete(lastPos, name.length());
            fileInfo = new FileInfo(name.toString());
            fileInfo.status = 0;
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[24] | (0xFF & reply[25]) << 8 | (0xFF & reply[26]) << 16 | (0xFF & reply[27]) << 24;
            fileInfo.startPage = 0xFF & reply[28] | (0xFF & reply[29]) << 8 | (0xFF & reply[30]) << 16 | (0xFF & reply[31]) << 24;
        }
        return fileInfo;
    }

    public FileInfo findNext(byte handle) throws IOException {
        byte[] request = new byte[]{1, -121, handle};
        byte[] reply = this.nxtComm.sendRequest(request, 28);
        FileInfo fileInfo = null;
        if (reply[2] == 0 && reply.length == 28) {
            StringBuffer name = new StringBuffer(new String(reply)).delete(0, 4);
            int lastPos = name.indexOf("\u0000");
            if (lastPos < 0 || lastPos > 20) {
                lastPos = 20;
            }
            name.delete(lastPos, name.length());
            fileInfo = new FileInfo(name.toString());
            fileInfo.status = 0;
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[24] | (0xFF & reply[25]) << 8 | (0xFF & reply[26]) << 16 | (0xFF & reply[27]) << 24;
            fileInfo.startPage = -1;
        }
        return fileInfo;
    }

    private byte[] appendString(byte[] command, String str) {
        int i;
        byte[] buff = new byte[command.length + str.length() + 1];
        for (i = 0; i < command.length; ++i) {
            buff[i] = command[i];
        }
        for (i = 0; i < str.length(); ++i) {
            buff[command.length + i] = (byte)str.charAt(i);
        }
        buff[command.length + str.length()] = 0;
        return buff;
    }

    private byte[] appendBytes(byte[] array1, byte[] array2) {
        byte[] array = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array2.length);
        return array;
    }

    public int getBatteryLevel() throws IOException {
        byte[] request = new byte[]{0, 11};
        byte[] reply = this.nxtComm.sendRequest(request, 5);
        int batteryLevel = 0xFF & reply[3] | (0xFF & reply[4]) << 8;
        return batteryLevel;
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        byte[] request = new byte[]{-127, 32};
        this.nxtComm.sendRequest(request, 0);
        this.nxtComm.close();
    }

    public void boot() throws IOException {
        byte[] request = new byte[]{-127, -105};
        request = this.appendString(request, "Let's dance: SAMBA");
        this.nxtComm.sendRequest(request, 0);
        this.nxtComm.close();
        this.open = false;
    }

    public byte writeFile(byte handle, byte[] data) throws IOException {
        byte[] command = new byte[]{-127, -125, handle};
        int remaining = data.length;
        int chunkStart = 0;
        while (remaining > 0) {
            int chunkLen = 58;
            if (remaining < chunkLen) {
                chunkLen = remaining;
            }
            byte[] request = new byte[chunkLen + 3];
            System.arraycopy(command, 0, request, 0, command.length);
            System.arraycopy(data, chunkStart, request, 3, chunkLen);
            byte status = this.sendSystemRequest(request, 6);
            if (status != 0) {
                return status;
            }
            remaining -= chunkLen;
            chunkStart += chunkLen;
        }
        return 0;
    }

    public String uploadFile(File file, String nxtFileName) throws IOException {
        byte[] data = new byte[58];
        FileInputStream in = null;
        long millis = System.currentTimeMillis();
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IOException("File not found");
        }
        byte handle = this.openWrite(nxtFileName, (int)file.length());
        try {
            int len;
            while ((len = in.read(data)) > 0) {
                byte[] sendData = new byte[len];
                for (int i = 0; i < len; ++i) {
                    sendData[i] = data[i];
                }
                this.writeFile(handle, sendData);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Failed to upload");
        }
        this.setVerify(true);
        this.closeFile(handle);
        return "Upload successful in " + (System.currentTimeMillis() - millis) + " milliseconds";
    }

    public byte[] readFile(byte handle, int length) throws IOException {
        int chunkLen;
        int chunkStart = 0;
        byte[] reply = new byte[length];
        for (int remaining = length; remaining > 0; remaining -= chunkLen) {
            chunkLen = 58;
            if (chunkLen > remaining) {
                chunkLen = remaining;
            }
            byte[] request = new byte[]{1, -126, handle, (byte)chunkLen, (byte)(chunkLen >>> 8)};
            byte[] reply1 = this.nxtComm.sendRequest(request, chunkLen + 6);
            int dataLen = (reply1[4] & 0xFF) + (reply1[5] << 8 & 0xFF);
            for (int i = 0; i < dataLen; ++i) {
                reply[chunkStart + i] = reply1[i + 6];
            }
            chunkStart += chunkLen;
        }
        return reply;
    }

    public byte defrag() throws IOException {
        byte[] request = new byte[]{-127, 33};
        return this.sendSystemRequest(request, 3);
    }

    public String getFriendlyName() throws IOException {
        byte[] request = new byte[]{1, -101};
        byte[] reply = this.nxtComm.sendRequest(request, 33);
        char[] nameChars = new char[16];
        int len = 0;
        for (int i = 0; i < 15 && reply[i + 3] != 0; ++i) {
            nameChars[i] = (char)reply[i + 3];
            ++len;
        }
        return new String(nameChars, 0, len);
    }

    public byte setFriendlyName(String name) throws IOException {
        byte[] request = new byte[]{-127, -104};
        request = this.appendString(request, name);
        return this.sendSystemRequest(request, 3);
    }

    public String getLocalAddress() throws IOException {
        byte[] request = new byte[]{1, -101};
        byte[] reply = this.nxtComm.sendRequest(request, 33);
        char[] addrChars = new char[14];
        for (int i = 0; i < 7; ++i) {
            addrChars[i * 2] = hexChars.charAt(reply[i + 18] >> 4 & 0xF);
            addrChars[i * 2 + 1] = hexChars.charAt(reply[i + 18] & 0xF);
        }
        return new String(addrChars);
    }

    public InputValues getInputValues(int port) throws IOException {
        byte[] request = new byte[]{0, 7, (byte)port};
        byte[] reply = this.nxtComm.sendRequest(request, 16);
        InputValues inputValues = new InputValues();
        inputValues.inputPort = reply[3];
        inputValues.valid = reply[4] != 0;
        inputValues.isCalibrated = reply[5] == 0;
        inputValues.sensorType = reply[6];
        inputValues.sensorMode = reply[7];
        inputValues.rawADValue = 0xFF & reply[8] | (0xFF & reply[9]) << 8;
        inputValues.normalizedADValue = 0xFF & reply[10] | (0xFF & reply[11]) << 8;
        inputValues.scaledValue = (short)(0xFF & reply[12] | reply[13] << 8);
        inputValues.calibratedValue = (short)(0xFF & reply[14] | reply[15] << 8);
        return inputValues;
    }

    public OutputState getOutputState(int port) throws IOException {
        byte[] request = new byte[]{0, 6, (byte)port};
        byte[] reply = this.nxtComm.sendRequest(request, 25);
        OutputState outputState = new OutputState(port);
        outputState.status = reply[2];
        outputState.outputPort = reply[3];
        outputState.powerSetpoint = reply[4];
        outputState.mode = reply[5];
        outputState.regulationMode = reply[6];
        outputState.turnRatio = reply[7];
        outputState.runState = reply[8];
        outputState.tachoLimit = 0xFF & reply[9] | (0xFF & reply[10]) << 8 | (0xFF & reply[11]) << 16 | (0xFF & reply[12]) << 24;
        outputState.tachoCount = 0xFF & reply[13] | (0xFF & reply[14]) << 8 | (0xFF & reply[15]) << 16 | (0xFF & reply[16]) << 24;
        outputState.blockTachoCount = 0xFF & reply[17] | (0xFF & reply[18]) << 8 | (0xFF & reply[19]) << 16 | (0xFF & reply[20]) << 24;
        outputState.rotationCount = 0xFF & reply[21] | (0xFF & reply[22]) << 8 | (0xFF & reply[23]) << 16 | (0xFF & reply[24]) << 24;
        return outputState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTachoCount(int port) throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{0, 6, (byte)port};
            byte[] reply = this.nxtComm.sendRequest(request, 25);
            int tachoCount = 0xFF & reply[13] | (0xFF & reply[14]) << 8 | (0xFF & reply[15]) << 16 | (0xFF & reply[16]) << 24;
            return tachoCount;
        }
    }

    public byte setInputMode(int port, int sensorType, int sensorMode) throws IOException {
        byte[] request = new byte[]{-128, 5, (byte)port, (byte)sensorType, (byte)sensorMode};
        return this.sendRequest(request, 3);
    }

    public byte[] LSGetStatus(byte port) throws IOException {
        byte[] request = new byte[]{0, 14, port};
        byte[] reply = this.nxtComm.sendRequest(request, 4);
        byte[] returnData = new byte[]{reply[2], reply[3]};
        return returnData;
    }

    public byte[] LSRead(byte port) throws IOException {
        byte[] request = new byte[]{0, 16, port};
        byte[] reply = this.nxtComm.sendRequest(request, 20);
        byte rxLength = reply[3];
        if (reply[2] == 0 && rxLength >= 0) {
            byte[] rxData = new byte[rxLength];
            System.arraycopy(reply, 4, rxData, 0, rxLength);
            return rxData;
        }
        return null;
    }

    public byte LSWrite(byte port, byte[] txData, byte rxDataLength) throws IOException {
        byte[] request = new byte[]{-128, 15, port, (byte)txData.length, rxDataLength};
        request = this.appendBytes(request, txData);
        return this.sendRequest(request, 3);
    }

    public byte[] messageRead(byte remoteInbox, byte localInbox, boolean remove) throws IOException {
        byte[] request = new byte[]{0, 19, remoteInbox, localInbox, remove ? (byte)1 : 0};
        byte[] reply = this.nxtComm.sendRequest(request, 64);
        byte[] message = new byte[reply[4]];
        System.arraycopy(reply, 5, message, 0, reply[4]);
        return message;
    }

    public byte messageWrite(byte[] message, byte inbox) throws IOException {
        byte[] request = new byte[]{-128, 9, inbox, (byte)message.length};
        request = this.appendBytes(request, message);
        return this.sendRequest(request, 3);
    }

    public byte playTone(int frequency, int duration) throws IOException {
        byte[] request = new byte[]{-128, 3, (byte)frequency, (byte)(frequency >>> 8), (byte)duration, (byte)(duration >>> 8)};
        return this.sendRequest(request, 3);
    }

    public byte playSoundFile(String fileName, boolean repeat) throws IOException {
        byte boolVal = 0;
        if (repeat) {
            boolVal = -1;
        }
        byte[] request = new byte[]{-128, 2, boolVal};
        byte[] encFileName = null;
        try {
            encFileName = AsciizCodec.encode(fileName);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Illegal characters in filename");
            return -1;
        }
        request = this.appendBytes(request, encFileName);
        return this.sendRequest(request, 3);
    }

    public byte stopSoundPlayback() throws IOException {
        byte[] request = new byte[]{-128, 12};
        return this.sendRequest(request, 3);
    }

    public byte resetMotorPosition(int port, boolean relative) throws IOException {
        byte boolVal = 0;
        if (relative) {
            boolVal = -1;
        }
        byte[] request = new byte[]{-128, 10, (byte)port, boolVal};
        return this.sendRequest(request, 3);
    }

    public byte setOutputState(int port, byte power, int mode, int regulationMode, int turnRatio, int runState, int tachoLimit) throws IOException {
        byte[] request = new byte[]{-128, 4, (byte)port, power, (byte)mode, (byte)regulationMode, (byte)turnRatio, (byte)runState, (byte)tachoLimit, (byte)(tachoLimit >>> 8), (byte)(tachoLimit >>> 16), (byte)(tachoLimit >>> 24)};
        return this.sendRequest(request, 3);
    }

    public DeviceInfo getDeviceInfo() throws IOException {
        byte[] request = new byte[]{1, -101};
        byte[] reply = this.nxtComm.sendRequest(request, 33);
        DeviceInfo d = new DeviceInfo();
        d.status = reply[2];
        d.NXTname = new StringBuffer(new String(reply)).delete(18, 33).delete(0, 3).toString();
        d.bluetoothAddress = Integer.toHexString(reply[18]) + ":" + Integer.toHexString(reply[19]) + ":" + Integer.toHexString(reply[20]) + ":" + Integer.toHexString(reply[21]) + ":" + Integer.toHexString(reply[22]) + ":" + Integer.toHexString(reply[23]) + ":" + Integer.toHexString(reply[24]);
        d.signalStrength = 0xFF & reply[25] | (0xFF & reply[26]) << 8 | (0xFF & reply[27]) << 16 | (0xFF & reply[28]) << 24;
        d.freeFlash = 0xFF & reply[29] | (0xFF & reply[30]) << 8 | (0xFF & reply[31]) << 16 | (0xFF & reply[32]) << 24;
        return d;
    }

    public FirmwareInfo getFirmwareVersion() throws IOException {
        byte[] request = new byte[]{1, -120};
        byte[] reply = this.nxtComm.sendRequest(request, 7);
        FirmwareInfo info = new FirmwareInfo();
        info.status = reply[2];
        if (info.status == 0) {
            info.protocolVersion = reply[4] + "." + reply[3];
            info.firmwareVersion = reply[6] + "." + reply[5];
        }
        return info;
    }

    public byte deleteUserFlash() throws IOException {
        byte[] request = new byte[]{1, -96};
        byte[] reply = this.nxtComm.sendRequest(request, 3);
        return reply[2];
    }

    public static NXTCommand getSingleton() {
        if (singleton == null) {
            singleton = new NXTCommand();
        }
        return singleton;
    }

    public boolean isOpen() {
        return this.open;
    }
}

