/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import lejos.nxt.comm.NXTCommConnector;
import lejos.nxt.remote.DeviceInfo;
import lejos.nxt.remote.FileInfo;
import lejos.nxt.remote.FirmwareInfo;
import lejos.nxt.remote.NXTComm;
import lejos.nxt.remote.NXTCommand;
import lejos.nxt.remote.RemoteBattery;
import lejos.nxt.remote.RemoteMotor;
import lejos.nxt.remote.RemoteSensorPort;

public class RemoteNXT {
    private NXTCommand nxtCommand = new NXTCommand();
    private NXTComm nxtComm;
    public RemoteMotor A;
    public RemoteMotor B;
    public RemoteMotor C;
    public RemoteBattery Battery;
    public RemoteSensorPort S1;
    public RemoteSensorPort S2;
    public RemoteSensorPort S3;
    public RemoteSensorPort S4;

    public RemoteNXT(String name, NXTCommConnector connector) throws IOException {
        this.nxtComm = new NXTComm(connector);
        boolean open = this.nxtComm.open(name, 1);
        if (!open) {
            throw new IOException("Failed to connect to " + name);
        }
        this.nxtCommand.setNXTComm(this.nxtComm);
        this.A = new RemoteMotor(this.nxtCommand, 0);
        this.B = new RemoteMotor(this.nxtCommand, 1);
        this.C = new RemoteMotor(this.nxtCommand, 2);
        this.Battery = new RemoteBattery(this.nxtCommand);
        this.S1 = new RemoteSensorPort(this.nxtCommand, 0);
        this.S2 = new RemoteSensorPort(this.nxtCommand, 1);
        this.S3 = new RemoteSensorPort(this.nxtCommand, 2);
        this.S4 = new RemoteSensorPort(this.nxtCommand, 3);
    }

    public String getBrickName() {
        try {
            DeviceInfo i = this.nxtCommand.getDeviceInfo();
            return i.NXTname;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getBluetoothAddress() {
        try {
            DeviceInfo i = this.nxtCommand.getDeviceInfo();
            return i.bluetoothAddress;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int getFlashMemory() {
        try {
            DeviceInfo i = this.nxtCommand.getDeviceInfo();
            return i.freeFlash;
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public String getFirmwareVersion() {
        try {
            FirmwareInfo f = this.nxtCommand.getFirmwareVersion();
            return f.firmwareVersion;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getProtocolVersion() {
        try {
            FirmwareInfo f = this.nxtCommand.getFirmwareVersion();
            return f.protocolVersion;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public byte deleteFlashMemory() {
        try {
            return this.nxtCommand.deleteUserFlash();
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public String[] getFileNames(String searchCriteria) {
        try {
            ArrayList<String> names = new ArrayList<String>();
            FileInfo f = this.nxtCommand.findFirst(searchCriteria);
            if (f == null) {
                return null;
            }
            do {
                names.add(f.fileName);
                if (f == null) continue;
                this.nxtCommand.closeFile(f.fileHandle);
            } while ((f = this.nxtCommand.findNext(f.fileHandle)) != null);
            String[] returnArray = new String[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                returnArray[i] = (String)names.get(i);
            }
            return returnArray;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String[] getFileNames() {
        return this.getFileNames("*.*");
    }

    public byte delete(String fileName) {
        try {
            return this.nxtCommand.delete(fileName);
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public byte startProgram(String fileName) {
        try {
            return this.nxtCommand.startProgram(fileName);
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public byte stopProgram() {
        try {
            return this.nxtCommand.stopProgram();
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public String getCurrentProgramName() {
        try {
            return this.nxtCommand.getCurrentProgramName();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int sendMessage(byte[] message, int inbox) {
        try {
            return this.nxtCommand.messageWrite(message, (byte)inbox);
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public byte[] receiveMessage(int remoteInbox, int localInbox, boolean remove) {
        try {
            return this.nxtCommand.messageRead((byte)remoteInbox, (byte)localInbox, remove);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int playTone(int frequency, int duration) {
        try {
            return this.nxtCommand.playTone(frequency, duration);
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public byte playSoundFile(String fileName, boolean repeat) {
        try {
            return this.nxtCommand.playSoundFile(fileName, repeat);
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public byte playSoundFile(String fileName) {
        return this.playSoundFile(fileName, false);
    }

    public int stopSoundPlayback() {
        try {
            return this.nxtCommand.stopSoundPlayback();
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public void close() {
        try {
            if (this.nxtCommand.isOpen()) {
                this.nxtCommand.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte upload(String fileName) {
        byte success;
        byte[] data;
        File localSource = new File(fileName);
        try {
            FileInputStream in = new FileInputStream(localSource);
            data = new byte[(int)localSource.length()];
            in.read(data);
            in.close();
        }
        catch (IOException ioe) {
            return -1;
        }
        try {
            byte handle = this.nxtCommand.openWrite(localSource.getName(), data.length);
            success = this.nxtCommand.writeFile(handle, data);
            this.nxtCommand.closeFile(handle);
        }
        catch (IOException ioe) {
            return -1;
        }
        return success;
    }

    public byte[] download(String fileName) {
        byte[] data;
        try {
            FileInfo finfo = this.nxtCommand.openRead(fileName);
            if (finfo.status != 0) {
                byte[] data2 = new byte[]{finfo.status};
                return data2;
            }
            data = this.nxtCommand.readFile(finfo.fileHandle, finfo.fileSize);
            this.nxtCommand.closeFile(finfo.fileHandle);
        }
        catch (IOException ioe) {
            return null;
        }
        return data;
    }

    public byte download(String fileName, File destination) {
        byte[] data = this.download(fileName);
        File fullFile = destination;
        try {
            if (fullFile.exists()) {
                fullFile.delete();
            }
            if (fullFile.createNewFile()) {
                FileOutputStream out = new FileOutputStream(fullFile);
                out.write(data);
                out.close();
            }
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }
}

