/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.remote;

import java.io.IOException;
import lejos.nxt.ADSensorPort;
import lejos.nxt.I2CPort;
import lejos.nxt.remote.InputValues;
import lejos.nxt.remote.NXTCommand;
import lejos.nxt.remote.NXTProtocol;

public class RemoteSensorPort
implements NXTProtocol,
ADSensorPort,
I2CPort {
    private int id;
    private int type;
    private int mode;
    private NXTCommand nxtCommand;

    public RemoteSensorPort(NXTCommand nxtCommand, int id) {
        this.nxtCommand = nxtCommand;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public int getMode() {
        return this.mode;
    }

    public void setTypeAndMode(int type, int mode) {
        this.type = type;
        this.mode = mode;
        try {
            this.nxtCommand.setInputMode(this.id, type, mode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setType(int type) {
        this.type = type;
        this.setTypeAndMode(type, this.mode);
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.setTypeAndMode(this.type, mode);
    }

    public boolean readBooleanValue() {
        try {
            InputValues vals = this.nxtCommand.getInputValues(this.id);
            return vals.rawADValue < 600;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int readRawValue() {
        try {
            InputValues vals = this.nxtCommand.getInputValues(this.id);
            return vals.rawADValue;
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public int readValue() {
        int rawValue = this.readRawValue();
        if (this.mode == 32) {
            return rawValue < 600 ? 1 : 0;
        }
        if (this.mode == 128) {
            return (1023 - rawValue) * 100 / 1023;
        }
        return rawValue;
    }

    public NXTCommand getNXTCommand() {
        return this.nxtCommand;
    }

    public int i2cBusy() {
        try {
            byte[] status = this.nxtCommand.LSGetStatus((byte)this.id);
            return status[0];
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public void i2cDisable() {
    }

    public void i2cEnable(int mode) {
    }

    public int i2cStart(int address, int internalAddress, int numInternalBytes, byte[] buffer, int numBytes, int transferType) {
        int status;
        byte[] txData = new byte[]{(byte)(address << 1), (byte)internalAddress};
        try {
            this.nxtCommand.LSWrite((byte)this.id, txData, (byte)numBytes);
        }
        catch (IOException ioe) {
            return -1;
        }
        while ((status = this.i2cBusy()) == 32 || status == -32) {
        }
        if (status != 0) {
            return status;
        }
        return 0;
    }

    public int i2cComplete(byte[] buffer, int numBytes) {
        try {
            byte[] ret = this.nxtCommand.LSRead((byte)this.id);
            if (ret == null) {
                return -1;
            }
            if (numBytes > ret.length) {
                numBytes = ret.length;
            }
            System.arraycopy(ret, 0, buffer, 0, numBytes);
        }
        catch (IOException ioe) {
            return -1;
        }
        return numBytes;
    }
}

