/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.localization;

import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lejos.geom.Point;
import lejos.robotics.Movement;
import lejos.robotics.Pose;
import lejos.robotics.RangeReadings;
import lejos.robotics.localization.MCLParticle;
import lejos.robotics.mapping.RangeMap;

public class MCLParticleSet {
    private static final float BIG_FLOAT = 10000.0f;
    public static int maxIterations = 1000;
    private float twoSigmaSquared = 250.0f;
    private float distanceNoiseFactor = 0.02f;
    private float angleNoiseFactor = 0.02f;
    private int numParticles;
    private MCLParticle[] particles;
    private RangeMap map;
    private float estimatedX;
    private float estimatedY;
    private float estimatedAngle;
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float maxWeight;
    private int border = 10;
    private Rectangle boundingRect;
    private boolean debug = false;

    public MCLParticleSet(RangeMap map, int numParticles, int border) {
        this.map = map;
        this.numParticles = numParticles;
        this.border = border;
        this.boundingRect = map.getBoundingRect();
        this.particles = new MCLParticle[numParticles];
        for (int i = 0; i < numParticles; ++i) {
            this.particles[i] = this.generateParticle();
        }
        this.resetEstimate();
    }

    private MCLParticle generateParticle() {
        float y;
        float x;
        Rectangle innerRect = new Rectangle(this.boundingRect.x + this.border, this.boundingRect.y + this.border, this.boundingRect.width - this.border * 2, this.boundingRect.height - this.border * 2);
        while (!this.map.inside(new Point(x = (float)innerRect.x + (float)Math.random() * (float)innerRect.width, y = (float)innerRect.y + (float)Math.random() * (float)innerRect.height))) {
        }
        float angle = (float)Math.random() * 360.0f;
        return new MCLParticle(new Pose(x, y, angle));
    }

    public int numParticles() {
        return this.numParticles;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public MCLParticle getParticle(int i) {
        return this.particles[i];
    }

    public boolean resample() {
        MCLParticle[] oldParticles = this.particles;
        this.particles = new MCLParticle[this.numParticles];
        int count = 0;
        int iterations = 0;
        while (count < this.numParticles) {
            if (++iterations >= maxIterations) {
                if (this.debug) {
                    System.out.println("Lost: count = " + count);
                }
                if (count > 0) {
                    for (int i = count; i < this.numParticles; ++i) {
                        this.particles[i] = new MCLParticle(this.particles[i % count].getPose());
                        this.particles[i].setWeight(this.particles[i % count].getWeight());
                    }
                    return false;
                }
                for (int i = 0; i < this.numParticles; ++i) {
                    this.particles[i] = this.generateParticle();
                }
                this.resetEstimate();
                return true;
            }
            float rand = (float)Math.random();
            for (int i = 0; i < this.numParticles && count < this.numParticles; ++i) {
                if (!(oldParticles[i].getWeight() >= rand)) continue;
                Pose p = oldParticles[i].getPose();
                float x = p.getX();
                float y = p.getY();
                float angle = p.getHeading();
                this.particles[count] = new MCLParticle(new Pose(x, y, angle));
                this.particles[count++].setWeight(oldParticles[i].getWeight());
            }
        }
        this.estimatePose();
        return false;
    }

    private void estimatePose() {
        this.resetEstimate();
        float totalWeights = 0.0f;
        this.minX = this.boundingRect.x + this.boundingRect.width;
        this.minY = this.boundingRect.y + this.boundingRect.height;
        this.maxX = this.boundingRect.x;
        this.maxY = this.boundingRect.y;
        for (int i = 0; i < this.numParticles; ++i) {
            Pose p = this.particles[i].getPose();
            float x = p.getX();
            float y = p.getY();
            float weight = this.particles[i].getWeight();
            this.estimatedX += x * weight;
            this.estimatedY += y * weight;
            this.estimatedAngle += p.getHeading() * weight;
            totalWeights += weight;
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!(y > this.maxY)) continue;
            this.maxY = y;
        }
        this.estimatedX /= totalWeights;
        this.estimatedY /= totalWeights;
        this.estimatedAngle /= totalWeights;
    }

    public void calculateWeights(RangeReadings rr, RangeMap map) {
        this.maxWeight = 0.0f;
        for (int i = 0; i < this.numParticles; ++i) {
            this.particles[i].calculateWeight(rr, map, this.twoSigmaSquared);
            float weight = this.particles[i].getWeight();
            if (!(weight > this.maxWeight)) continue;
            this.maxWeight = weight;
        }
    }

    public void printMaxWeight() {
        System.out.println("Max = " + this.maxWeight);
    }

    public void applyMove(Movement move) {
        this.maxWeight = 0.0f;
        for (int i = 0; i < this.numParticles; ++i) {
            this.particles[i].applyMove(move, this.distanceNoiseFactor, this.angleNoiseFactor);
        }
        this.estimatePose();
    }

    public Pose getEstimatedPose() {
        return new Pose(this.estimatedX, this.estimatedY, this.estimatedAngle);
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public void resetEstimate() {
        this.estimatedX = 0.0f;
        this.estimatedY = 0.0f;
        this.estimatedAngle = 0.0f;
        this.minX = this.boundingRect.x;
        this.minY = this.boundingRect.y;
        this.maxX = this.boundingRect.x + this.boundingRect.width;
        this.maxY = this.boundingRect.y + this.boundingRect.height;
    }

    public Rectangle getErrorRect() {
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    public float getMaxWeight() {
        return this.maxWeight;
    }

    public float getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public void setSigma(float sigma) {
        this.twoSigmaSquared = 2.0f * sigma * sigma;
    }

    public void setDistanceNoiseFactor(float factor) {
        this.distanceNoiseFactor = factor;
    }

    public void setAngleNoiseFactor(float factor) {
        this.angleNoiseFactor = factor;
    }

    public void setMaxIterations(int max) {
        maxIterations = max;
    }

    public int findClosest(float x, float y) {
        float minDistance = 10000.0f;
        int index = -1;
        for (int i = 0; i < this.numParticles; ++i) {
            Pose pose = this.particles[i].getPose();
            float distance = (float)Math.sqrt((double)((pose.getX() - x) * (pose.getX() - x)) + (double)((pose.getY() - y) * (pose.getY() - y)));
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            index = i;
        }
        return index;
    }

    public void dumpParticles(DataOutputStream dos) throws IOException {
        dos.writeInt(this.numParticles());
        for (int i = 0; i < this.numParticles(); ++i) {
            MCLParticle part = this.getParticle(i);
            Pose pose = part.getPose();
            float weight = part.getWeight();
            dos.writeFloat(pose.getX());
            dos.writeFloat(pose.getY());
            dos.writeFloat(pose.getHeading());
            dos.writeFloat(weight);
            dos.flush();
        }
    }

    public void loadParticles(DataInputStream dis) throws IOException {
        this.numParticles = dis.readInt();
        this.particles = new MCLParticle[this.numParticles];
        for (int i = 0; i < this.numParticles; ++i) {
            float x = dis.readFloat();
            float y = dis.readFloat();
            float angle = dis.readFloat();
            Pose pose = new Pose(x, y, angle);
            this.particles[i] = new MCLParticle(pose);
            this.particles[i].setWeight(dis.readFloat());
        }
    }

    public void dumpEstimation(DataOutputStream dos) throws IOException {
        Pose pose = this.getEstimatedPose();
        float minX = this.getMinX();
        float maxX = this.getMaxX();
        float minY = this.getMinY();
        float maxY = this.getMaxY();
        dos.writeFloat(pose.getX());
        dos.writeFloat(pose.getY());
        dos.writeFloat(pose.getHeading());
        dos.writeFloat(minX);
        dos.writeFloat(maxX);
        dos.writeFloat(minY);
        dos.writeFloat(maxY);
        dos.flush();
    }

    public void loadEstimation(DataInputStream dis) throws IOException {
        this.estimatedX = dis.readFloat();
        this.estimatedY = dis.readFloat();
        this.estimatedAngle = dis.readFloat();
        this.minX = dis.readFloat();
        this.maxX = dis.readFloat();
        this.minY = dis.readFloat();
        this.maxY = dis.readFloat();
    }

    public void dumpClosest(RangeReadings rr, RangeMap map, DataOutputStream dos, float x, float y) throws IOException {
        int closest = this.findClosest(x, y);
        MCLParticle p = this.getParticle(closest);
        dos.writeInt(closest);
        dos.writeFloat(p.getReading(0, rr, map));
        dos.writeFloat(p.getReading(1, rr, map));
        dos.writeFloat(p.getReading(2, rr, map));
        dos.writeFloat(p.getWeight());
        dos.flush();
    }
}

