/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    private static final int SKIP_BUF_LEN = 32;

    protected Reader() {
    }

    public abstract void close() throws IOException;

    public void mark(int position) throws IOException {
        throw new IOException("mark not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        char[] buffer = new char[1];
        if (this.read(buffer, 0, 1) < 0) {
            return -1;
        }
        return buffer[0];
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public boolean ready() throws IOException {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    public long skip(long n) throws IOException {
        int readlen;
        int len;
        char[] buffer = new char[32];
        long nbackup = n;
        while (n > 0L && (len = this.read(buffer, 0, readlen = n >= 32L ? 32 : (int)n)) >= 0) {
            n -= (long)len;
        }
        return nbackup - n;
    }
}

