/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class String
implements CharSequence {
    final char[] characters;
    private int hash = 0;

    private String(int len) {
        this.characters = new char[len];
    }

    public String(char[] c, int off, int len) {
        this.characters = new char[len];
        System.arraycopy(c, off, this.characters, 0, len);
    }

    public String(char[] c) {
        this(c, 0, c.length);
    }

    public String(byte[] b) {
        this(b, 0, b.length);
    }

    public String(byte[] b, int off, int len) {
        this.characters = new char[len];
        for (int i = 0; i < len; ++i) {
            this.characters[i] = (char)b[off + i];
        }
    }

    public String(byte[] b, String charset) {
        this(b, 0, b.length, charset);
    }

    public String(byte[] b, int off, int len, String charset) {
        this(b, off, len);
    }

    public int length() {
        return this.characters.length;
    }

    public char charAt(int index) {
        if (index > this.characters.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.characters[index];
    }

    public void getChars(int start, int end, char[] buffer, int off) {
        if (start < 0 || start > this.characters.length) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.characters.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (end < start) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        System.arraycopy(this.characters, start, buffer, off, end - start);
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int offset = 0;
        int max = offset + this.characters.length;
        char[] v = this.characters;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.characters.length) {
            return -1;
        }
        for (int i = offset + fromIndex; i < max; ++i) {
            if (v[i] != ch) continue;
            return i - offset;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public synchronized int indexOf(String str, int fromIndex) {
        return String.indexOf(this.characters, 0, this.characters.length, str.characters, 0, str.characters.length, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.characters.length);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.characters, 0, this.characters.length, str.characters, 0, str.characters.length, fromIndex);
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public char[] toCharArray() {
        int len = this.characters.length;
        char[] ca = new char[len];
        System.arraycopy(this.characters, 0, ca, 0, len);
        return ca;
    }

    public synchronized String substring(int start) {
        return this.substring(start, this.characters.length);
    }

    public synchronized String substring(int start, int end) {
        if (start < 0 || start > this.characters.length) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.characters.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (end < start) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.characters, start, end - start);
    }

    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public static String valueOf(Object aObj) {
        return aObj == null ? "null" : aObj.toString();
    }

    public String toString() {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        try {
            String os = (String)other;
            if (os.characters.length != this.characters.length) {
                return false;
            }
            for (int i = 0; i < this.characters.length; ++i) {
                if (this.characters[i] == os.characters[i]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equalsIgnoreCase(String s) {
        return this.toLowerCase().equals(s.toLowerCase());
    }

    public String toLowerCase() {
        char[] c1 = new char[this.characters.length];
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = this.characters[i];
            if (!(this.characters[i] >= 'A' & this.characters[i] <= 'Z')) continue;
            int n = i;
            c1[n] = (char)(c1[n] + 32);
        }
        return new String(c1);
    }

    public String toUpperCase() {
        char[] c1 = new char[this.characters.length];
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = this.characters[i];
            if (!(this.characters[i] >= 'a' & this.characters[i] <= 'z')) continue;
            int n = i;
            c1[n] = (char)(c1[n] - 32);
        }
        return new String(c1);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (int i = 0; i < this.characters.length; ++i) {
                h = 31 * h + this.characters[i];
            }
            this.hash = h;
        }
        return h;
    }

    public byte[] getBytes(String charset) {
        byte[] b = new byte[this.characters.length];
        for (int i = 0; i < this.characters.length; ++i) {
            b[i] = (byte)this.characters[i];
        }
        return b;
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        String r = new String(1);
        r.characters[0] = c;
        return r;
    }

    public static String valueOf(char[] c) {
        return new String(c);
    }

    public static String valueOf(char[] c, int start, int length) {
        return new String(c, start, length);
    }

    public static String valueOf(double d) {
        char[] sb = new char[25];
        int p = StringUtils.getDoubleChars(d, sb, 0);
        return new String(sb, 0, p);
    }

    public static String valueOf(float f) {
        char[] sb = new char[15];
        int p = StringUtils.getFloatChars(f, sb, 0);
        return new String(sb, 0, p);
    }

    public static String valueOf(int i) {
        return String.valueOf(i, 10);
    }

    public static String valueOf(long i) {
        return String.valueOf(i, 10);
    }

    static String valueOf(int i, int radix) {
        int len = StringUtils.exactStringLength(i, radix);
        String r = new String(len);
        StringUtils.getIntChars(r.characters, len, i, radix);
        return r;
    }

    static String valueOf(long i, int radix) {
        int len = StringUtils.exactStringLength(i, radix);
        String r = new String(len);
        StringUtils.getLongChars(r.characters, len, i, radix);
        return r;
    }
}

