/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class StringBuilder {
    private static final int INITIAL_CAPACITY = 10;
    private static final int CAPACITY_INCREMENT_NUM = 3;
    private static final int CAPACITY_INCREMENT_DEN = 2;
    private char[] characters;
    private int curLen = 0;

    public void ensureCapacity(int minCapacity) {
        int cl = this.characters.length;
        if (cl < minCapacity) {
            cl = cl * 3 / 2 + 1;
            while (cl < minCapacity) {
                cl = cl * 3 / 2 + 1;
            }
            char[] newData = new char[cl];
            System.arraycopy(this.characters, 0, newData, 0, this.curLen);
            this.characters = newData;
        }
    }

    public StringBuilder() {
        this.characters = new char[10];
    }

    public StringBuilder(String aString) {
        this.characters = aString.toCharArray();
        this.curLen = aString.length();
    }

    public StringBuilder(int length) {
        if (length < 0) {
            throw new NegativeArraySizeException("length is negative");
        }
        this.characters = new char[length];
    }

    public StringBuilder delete(int start, int end) {
        if (start < 0 || start > this.curLen) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end < start) {
            throw new StringIndexOutOfBoundsException();
        }
        if (end > this.curLen) {
            end = this.curLen;
        }
        System.arraycopy(this.characters, end, this.characters, start, this.curLen - end);
        this.curLen -= end - start;
        return this;
    }

    public StringBuilder append(String s) {
        return this.appendInternal(s);
    }

    public StringBuilder append(Object aObject) {
        return this.appendInternal(String.valueOf(aObject));
    }

    public StringBuilder append(boolean aBoolean) {
        return this.appendInternal(String.valueOf(aBoolean));
    }

    public StringBuilder append(char aChar) {
        int newLen = this.curLen + 1;
        this.ensureCapacity(newLen);
        this.characters[this.curLen] = aChar;
        this.curLen = newLen;
        return this;
    }

    public StringBuilder append(char[] c) {
        return this.append(c, 0, c.length);
    }

    public StringBuilder append(char[] c, int off, int len) {
        int newLen = this.curLen + len;
        this.ensureCapacity(newLen);
        for (int i = 0; i < len; ++i) {
            this.characters[this.curLen + i] = c[off + i];
        }
        this.curLen = newLen;
        return this;
    }

    public StringBuilder append(CharSequence cs) {
        return this.append(cs, 0, cs.length());
    }

    public StringBuilder append(CharSequence cs, int start, int end) {
        int len = end - start;
        int newLen = this.curLen + len;
        this.ensureCapacity(newLen);
        for (int i = 0; i < len; ++i) {
            this.characters[this.curLen + i] = cs.charAt(start + i);
        }
        this.curLen = newLen;
        return this;
    }

    public StringBuilder append(int i) {
        int intLen = StringUtils.exactStringLength(i, 10);
        int newLen = this.curLen + intLen;
        this.ensureCapacity(newLen);
        StringUtils.getIntChars(this.characters, newLen, i, 10);
        this.curLen = newLen;
        return this;
    }

    public StringBuilder append(long aLong) {
        int intLen = StringUtils.exactStringLength(aLong, 10);
        int newLen = this.curLen + intLen;
        this.ensureCapacity(newLen);
        StringUtils.getLongChars(this.characters, newLen, aLong, 10);
        this.curLen = newLen;
        return this;
    }

    public StringBuilder append(float aFloat) {
        this.ensureCapacity(this.curLen + 15);
        this.curLen = StringUtils.getFloatChars(aFloat, this.characters, this.curLen);
        return this;
    }

    public StringBuilder append(double aDouble) {
        this.ensureCapacity(this.curLen + 25);
        this.curLen = StringUtils.getDoubleChars(aDouble, this.characters, this.curLen);
        return this;
    }

    private StringBuilder appendInternal(String s) {
        if (s == null) {
            s = "null";
        }
        char[] sc = s.characters;
        int sl = sc.length;
        int newlen = this.curLen + sl;
        this.ensureCapacity(newlen);
        System.arraycopy(sc, 0, this.characters, this.curLen, sl);
        this.curLen = newlen;
        return this;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return String.indexOf(this.characters, 0, this.curLen, str.characters, 0, str.characters.length, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.curLen);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.characters, 0, this.curLen, str.characters, 0, str.characters.length, fromIndex);
    }

    public String toString() {
        return new String(this.characters, 0, this.curLen);
    }

    public char charAt(int i) {
        if (i < 0 || i >= this.curLen) {
            throw new StringIndexOutOfBoundsException(i);
        }
        return this.characters[i];
    }

    public void setCharAt(int i, char ch) {
        if (i < 0 || i >= this.curLen) {
            throw new StringIndexOutOfBoundsException(i);
        }
        this.characters[i] = ch;
    }

    public int length() {
        return this.curLen;
    }

    public char[] getChars() {
        char[] r = new char[this.curLen];
        System.arraycopy(this.characters, 0, r, 0, this.curLen);
        return r;
    }

    public String substring(int start) {
        return this.substring(start, this.curLen);
    }

    public String substring(int start, int end) {
        if (start < 0 || start > this.curLen) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.curLen) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (end < start) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        int len = end - start;
        return new String(this.characters, start, len);
    }
}

