/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.location.BTGPSLocationProvider;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.ProximityListener;

public abstract class LocationProvider {
    public static final int AVAILABLE = 1;
    public static final int TEMPORARILY_UNAVAILABLE = 2;
    public static final int OUT_OF_SERVICE = 3;
    protected static final Vector listeners = new Vector();

    protected LocationProvider() {
    }

    public abstract int getState();

    public static LocationProvider getInstance(Criteria criteria) throws LocationException {
        return new BTGPSLocationProvider();
    }

    public abstract Location getLocation(int var1) throws LocationException, InterruptedException;

    public abstract void setLocationListener(LocationListener var1, int var2, int var3, int var4);

    public abstract void reset();

    public static Location getLastKnownLocation() {
        return null;
    }

    public static void addProximityListener(ProximityListener listener, Coordinates coordinates, float proximityRadius) throws LocationException {
        if (listener == null || coordinates == null) {
            throw new NullPointerException();
        }
        if ((double)proximityRadius <= 0.0) {
            throw new IllegalArgumentException();
        }
        Float radius = new Float(proximityRadius);
        Object[] listenerArray = new Object[]{listener, coordinates, radius};
        listeners.addElement(listenerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProximityListener(ProximityListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Vector vector = listeners;
        synchronized (vector) {
            Object[] list = new Object[listeners.size()];
            Enumeration en = listeners.elements();
            int i = 0;
            while (en.hasMoreElements()) {
                list[i] = en.nextElement();
                ++i;
            }
            for (i = 0; i < list.length; ++i) {
                Object[] listenerArray = (Object[])list[i];
                if (!listenerArray[0].equals(listener)) continue;
                listeners.removeElement(listenerArray);
            }
        }
    }
}

