/*
 * Decompiled with CFR 0.152.
 */
package lejos.geom;

import java.awt.geom.Line2D;
import lejos.geom.Point;

public class Line
extends Line2D.Float {
    public Line(float x1, float y1, float x2, float y2) {
        super(x1, y1, x2, y2);
    }

    public Point intersectsAt(Line l) {
        float y;
        float x;
        if (this.y2 == this.y1 && l.y2 == l.y1) {
            return null;
        }
        if (this.x2 == this.x1 && l.x2 == l.x1) {
            return null;
        }
        if (this.x1 == this.x2 && l.y1 == l.y2) {
            x = this.x1;
            y = l.y1;
        } else if (this.y1 == this.y2 && l.x1 == l.x2) {
            x = l.x1;
            y = this.y1;
        } else if (this.y2 == this.y1 || l.y2 == l.y1) {
            float a1 = (this.y2 - this.y1) / (this.x2 - this.x1);
            float b1 = this.y1 - a1 * this.x1;
            float a2 = (l.y2 - l.y1) / (l.x2 - l.x1);
            float b2 = l.y1 - a2 * l.x1;
            if (a1 == a2) {
                return null;
            }
            x = (b2 - b1) / (a1 - a2);
            y = a1 * x + b1;
        } else {
            float a1 = (this.x2 - this.x1) / (this.y2 - this.y1);
            float b1 = this.x1 - a1 * this.y1;
            float a2 = (l.x2 - l.x1) / (l.y2 - l.y1);
            float b2 = l.x1 - a2 * l.y1;
            if (a1 == a2) {
                return null;
            }
            y = (b2 - b1) / (a1 - a2);
            x = a1 * y + b1;
        }
        if (!this.between(x, this.x1, this.x2)) {
            return null;
        }
        if (!this.between(y, this.y1, this.y2)) {
            return null;
        }
        if (!this.between(x, l.x1, l.x2)) {
            return null;
        }
        if (!this.between(y, l.y1, l.y2)) {
            return null;
        }
        return new Point(x, y);
    }

    private boolean between(float x, float x1, float x2) {
        if (x1 <= x2 && x >= x1 && x <= x2) {
            return true;
        }
        return x2 < x1 && x >= x2 && x <= x1;
    }

    public float length() {
        return (float)Math.sqrt((this.x1 - this.x2) * (this.x1 - this.x2) + (this.y1 - this.y2) * (this.y1 - this.y2));
    }
}

