/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import java.util.BitSet;
import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;

public class IRLink
extends I2CSensor {
    private static final byte TX_BUFFER = 64;
    private static final byte TX_BUFFER_LEN = 77;
    private static final byte TX_MODE = 78;
    private static final byte TX_BUFFER_FLAG = 79;
    private static final byte TX_MAX_BUFFER_LEN = 13;
    private static final byte TX_MODE_RCX = 0;
    private static final byte TX_MODE_TRAIN = 1;
    private static final byte TX_MODE_PF = 2;
    public static final byte PF_MODE_COMBO_DIRECT = 1;
    private final byte MAX_BITS = (byte)104;
    private final byte STOP_START_PAUSE = (byte)7;
    private final byte LOW_BIT_PAUSE = (byte)2;
    private final byte HIGH_BIT_PAUSE = (byte)4;
    public static final byte PF_FLOAT = 0;
    public static final byte PF_FORWARD = 1;
    public static final byte PF_BACKWARD = 2;
    public static final byte PF_BRAKE = 3;
    private byte toggle = 0;
    private BitSet bits = new BitSet(104);
    private int nextBit = 0;

    public IRLink(I2CPort port) {
        super(port);
    }

    public void sendPFComboDirect(int channel, int opA, int opB) {
        this.sendPFCommand(channel, 1, opB << 2 | opA);
    }

    private void sendPFCommand(int channel, int mode, int data) {
        byte nibble1 = (byte)(this.toggle << 3 | channel);
        byte lrc = (byte)(0xF ^ nibble1 ^ mode ^ data);
        int pfData = nibble1 << 12 | mode << 8 | data << 4 | lrc;
        this.clearBits();
        this.nextBit = 0;
        this.setBit(7);
        for (int i = 15; i >= 0; --i) {
            this.setBit((pfData >> i & 1) == 0 ? 2 : 4);
        }
        this.setBit(7);
        this.toggle = (byte)(this.toggle ^ 1);
        byte[] pfCommand = new byte[16];
        for (int i = 0; i < 104; ++i) {
            boolean bit = this.bits.get(i);
            int byteIndex = i / 8;
            int bitVal = bit ? 1 : 0;
            int n = byteIndex;
            pfCommand[n] = (byte)(pfCommand[n] | bitVal << 7 - i % 8);
        }
        pfCommand[13] = 13;
        pfCommand[14] = 2;
        pfCommand[15] = 1;
        this.sendData(64, pfCommand, 16);
    }

    private void setBit(int pause) {
        this.bits.set(this.nextBit++);
        this.nextBit += pause;
    }

    private void clearBits() {
        for (int i = 0; i < 104; ++i) {
            this.bits.clear(i);
        }
    }
}

