/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.mapping;

import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lejos.geom.Line;
import lejos.geom.Point;
import lejos.robotics.Pose;
import lejos.robotics.mapping.RangeMap;

public class LineMap
implements RangeMap {
    private Line[] lines;
    private Rectangle boundingRect;

    public float range(Pose pose) {
        Line l = new Line(pose.getX(), pose.getY(), pose.getX() + 254.0f * (float)Math.cos(Math.toRadians(pose.getHeading())), pose.getY() + 254.0f * (float)Math.sin(Math.toRadians(pose.getHeading())));
        Line rl = null;
        for (int i = 0; i < this.lines.length; ++i) {
            Point p = this.lines[i].intersectsAt(l);
            if (p == null) continue;
            Line tl = new Line(pose.getX(), pose.getY(), p.x, p.y);
            if (rl != null && !(tl.length() < rl.length())) continue;
            rl = tl;
        }
        return rl == null ? -1.0f : rl.length();
    }

    public LineMap(Line[] lines, Rectangle boundingRect) {
        this.lines = lines;
        this.boundingRect = boundingRect;
    }

    public LineMap() {
    }

    public boolean inside(Point p) {
        if (p.x < (float)this.boundingRect.x || p.y < (float)this.boundingRect.y) {
            return false;
        }
        if (p.x > (float)(this.boundingRect.x + this.boundingRect.width) || p.y > (float)(this.boundingRect.y + this.boundingRect.height)) {
            return false;
        }
        Line l = new Line(p.x, p.y, p.x - (float)this.boundingRect.width, p.y);
        int count = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            if (this.lines[i].intersectsAt(l) == null) continue;
            ++count;
        }
        return count % 2 == 1;
    }

    public Rectangle getBoundingRect() {
        return this.boundingRect;
    }

    public void dumpMap(DataOutputStream dos) throws IOException {
        dos.writeInt(this.lines.length);
        for (int i = 0; i < this.lines.length; ++i) {
            dos.writeFloat(this.lines[i].x1);
            dos.writeFloat(this.lines[i].y1);
            dos.writeFloat(this.lines[i].x2);
            dos.writeFloat(this.lines[i].y2);
            dos.flush();
        }
        dos.writeInt(this.boundingRect.x);
        dos.writeInt(this.boundingRect.y);
        dos.writeInt(this.boundingRect.width);
        dos.writeInt(this.boundingRect.height);
        dos.flush();
    }

    public void loadMap(DataInputStream dis) throws IOException {
        this.lines = new Line[dis.readInt()];
        for (int i = 0; i < this.lines.length; ++i) {
            float x1 = dis.readFloat();
            float y1 = dis.readFloat();
            float x2 = dis.readFloat();
            float y2 = dis.readFloat();
            this.lines[i] = new Line(x1, y1, x2, y2);
        }
        this.boundingRect = new Rectangle(dis.readInt(), dis.readInt(), dis.readInt(), dis.readInt());
    }
}

