/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.proposal;

import java.util.ArrayList;
import lejos.nxt.Battery;
import lejos.robotics.MoveListener;
import lejos.robotics.Movement;
import lejos.robotics.TachoMotor;
import lejos.robotics.proposal.ArcRotatePilot;

public class DifferentialPilot
implements ArcRotatePilot {
    protected boolean _alert = false;
    protected ArrayList<MoveListener> listeners = new ArrayList();
    protected Movement.MovementType _moveType;
    private Monitor monitor = new Monitor();
    protected final TachoMotor _left;
    protected final TachoMotor _right;
    protected final float _leftDegPerDistance;
    protected final float _rightDegPerDistance;
    protected final float _leftTurnRatio;
    protected final float _rightTurnRatio;
    protected float _robotMoveSpeed;
    protected float _robotTurnSpeed;
    protected int _motorSpeed;
    protected byte _parity;
    protected boolean _regulating = true;
    protected final float _trackWidth;
    protected final float _leftWheelDiameter;
    protected final float _rightWheelDiameter;
    protected float _minRadius = 0.0f;

    public DifferentialPilot(float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor) {
        this(wheelDiameter, trackWidth, leftMotor, rightMotor, false);
    }

    public DifferentialPilot(float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor, boolean reverse) {
        this(wheelDiameter, wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
    }

    public DifferentialPilot(float leftWheelDiameter, float rightWheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor, boolean reverse) {
        this._left = leftMotor;
        this._leftWheelDiameter = leftWheelDiameter;
        this._leftTurnRatio = trackWidth / leftWheelDiameter;
        this._leftDegPerDistance = 360.0f / ((float)Math.PI * leftWheelDiameter);
        this._right = rightMotor;
        this._rightWheelDiameter = rightWheelDiameter;
        this._rightTurnRatio = trackWidth / rightWheelDiameter;
        this._rightDegPerDistance = 360.0f / ((float)Math.PI * rightWheelDiameter);
        this._trackWidth = trackWidth;
        this._parity = (byte)(reverse ? -1 : 1);
        this.setSpeed(360);
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    public void addMoveListener(MoveListener aListener) {
        this.listeners.add(aListener);
    }

    public TachoMotor getLeft() {
        return this._left;
    }

    public TachoMotor getRight() {
        return this._right;
    }

    public int getLeftCount() {
        return this._parity * this._left.getTachoCount();
    }

    public int getRightCount() {
        return this._parity * this._right.getTachoCount();
    }

    public int getLeftActualSpeed() {
        return this._left.getRotationSpeed();
    }

    public int getRightActualSpeed() {
        return this._right.getRotationSpeed();
    }

    public float getTurnRatio() {
        return (this._leftTurnRatio + this._rightTurnRatio) / 2.0f;
    }

    public void setSpeed(int speed) {
        this._motorSpeed = speed;
        this._robotMoveSpeed = (float)speed / Math.max(this._leftDegPerDistance, this._rightDegPerDistance);
        this._robotTurnSpeed = (float)speed / Math.max(this._leftTurnRatio, this._rightTurnRatio);
        this.setSpeed(speed, speed);
    }

    protected void setSpeed(int leftSpeed, int rightSpeed) {
        this._left.regulateSpeed(this._regulating);
        this._left.smoothAcceleration(!this.isMoving());
        this._right.regulateSpeed(this._regulating);
        this._right.smoothAcceleration(!this.isMoving());
        this._left.setSpeed(leftSpeed);
        this._right.setSpeed(rightSpeed);
    }

    public void setMoveSpeed(float speed) {
        this._robotMoveSpeed = speed;
        this._motorSpeed = Math.round(0.5f * speed * (this._leftDegPerDistance + this._rightDegPerDistance));
        this.setSpeed(Math.round(speed * this._leftDegPerDistance), Math.round(speed * this._rightDegPerDistance));
    }

    public float getMoveSpeed() {
        return this._robotMoveSpeed;
    }

    public float getMoveMaxSpeed() {
        return Battery.getVoltage() * 100.0f / Math.max(this._leftDegPerDistance, this._rightDegPerDistance);
    }

    public void setTurnSpeed(float speed) {
        this._robotTurnSpeed = speed;
        this.setSpeed(Math.round(speed * this._leftTurnRatio), Math.round(speed * this._rightTurnRatio));
    }

    public float getTurnSpeed() {
        return this._robotTurnSpeed;
    }

    public float getTurnMaxSpeed() {
        return Battery.getVoltage() * 100.0f / Math.max(this._leftTurnRatio, this._rightTurnRatio);
    }

    public boolean isMoving() {
        return this._left.isMoving() || this._right.isMoving();
    }

    public float getTravelDistance() {
        float left = (float)this._left.getTachoCount() / this._leftDegPerDistance;
        float right = (float)this._right.getTachoCount() / this._rightDegPerDistance;
        return (float)this._parity * (left + right) / 2.0f;
    }

    public float getAngle() {
        float angle = (float)this._parity * ((float)this._right.getTachoCount() / this._rightTurnRatio - (float)this._left.getTachoCount() / this._leftTurnRatio) / 2.0f;
        return angle;
    }

    public void reset() {
        this._left.resetTachoCount();
        this._right.resetTachoCount();
    }

    public void forward() {
        if (this.isMoving()) {
            this.stop();
        }
        this._moveType = Movement.MovementType.TRAVEL;
        this.movementStart();
        this.reset();
        this.setSpeed(Math.round(this._robotMoveSpeed * this._leftDegPerDistance), Math.round(this._robotMoveSpeed * this._rightDegPerDistance));
        if (this._parity == 1) {
            this.fwd();
        } else {
            this.bak();
        }
    }

    public void backward() {
        if (this.isMoving()) {
            this.stop();
        }
        this._moveType = Movement.MovementType.TRAVEL;
        this.movementStart();
        this.reset();
        this.setSpeed(Math.round(this._robotMoveSpeed * this._leftDegPerDistance), Math.round(this._robotMoveSpeed * this._rightDegPerDistance));
        if (this._parity == 1) {
            this.bak();
        } else {
            this.fwd();
        }
    }

    private void fwd() {
        this._left.forward();
        this._right.forward();
    }

    private void bak() {
        this._left.backward();
        this._right.backward();
    }

    public Movement rotate(float angle) {
        return this.rotate(angle, false);
    }

    public Movement rotate(float angle, boolean immediateReturn) {
        if (this.isMoving()) {
            this.stop();
        }
        this._moveType = Movement.MovementType.ROTATE;
        this.reset();
        this.movementStart();
        this._alert = immediateReturn;
        this.setSpeed(Math.round(this._robotTurnSpeed * this._leftTurnRatio), Math.round(this._robotTurnSpeed * this._rightTurnRatio));
        int rotateAngleLeft = this._parity * (int)(angle * this._leftTurnRatio);
        int rotateAngleRight = this._parity * (int)(angle * this._rightTurnRatio);
        this._left.rotate(-rotateAngleLeft, true);
        this._right.rotate(rotateAngleRight, immediateReturn);
        if (!immediateReturn) {
            while (this.isMoving()) {
                Thread.yield();
            }
            this.stop();
        }
        return this.getMovement();
    }

    protected boolean continueMoving() {
        return true;
    }

    public Movement stop() {
        this._alert = false;
        this._left.stop();
        this._right.stop();
        while (this.isMoving()) {
            Thread.yield();
        }
        this.movementStop();
        return this.getMovement();
    }

    public Movement travel(float distance) {
        return this.travel(distance, false);
    }

    public Movement travel(float distance, boolean immediateReturn) {
        if (this.isMoving()) {
            this.stop();
        }
        this._moveType = Movement.MovementType.TRAVEL;
        this.reset();
        this.movementStart();
        this._alert = immediateReturn;
        this.setSpeed(Math.round(this._robotMoveSpeed * this._leftDegPerDistance), Math.round(this._robotMoveSpeed * this._rightDegPerDistance));
        this._left.rotate((int)((float)this._parity * distance * this._leftDegPerDistance), true);
        this._right.rotate((int)((float)this._parity * distance * this._rightDegPerDistance), true);
        this._alert = immediateReturn;
        if (!immediateReturn) {
            while (this.isMoving() && this.continueMoving()) {
                Thread.yield();
            }
            this.stop();
        }
        return this.getMovement();
    }

    public void steer(float turnRate) {
        this.steer(turnRate, Float.POSITIVE_INFINITY, true);
    }

    public Movement steer(float turnRate, float angle) {
        return this.steer(turnRate, angle, false);
    }

    public Movement steer(float turnRate, float angle, boolean immediateReturn) {
        TachoMotor outside;
        TachoMotor inside;
        if (this.isMoving()) {
            this.stop();
        }
        this._moveType = Movement.MovementType.ARC;
        this.reset();
        this.movementStart();
        this._alert = immediateReturn;
        float rate = turnRate;
        if (rate < -200.0f) {
            rate = -200.0f;
        } else if (rate > 200.0f) {
            rate = 200.0f;
        } else if (rate == 0.0f) {
            if (angle < 0.0f) {
                this.backward();
            } else {
                this.forward();
            }
            return this.getMovement();
        }
        if (turnRate < 0.0f) {
            inside = this._right;
            outside = this._left;
            rate = -rate;
        } else {
            inside = this._left;
            outside = this._right;
        }
        outside.setSpeed(this._motorSpeed);
        float steerRatio = 1.0f - rate / 100.0f;
        inside.setSpeed((int)((float)this._motorSpeed * steerRatio));
        if (angle == Float.POSITIVE_INFINITY) {
            if (this._parity == 1) {
                outside.forward();
            } else {
                outside.backward();
            }
            if ((float)this._parity * steerRatio > 0.0f) {
                inside.forward();
            } else {
                inside.backward();
            }
            return this.getMovement();
        }
        float rotAngle = angle * this._trackWidth * 2.0f / (this._leftWheelDiameter * (1.0f - steerRatio));
        inside.rotate(this._parity * (int)(rotAngle * steerRatio), true);
        outside.rotate(this._parity * (int)rotAngle, true);
        if (!immediateReturn) {
            while (this.isMoving() && this.continueMoving()) {
                Thread.yield();
            }
            this.stop();
        }
        return this.getMovement();
    }

    public void arc(float radius) {
        this.steer(this.turnRate(radius));
    }

    public Movement arc(float radius, float angle) {
        return this.steer(this.turnRate(radius), angle);
    }

    public Movement arc(float radius, float angle, boolean immediateReturn) {
        return this.steer(this.turnRate(radius), angle, immediateReturn);
    }

    public Movement travelArc(float radius, float distance) {
        return this.travelArc(radius, distance, false);
    }

    public Movement travelArc(float radius, float distance, boolean immediateReturn) {
        double angle = (double)(distance * 180.0f) / (Math.PI * (double)radius);
        return this.arc(radius, (float)angle, immediateReturn);
    }

    protected int turnRate(float radius) {
        float radiusToUse;
        int direction;
        if (radius < 0.0f) {
            direction = -1;
            radiusToUse = -radius;
        } else {
            direction = 1;
            radiusToUse = radius;
        }
        float ratio = (2.0f * radiusToUse - this._trackWidth) / (2.0f * radiusToUse + this._trackWidth);
        return Math.round((float)(direction * 100) * (1.0f - ratio));
    }

    protected void movementStart() {
        for (MoveListener p : this.listeners) {
            p.movementStarted(new Movement(this._moveType, 0.0f, 0.0f, true), this);
        }
    }

    protected void movementStop() {
        for (MoveListener p : this.listeners) {
            Movement move = new Movement(this._moveType, this.getTravelDistance(), this.getAngle(), false);
            p.movementStopped(move, this);
        }
    }

    public void setMinRadius(float radius) {
        this._minRadius = radius;
    }

    public float getMinRadius() {
        return this._minRadius;
    }

    public Movement getMovement() {
        return new Movement(this._moveType, this.getTravelDistance(), this.getAngle(), this.isMoving());
    }

    public float getMovementIncrement() {
        return 0.0f;
    }

    public float getAngleIncrement() {
        return 0.0f;
    }

    private class Monitor
    extends Thread {
        private Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (!DifferentialPilot.this._alert) {
                    Thread.yield();
                    continue;
                }
                while (!DifferentialPilot.this.isMoving()) {
                    Thread.yield();
                }
                while (DifferentialPilot.this.isMoving()) {
                    Thread.yield();
                }
                Monitor monitor = DifferentialPilot.this.monitor;
                synchronized (monitor) {
                    if (DifferentialPilot.this._alert) {
                        DifferentialPilot.this._alert = false;
                        DifferentialPilot.this.movementStop();
                    }
                }
            }
        }
    }
}

