/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.proposal;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import lejos.geom.Point;
import lejos.robotics.Pose;
import lejos.robotics.RangeReading;
import lejos.robotics.RangeReadings;
import lejos.robotics.mapping.RangeMap;
import lejos.robotics.proposal.DestinationUnreachableException;
import lejos.robotics.proposal.PathFinder;
import lejos.robotics.proposal.WayPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPathFinder
extends ArrayList<WayPoint>
implements PathFinder {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ITERATIONS = 1000;
    private static final float MAX_DISTANCE = 40.0f;
    private static final float MIN_GAIN = 10.0f;
    private static final float MAX_RANGE = 100.0f;
    private static int BORDER = 20;
    private RangeMap map;
    private RangeReadings readings;

    public MapPathFinder(RangeMap map, RangeReadings readings) {
        this.map = map;
        this.readings = readings;
    }

    @Override
    public Collection<WayPoint> findRoute(Pose start, Point destination) throws DestinationUnreachableException {
        return null;
    }

    @Override
    public Collection<WayPoint> findRoute(Pose start, Pose destination) throws DestinationUnreachableException {
        Pose pose = start;
        while (true) {
            if (pose.distanceTo(destination.getLocation()) < 40.0f) {
                this.add(new WayPoint(destination));
                return this;
            }
            Pose testPose = null;
            for (int i = 0; i < 1000; ++i) {
                testPose = this.generatePose();
                if (testPose.distanceTo(pose.getLocation()) > 40.0f || pose.distanceTo(destination.getLocation()) - testPose.distanceTo(destination.getLocation()) < 10.0f) continue;
                float heading = testPose.getHeading();
                boolean validReadings = true;
                for (RangeReading r : this.readings) {
                    testPose.setHeading(heading + r.getAngle());
                    float range = this.map.range(testPose);
                    if (!(range > 100.0f)) continue;
                    validReadings = false;
                    break;
                }
                if (!validReadings) continue;
                testPose.setHeading(testPose.angleTo(pose.getLocation()));
                if (this.map.range(testPose) < testPose.distanceTo(pose.getLocation())) continue;
                testPose.setHeading(heading);
                break;
            }
            if (testPose == null) {
                throw new DestinationUnreachableException();
            }
            this.add(new WayPoint(testPose));
            pose = testPose;
        }
    }

    private Pose generatePose() {
        float y;
        float x;
        Rectangle boundingRect = this.map.getBoundingRect();
        Rectangle innerRect = new Rectangle(boundingRect.x + BORDER, boundingRect.y + BORDER, boundingRect.width - BORDER * 2, boundingRect.height - BORDER * 2);
        while (!this.map.inside(new Point(x = (float)innerRect.x + (float)Math.random() * (float)innerRect.width, y = (float)innerRect.y + (float)Math.random() * (float)innerRect.height))) {
        }
        float heading = (float)Math.random() * 360.0f;
        return new Pose(x, y, heading);
    }
}

