/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.proposal;

import lejos.geom.Point;
import lejos.robotics.MoveListener;
import lejos.robotics.Movement;
import lejos.robotics.MovementProvider;
import lejos.robotics.Pose;

public class UpdateablePose
extends Pose
implements MoveListener {
    protected boolean _current = true;
    protected MovementProvider pilot;
    protected float _angle0;
    protected float _distance0;

    public UpdateablePose() {
    }

    public UpdateablePose(float x, float y, float heading) {
        super(x, y, heading);
    }

    public void movementStarted(Movement move, MovementProvider p) {
        this._current = false;
        this._angle0 = 0.0f;
        this._distance0 = 0.0f;
        this.pilot = p;
    }

    public void movementStopped(Movement move, MovementProvider p) {
        this.update(move);
    }

    protected synchronized void update(Movement move) {
        float angle = move.getAngleTurned();
        float distance = move.getDistanceTraveled();
        Movement.MovementType type = move.getMovementType();
        if (type == Movement.MovementType.ROTATE) {
            this.rotateUpdate(angle - this._angle0);
        } else if (type == Movement.MovementType.TRAVEL) {
            this.moveUpdate(distance - this._distance0);
        } else if (type == Movement.MovementType.ARC) {
            this.arcUpdate(distance - this._distance0, angle - this._angle0);
        }
        this._current = move.isMoving();
        this._angle0 = angle;
        this._distance0 = distance;
    }

    public float getHeading() {
        if (!this._current) {
            this.update(this.pilot.getMovement());
        }
        return this._heading;
    }

    public float getX() {
        if (!this._current) {
            this.update(this.pilot.getMovement());
        }
        return (float)this._location.getX();
    }

    public float getY() {
        if (!this._current) {
            this.update(this.pilot.getMovement());
        }
        return (float)this._location.getY();
    }

    public Point getLocation() {
        if (!this._current) {
            this.update(this.pilot.getMovement());
        }
        return this._location;
    }

    public void setLocation(Point p) {
        this._location = p;
        this._current = true;
    }

    public void setHeading(float heading) {
        this._heading = heading;
        this._current = true;
    }

    public void setPilot(MovementProvider aPilot) {
        this.pilot = aPilot;
    }

    public boolean isCurrent() {
        return this._current;
    }
}

