/*
 * Decompiled with CFR 0.152.
 */
package lejos.addon.gps;

import java.util.StringTokenizer;

public abstract class NMEASentence {
    static byte checksum;
    protected String nmeaSentence = null;
    protected StringTokenizer st;
    private long timeStamp = -1L;

    public abstract String getHeader();

    public void setSentence(String sentence) {
        this.timeStamp = System.currentTimeMillis();
        this.nmeaSentence = sentence;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    protected synchronized void checkRefresh() {
        if (this.nmeaSentence != null) {
            int end = this.nmeaSentence.indexOf(42);
            if (end < 0) {
                end = this.nmeaSentence.length();
            }
            String nmeaSub = this.nmeaSentence.substring(0, end);
            this.parse(nmeaSub);
            this.nmeaSentence = null;
        }
    }

    protected abstract void parse(String var1);

    public static boolean isValid(String sentence) {
        int end = sentence.indexOf(42);
        String checksumStr = sentence.substring(end + 1, end + 3);
        byte checksumByte = NMEASentence.convertChecksum(checksumStr);
        return checksumByte == NMEASentence.calcChecksum(sentence);
    }

    private static byte calcChecksum(String sentence) {
        int start = sentence.indexOf(36);
        int end = sentence.indexOf(42);
        if (end < 0) {
            end = sentence.length();
        }
        byte checksum = (byte)sentence.charAt(start + 1);
        for (int index = start + 2; index < end; ++index) {
            checksum = (byte)(checksum ^ (byte)sentence.charAt(index));
        }
        return checksum;
    }

    private static byte convertChecksum(String checksum_string) {
        byte checksum = (byte)((NMEASentence.hexCharToByte(checksum_string.charAt(0)) & 0xF) << 4);
        checksum = (byte)(checksum | NMEASentence.hexCharToByte(checksum_string.charAt(1)) & 0xF);
        return checksum;
    }

    private static byte hexCharToByte(char hex_char) {
        if (hex_char > '9') {
            return (byte)(hex_char - 55);
        }
        return (byte)(hex_char - 48);
    }

    protected double degreesMinToDegrees(String dd_mm) {
        int dotPosition = dd_mm.indexOf(46);
        double degrees = Double.parseDouble(dd_mm.substring(0, dotPosition - 2));
        double minutes = Double.parseDouble(dd_mm.substring(dotPosition - 2));
        return degrees + minutes / 60.0;
    }
}

