/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.ButtonListener;
import lejos.nxt.ListenerCaller;
import lejos.nxt.ListenerThread;
import lejos.nxt.Sound;
import lejos.nxt.SystemSettings;
import lejos.util.Delay;

public class Button
implements ListenerCaller {
    public static final int ID_ENTER = 1;
    public static final int ID_LEFT = 2;
    public static final int ID_RIGHT = 4;
    public static final int ID_ESCAPE = 8;
    private int iCode;
    private ButtonListener[] iListeners;
    private int iNumListeners;
    private static int[] clickFreq = new int[16];
    private static int clickVol;
    private static int clickLen;
    private static int curButtons;
    public static final String VOL_SETTING = "lejos.keyclick_volume";
    public static final Button ENTER;
    public static final Button LEFT;
    public static final Button RIGHT;
    public static final Button ESCAPE;
    public static final Button[] BUTTONS;

    private Button(int aCode) {
        this.iCode = aCode;
    }

    public final int getId() {
        return this.iCode;
    }

    public final boolean isPressed() {
        return (Button.readButtons() & this.iCode) != 0;
    }

    public final void waitForPressAndRelease() {
        while (!this.isPressed()) {
            Delay.msDelay(50L);
        }
        while (this.isPressed()) {
            Thread.yield();
        }
    }

    public static int waitForPress(int timeout) {
        long end = timeout == 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)timeout;
        int button = 0;
        while (0 < Button.readButtons()) {
            Delay.msDelay(50L);
            if (System.currentTimeMillis() <= end) continue;
            return 0;
        }
        while (0 == (button = Button.readButtons())) {
            Delay.msDelay(50L);
            if (System.currentTimeMillis() <= end) continue;
            return 0;
        }
        while (0 < Button.readButtons()) {
            Thread.yield();
        }
        return button;
    }

    public static int waitForPress() {
        return Button.waitForPress(0);
    }

    public synchronized void addButtonListener(ButtonListener aListener) {
        if (this.iListeners == null) {
            this.iListeners = new ButtonListener[4];
        }
        this.iListeners[this.iNumListeners++] = aListener;
        ListenerThread.get().addButtonToMask(this.iCode, this);
    }

    static native int getButtons();

    public static int readButtons() {
        int tone;
        int newButtons = Button.getButtons();
        if (newButtons != curButtons && clickVol != 0 && (tone = clickFreq[newButtons]) != 0) {
            Sound.playTone(tone, clickLen, -clickVol);
        }
        curButtons = newButtons;
        return newButtons;
    }

    public synchronized void callListeners() {
        for (int i = 0; i < this.iNumListeners; ++i) {
            if (this.isPressed()) {
                this.iListeners[i].buttonPressed(this);
                continue;
            }
            this.iListeners[i].buttonReleased(this);
        }
    }

    public static void setKeyClickVolume(int vol) {
        clickVol = vol;
    }

    public static int getKeyClickVolume() {
        return clickVol;
    }

    public static void setKeyClickLength(int len) {
        clickLen = len;
    }

    public static int getKeyClickLength() {
        return clickLen;
    }

    public static void setKeyClickTone(int key, int freq) {
        Button.clickFreq[key] = freq;
    }

    public static int getKeyClickTone(int key) {
        return clickFreq[key];
    }

    public static void loadSettings() {
        clickVol = SystemSettings.getIntSetting(VOL_SETTING, 20);
        clickLen = 50;
        Button.clickFreq[1] = 906;
        Button.clickFreq[2] = 979;
        Button.clickFreq[4] = 1061;
        Button.clickFreq[8] = 1150;
        Button.clickFreq[3] = 1403;
        Button.clickFreq[5] = 1485;
        Button.clickFreq[9] = 1574;
    }

    static {
        curButtons = 0;
        Button.loadSettings();
        ENTER = new Button(1);
        LEFT = new Button(2);
        RIGHT = new Button(4);
        ESCAPE = new Button(8);
        BUTTONS = new Button[]{ENTER, LEFT, RIGHT, ESCAPE};
    }
}

