/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.FlashError;
import lejos.nxt.NXT;

public class Flash {
    public static final int MAX_USER_PAGES = NXT.getUserPages();
    public static short BYTES_PER_PAGE = (short)256;

    private Flash() {
    }

    static native int flashReadPage(byte[] var0, int var1);

    static native int flashWritePage(byte[] var0, int var1);

    static native int flashExec(int var0, int var1);

    public static void readPage(byte[] buf, int pageNum) throws FlashError {
        if (Flash.flashReadPage(buf, pageNum) < 0) {
            throw new FlashError("FRead:Bad address");
        }
    }

    public static void writePage(byte[] buf, int pageNum) throws FlashError {
        String msg;
        int ret = Flash.flashWritePage(buf, pageNum);
        if (ret >= 0) {
            return;
        }
        switch (ret) {
            case -1: {
                msg = "FWrite:TWI";
                break;
            }
            case -2: {
                msg = "FWrite:FTO";
                break;
            }
            case -3: {
                msg = "FWrite:Bad address";
                break;
            }
            default: {
                msg = "FWrite:Unkown" + ret;
            }
        }
        throw new FlashError(msg);
    }

    public static void exec(int pageNum, int size) throws FlashError {
        if (Flash.flashExec(pageNum, size) < 0) {
            throw new FlashError("FExec");
        }
    }
}

