/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.localization;

import java.util.Random;
import lejos.geom.Point;
import lejos.robotics.Movement;
import lejos.robotics.Pose;
import lejos.robotics.RangeReadings;
import lejos.robotics.mapping.RangeMap;

public class MCLParticle {
    private static Random rand = new Random();
    private Pose pose;
    private float weight = 0.0f;

    public MCLParticle(Pose pose) {
        this.pose = pose;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public float getWeight() {
        return this.weight;
    }

    public Pose getPose() {
        return this.pose;
    }

    public void calculateWeight(RangeReadings rr, RangeMap map, float divisor) {
        this.weight = 1.0f;
        Pose tempPose = new Pose();
        tempPose.setLocation(this.pose.getLocation());
        for (int i = 0; i < rr.getNumReadings(); ++i) {
            float angle = rr.getAngle(i);
            tempPose.setHeading(this.pose.getHeading() + angle);
            float robotReading = rr.getRange(i);
            float range = map.range(tempPose);
            if (range < 0.0f) {
                this.weight = 0.0f;
                return;
            }
            float diff = robotReading - range;
            this.weight *= (float)Math.exp(-(diff * diff) / divisor);
        }
    }

    public float getReading(int i, RangeReadings rr, RangeMap map) {
        Pose tempPose = new Pose();
        tempPose.setLocation(this.pose.getLocation());
        tempPose.setHeading(this.pose.getHeading() + rr.getAngle(i));
        return map.range(tempPose);
    }

    public void applyMove(Movement move, float distanceNoiseFactor, float angleNoiseFactor) {
        float ym = move.getDistanceTraveled() * (float)Math.sin(Math.toRadians(this.pose.getHeading()));
        float xm = move.getDistanceTraveled() * (float)Math.cos(Math.toRadians(this.pose.getHeading()));
        this.pose.setLocation(new Point((float)((double)(this.pose.getX() + xm) + (double)(distanceNoiseFactor * xm) * rand.nextGaussian()), (float)((double)(this.pose.getY() + ym) + (double)(distanceNoiseFactor * ym) * rand.nextGaussian())));
        this.pose.setHeading((float)((double)(this.pose.getHeading() + move.getAngleTurned()) + (double)(angleNoiseFactor * move.getAngleTurned()) * rand.nextGaussian()));
        this.pose.setHeading((int)(this.pose.getHeading() + 0.5f) % 360);
    }
}

