/*
 * Decompiled with CFR 0.152.
 */
package lejos.util;

import lejos.nxt.LCD;

public class DebugMessages {
    private int lineCounter = 0;
    private final int maximumLCDLines = 7;
    private int LCDLines = 7;
    private int delayMS = 250;
    private boolean delayEnabled = false;

    public DebugMessages() {
    }

    public DebugMessages(int init) {
        this.lineCounter = init;
    }

    public void setLCDLines(int lines) {
        if (lines <= 7) {
            this.LCDLines = lines;
        }
    }

    public void setDelayEnabled(boolean de) {
        this.delayEnabled = de;
    }

    public void setDelay(int dMs) {
        this.delayMS = dMs;
    }

    public void echo(String message) {
        if (this.lineCounter > this.LCDLines) {
            this.lineCounter = 0;
            LCD.clear();
        } else {
            LCD.drawString(message, 0, this.lineCounter);
            LCD.refresh();
            ++this.lineCounter;
        }
        if (this.delayEnabled) {
            try {
                Thread.sleep(this.delayMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void echo(int message) {
        if (this.lineCounter > this.LCDLines) {
            this.lineCounter = 0;
            LCD.clear();
        } else {
            LCD.drawInt(message, 0, this.lineCounter);
            LCD.refresh();
            ++this.lineCounter;
        }
        if (this.delayEnabled) {
            try {
                Thread.sleep(this.delayMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        LCD.clear();
        this.lineCounter = 0;
        if (this.delayEnabled) {
            try {
                Thread.sleep(this.delayMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

