package etrobo.sample2010;

import lejos.nxt.*;

public class Setting {
	static Variables var = Variables.getInsatnce();
	static int Y_KP = 1;
	static int Y_KD = 2;
	static int Y_KI = 3;
	static int Y_SPEED = 4;
	static int Y_TURN = 5;
	static int Y_COURE = 5;

	double kp, kd, ki;

	public void setParameters(Variables var, TouchSensor touch) {
		LCD.clear();
		LCD.drawString("Push touch sensor!", 0, 0);
		while (touch.isPressed() == false)
			; /* タッチセンサ押下待機 */

		LCD.clear();
		LCD.drawString("PID Parameters", 0, 0);
		setKP(var);
		setKD(var);
//		setKI(var);
		setForward(var);
//		setMaxTurn(var);
		setCourse(var);

		LCD.clear();
		LCD.drawString("Push touch sensor to start!", 0, 0);
	}

	private void setKP(Variables var) {
		LCD.drawString("set KP : ", 1, Y_KP);
		LCD.drawInt((int)var.getKP(), 3, 10, Y_KP);
		int button;
		while((button = this.getButtonID()) != Button.ID_ENTER) {
			switch(button) {
			case Button.ID_RIGHT:
				var.setKP(var.getKP() + 1);
				break;
			case Button.ID_LEFT:
				var.setKP(var.getKP() - 1);
				break;
			}
			LCD.drawInt((int)var.getKP(), 3, 10, Y_KP);
		}
		LCD.drawInt((int)var.getKP(), 3, 10, Y_KP);
	}

	private void setKD(Variables var) {
		LCD.drawString("set KD : ", 1, Y_KD);
		LCD.drawInt((int)var.getKD(), 3, 10, Y_KD);
		int button;
		while((button = this.getButtonID()) != Button.ID_ENTER) {
			switch(button) {
			case Button.ID_RIGHT:
				var.setKD(var.getKD() + 1000);
				break;
			case Button.ID_LEFT:
				var.setKD(var.getKD() - 1000);
				break;
			}
			LCD.drawInt((int)var.getKD(), 3, 10, Y_KD);
		}
		LCD.drawInt((int)var.getKD(), 3, 10, Y_KD);
	}

	private void setKI(Variables var) {
		LCD.drawString("set KI : ", 1, Y_KI);
		LCD.drawInt((int)var.getKI(), 3, 10, Y_KI);
		int button;
		while((button = this.getButtonID()) != Button.ID_ENTER) {
			switch(button) {
			case Button.ID_RIGHT:
				var.setKI(var.getKI() + 1);
				break;
			case Button.ID_LEFT:
				var.setKI(var.getKI() - 1);
				break;
			}
			LCD.drawInt((int)var.getKI(), 3, 10, Y_KI);
		}
		LCD.drawInt((int)var.getKI(), 3, 10, Y_KI);
	}

	private void setForward(Variables var) {
		LCD.drawString("set Speed:", 1, Y_SPEED);
		LCD.drawInt((int)var.getForward(), 5, 10, Y_SPEED);
		int button;
		while((button = this.getButtonID()) != Button.ID_ENTER) {
			switch(button) {
			case Button.ID_RIGHT:
				var.setForward(var.getForward() + 1);
				break;
			case Button.ID_LEFT:
				var.setForward(var.getForward() - 1);
				break;
			}
			LCD.drawInt((int)var.getForward(), 5, 10, Y_SPEED);
		}
		LCD.drawInt((int)var.getForward(), 5, 10, Y_SPEED);
	}

	private void setMaxTurn(Variables var) {
		LCD.drawString("set Turn:", 1, Y_TURN);
		LCD.drawInt((int)var.getMaxTurn(), 5, 10, Y_TURN);
		int button;
		while((button = this.getButtonID()) != Button.ID_ENTER) {
			switch(button) {
			case Button.ID_RIGHT:
				var.setMaxTurn(var.getMaxTurn() + 1);
				break;
			case Button.ID_LEFT:
				var.setMaxTurn(var.getMaxTurn() - 1);
				break;
			}
			LCD.drawInt((int)var.getMaxTurn(), 5, 10, Y_TURN);
		}
		LCD.drawInt((int)var.getMaxTurn(), 5, 10, Y_TURN);
	}

	private void setCourse(Variables var) {
		LCD.drawString("set Course:", 1, Y_COURE);
		if(var.getCourse()==1){
			LCD.drawString("OUT", 12, Y_COURE);
		}
		else{
			LCD.drawString("IN ", 12, Y_COURE);
		}
		int button;
		while((button = this.getButtonID()) != Button.ID_ENTER) {
			if(var.getCourse()==1){
				var.setCourse(-1);
				LCD.drawString("IN ", 12, Y_COURE);
			}
			else{
				var.setCourse(1);
				LCD.drawString("OUT", 12, Y_COURE);
			}
		}
		if(var.getCourse()==1){
			LCD.drawString("OUT", 12, Y_COURE);
		}
		else{
			LCD.drawString("IN ", 12, Y_COURE);
		}
	}

	private int getButtonID() {
		while(true) {
			try {
				Thread.sleep(200);
			}
			catch (InterruptedException e) {
				return 0;
			}
			if (Button.ENTER.isPressed()) {
				return Button.ID_ENTER;
			}
			if (Button.ESCAPE.isPressed()) {
				return Button.ID_ESCAPE;
			}
			if (Button.RIGHT.isPressed()) {
				return Button.ID_RIGHT;
			}
			if (Button.LEFT.isPressed()) {
				return Button.ID_LEFT;
			}
		}
	}
}
