package etrobo.sample2010;

import lejos.nxt.*;
import lejos.nxt.comm.RConsole;
import lejos.util.*;

/* Tachometer, Line, LineMap, Landmark */

public class LineTracer implements Runnable
{
	private LightSensor light = new LightSensor(SensorPort.S3);
//	private UltrasonicSensor sonar = new UltrasonicSensor(SensorPort.S2);
//	private float forward; /* 前後進命令: -100(後進)～0(停止)～100(前進) */
	private float turn; /* 旋回命令: -100(左旋回)～100(右旋回) */
	private boolean pause; /* 一時停止 */
	private boolean available;

	/* 下記はまいまい式で使用する変数 */
	private final float THRESHOLD = 0.7F; /* ラインエッジ閾値								*/
	static double brightness;	/* コース明度			*/
	static int lightDowned;		/* 消灯時の光センサー値	*/
	static int lightUpped;		/* 点灯時の光センサー値	*/

	/* PID制御パラメタ */
	private static Variables var = Variables.getInsatnce();
	private double deviation;
	private double preDeviation;
	private double prePreDeviation;
	private double integral;
	private float maxTurn;
	private float minTurn;

	/* 経過時間取得用 */
	private Stopwatch stopWatch;
	private int elapsedTime;

	public LineTracer() {
		brightness = 0;
		available = true;
		turn = 0;
		pause = false;

		deviation = 0;
		preDeviation = 0;
		prePreDeviation = 0;
		integral = 0;
		maxTurn = var.getMaxTurn();
		minTurn = maxTurn * (-1);

		stopWatch = new Stopwatch();
		stopWatch.reset();
	}

	/* ライントレース */
	public void run() {
		int base =stopWatch.elapsed();
		int now;
		boolean lightState = light.isFloodlightOn();

		while (available == true) {
			now = stopWatch.elapsed();

			if(base+15 <= now){
				if(lightState){
					lightOFF();	/* 光センサ赤色LEDをOFF */
					lightState = false;
				}
				else{
					lightON();	/* 光センサ赤色LEDをON */
					lightState = true;
				}

				base = now;
				/* 照度計算 */
				setBrightness();
				/* 旋回値計算 */
				pidControl2();
			}

			if(pause == true) {
				turn = 0;
			}
			try {
				Thread.sleep(4); /* 約4msec周期処理 */
			} catch (InterruptedException e) {
			}
		}
	}

	/* 旋回命令取得 */
	public float getTurnCmd() {
		return turn;
	}

	/* 前後進命令取得 */
	public float getForwardCmd() {
		return var.getForward();
	}

	/* ライントレース停止 */
	public void stopRunning() {
		available = false;
	}

	/* 明度計測（ルミノメーター）*/
	private void setBrightness()
	{
		int lightDiff;				/* 点灯時と消灯時の変化量	*/
		double k;					/* 光センサー非線形補正値	*/

		if((lightDowned ==0)||(lightUpped==0)){
			return;		// 両方のデータが取れるまでは計算しない
		}
		/* 光センサーの変化量を計算 */
		if (lightDowned - lightUpped > 0) {
			lightDiff = lightDowned - lightUpped;
		} else {
			lightDiff = 0;
		}

		/* 光センサー非線形補正係数を計算 （実験データより） */
		k = (1.0382E-3 * lightDowned - 6.3295E-1) * lightDowned + 1.1024E+2;

		/* コース明度を計算 */
		brightness = lightDiff / k;
//		if(brightness<0.45){
//			brightness = 0;
//		}
//		else if(brightness > 0.85){
//			brightness = 1;
//		}

		/* 偏差を計算 */
		prePreDeviation = preDeviation;
		preDeviation = deviation;
		deviation = brightness - THRESHOLD;
	}

	/* LED OFF時の光センサ値を読み取り、LEDをONにする */
	private void lightON()
	{
		lightDowned = (1023-light.readNormalizedValue());
		light.setFloodlight(true);	/* 光センサ赤色LEDをON */
	}

	/* LED ON時の光センサ値を読み取り、LEDをOFFにする */
	private void lightOFF()
	{
		lightUpped = (1023-light.readNormalizedValue());
		light.setFloodlight(false);	/* 光センサ赤色LEDをOFF */
	}

	private void pidControl()
	{
		double direction;

		if((lightDowned ==0)||(lightUpped==0)){
			return;		// 両方のデータが取れるまでは計算しない
		}

		/* 操作量＝Kp×偏差＋Ki×偏差の累積値＋Kd×前回偏差との差 */
		/* MVn = MVn-1 + ΔMVn */
		/* ΔMVn = Kp(en-en-1) + Ki en + Kd((en-en-1) - (en-1-en-2)) */
		/* MVn = MVn-1 +
      			 Kp(brightness - preBrightness) +
      			 Ki(brightness - THRESHOLD) +
      			 Kd(brightness - preBrightness*2 + prePreBrightness) */
		direction = var.getKP() * (deviation-preDeviation) +
		            var.getKI() * deviation +
		            var.getKD() * ((deviation - preDeviation) - (preDeviation- prePreDeviation));
		turn = (float) (turn+ direction);
		if(turn > maxTurn){
			turn = maxTurn;
		}
		else if(turn < minTurn){
			turn = minTurn;
		}
		RConsole.println(""+stopWatch.elapsed()+ "	"+brightness+ "	"+ turn+ "	"+deviation+ "	"+preDeviation+ "	"+prePreDeviation);
	}

	private void pidControl2()
	{
		int now;
		int diff;

		if((lightDowned ==0)||(lightUpped==0)){
			elapsedTime = stopWatch.elapsed();
			return;		// 両方のデータが取れるまでは計算しない
		}

//		if((-0.02 < deviation) && (deviation <0.05)){
//			turn = 0;
//		}
//		else{
			now = stopWatch.elapsed();
			diff = now - elapsedTime;
			elapsedTime = now;

			integral += (deviation + preDeviation)/2.0 * diff;

			turn = (float)((var.getKP() * deviation) +
					(var.getKI() * integral) +
					(var.getKD() * (deviation - preDeviation)/diff));
			if(turn > maxTurn){
				turn = maxTurn;
			}
			else if(turn < minTurn){
				turn = minTurn;
			}
			turn *= var.getCourse();
//		}
		RConsole.println(""+stopWatch.elapsed()+ "	"+brightness+ "	"+ turn+ "	"+deviation+ "	"+preDeviation);
	}


}
