//
// PositionControl.h
//

#ifndef POSITIONCONTROL_H_
#define POSITIONCONTROL_H_

#include "Motor.h"
#include "Vector.h"
using namespace ecrobot;

//for Debug
#include "Lcd.h"

class PositionControl
{
public:

	//
	// Constructor
	//
	PositionControl(Motor* pMotorL, Motor* pMotorR, Lcd* pLcd);
	
	~PositionControl();
	
	//
	// ݈ʒuXV
	//
	void updateCurrentPosition();
	
	//
	// ݈ʒu擾
	//
	VectorT<S32> getCurrentPosition();

private:
	
	//
	// ԗ֔a(m)
	//
	float m_dWRadius;
	
	//
	// ԗ֊Ԋu(m)
	//
	float m_dWInterval;
	
	//
	// XW
	//
	float m_dX;
	
	//
	// YW
	//
	float m_dY;
	
	float m_dW;
	
	float m_dPI;
	
	//
	// vԊu
	//
	long m_lSampling;
	
	long m_lLastLRotAngle;
	
	long m_lLastRRotAngle;
	
	Motor* m_pMotorL;
	
	Motor* m_pMotorR;

	//for Debug
	Lcd* m_pLcd;
};

#endif
