///////////////////////////////////////////////////////////
//  Course.cpp
//  Implementation of the Class Course
//  Created on:      12-7-2011 0:02:26
//  Original author: u90499
///////////////////////////////////////////////////////////

#include "Course.h"
#include "Em_SectionChange.h"

Course::Course(Em_CourseKind::eCourseKind iCourseKind):
m_iCourseKind(iCourseKind)
{

	//sm
	st_section section;

	if(m_iCourseKind == Em_CourseKind::IN){  //In Course
		
		m_iSectionMax = 14;

		// p[^̏
		section.EndPosition.mX = 220;
		section.EndPosition.mY = 50;
		section.isectionID = 7;
		section.lSpeed       = 70;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[0] = section;

		// Jn
		section.EndPosition.mX = -15;//-20;
		section.EndPosition.mY = 0;
		section.isectionID = 8;
		section.lSpeed       = 70;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[1] = section;

		// V[\Jn
		section.EndPosition.mX = -60;//-60;
		section.EndPosition.mY = 0;
		section.isectionID = 9;
		section.lSpeed       = 70;
		section.bSonerUse   = false;
		section.bPIDExec = false;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[2] = section;

		section.EndPosition.mX = -70;//-70;
		section.EndPosition.mY = 0;
		section.isectionID = 10;
		section.lSpeed       = 40;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[3] = section;

		section.EndPosition.mX = -80;//-80;
		section.EndPosition.mY = 0;
		section.isectionID = 11;
		section.lSpeed       = 5;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[4] = section;

		section.EndPosition.mX = -110;//-110;
		section.EndPosition.mY = 0;
		section.isectionID = 12;
		section.lSpeed       = 5;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[5] = section;

		section.EndPosition.mX = 9999;
		section.EndPosition.mY = 9999;
		section.isectionID = 13;
		section.lSpeed       = 80;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[6] = section;

	}else if((m_iCourseKind == Em_CourseKind::OUT) || (m_iCourseKind == Em_CourseKind::OUT_NANSYO)){

		m_iSectionMax = 13;
		section.EndPosition.mX = 10;
		section.EndPosition.mY = 0;
		section.isectionID = 0;
		section.lSpeed       = 80;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[0] = section;

		section.EndPosition.mX = 140;
		section.EndPosition.mY = 0;
		section.isectionID = 1;
		section.lSpeed       = 130;
//		section.lSpeed       = 150;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[1] = section;
		
		section.EndPosition.mX = 290;	//  290
		section.EndPosition.mY = 0;
		section.isectionID = 2;
		section.lSpeed       = 120;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[2] = section;

		section.EndPosition.mX = 400;
		section.EndPosition.mY = 80;	//  100
		section.isectionID = 3;
		section.lSpeed       = 130;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[3] = section;

		section.EndPosition.mX = 9999;	// gp 390
		section.EndPosition.mY = 200;	//  200
		section.isectionID = 4;
		section.lSpeed       = 130;
//		section.lSpeed       = 140;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[4] = section;

		section.EndPosition.mX = 300;	//  300
		section.EndPosition.mY = 310;	// gp 310
		section.isectionID = 5;
		section.lSpeed       = 130;
//		section.lSpeed       = 140;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[5] = section;

		section.EndPosition.mX = 310;
		section.EndPosition.mY = 200;	//  150
		section.isectionID = 6;
		section.lSpeed       = 120;
//		section.lSpeed       = 130;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[6] = section;

		section.EndPosition.mX = 225;	//  225
		section.EndPosition.mY = 166;	//  150
		section.isectionID = 7;
		section.lSpeed       = 90;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;	//  XMinus
		m_section[7] = section;

		section.EndPosition.mX = 9999;	// gp 190
		section.EndPosition.mY = 229;	//  229
		section.isectionID = 8;
		section.lSpeed       = 130;
//		section.lSpeed       = 140;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[8] = section;

		section.EndPosition.mX =  90;
		section.EndPosition.mY = 280;
		section.isectionID = 9;
		section.lSpeed       = 130;
//		section.lSpeed       = 140;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[9] = section;

		// x[VbNR[XNA  bNAbvQ[g܂
		section.EndPosition.mX = 0;			// 	gp
		section.EndPosition.mY = 0; 		// 	gp
		section.isectionID = 10;
		section.lSpeed       = 20;
		section.bSonerUse   = true;					
		section.bPIDExec = true;					// 	gp
		section.iXY   = Em_SectionChange::XMinus;	// 	gp
		m_section[10] = section;

		// ŝÎ~邽߂̃_~[̃ZNV
		section.EndPosition.mX = 55;		// 	TODO
		section.EndPosition.mY = 0;			// 	gp
		section.isectionID = 11;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XPlus;	// 	gp
		m_section[11] = section;

		// ςāAETo̍ŏ̃^[Qbg|Cg܂ňړ邽߂̃ZNV	
		section.EndPosition.mX = static_cast<S32>(ET_SUMO_FINAL_POS_X * 100);	//TODO
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_FINAL_POS_Y * 100);	// 	gp
		section.isectionID = 12;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::YPlus;	//TODO
		m_section[12] = section;

	} else{
	}
}



Course::~Course(){

}
