///////////////////////////////////////////////////////////
//  Course.cpp
//  Implementation of the Class Course
//  Created on:      12-7-2011 0:02:26
//  Original author: u90499
///////////////////////////////////////////////////////////

#include "Course.h"
#include "Em_SectionChange.h"

Course::Course(Em_CourseKind::eCourseKind iCourseKind):
m_iCourseKind(iCourseKind)
{

	//sm
	st_section section;
	
	m_iSectionMax = 14;

	
	for(int i = 0; i < m_iSectionMax;i++){
		section.isectionID = i;
		section.lSpeed       = 30;
		section.bPIDExec = true;
		
		if((i%4) == 0){
			section.EndPosition.mX = 30;
			section.EndPosition.mY = 10;
			section.bSonerUse   = true;
			section.iXY   = Em_SectionChange::XPlus;
		}else if((i%4) == 1){
			section.EndPosition.mX = 30;
			section.EndPosition.mY = 30;
			section.bSonerUse   = false;
			section.iXY   = Em_SectionChange::YPlus;
		}else if((i%4) == 2){
			section.EndPosition.mX = 10;
			section.EndPosition.mY = 30;
			section.bSonerUse   = false;
			section.iXY   = Em_SectionChange::XMinus;
		}else if((i%4) == 3){
			section.EndPosition.mX = 10;
			section.EndPosition.mY = 10;
			section.bSonerUse   = false;
			section.iXY   = Em_SectionChange::YMinus;
		}else{
			section.EndPosition.mX = 0;
			section.EndPosition.mY = 99999;
			section.bSonerUse   = false;
			section.iXY   = Em_SectionChange::YPlus;
			}
		m_section[i] = section;
	}
	
}



Course::~Course(){

}
