//
// Driver.h
//

#ifndef DRIVER_H_
#define DRIVER_H_


#include "LightSensor.h"
#include "PIDCtrl.h"
#include "StandControl.h"
#include "PositionControl.h"
#include "TailControl.h"
#include "Section.h"
using namespace ecrobot;

//for Debug
#include "Lcd.h"

class Driver
{
public:

	//
	// Constructor
	//
	Driver(LightSensor* pLightSensor, GyroSensor* pGyroSensor, Motor* pMotorL, Motor* pMotorR, Nxt* pNxt, Lcd* pLcd, TailControl* pTailControl);
	
	~Driver();
	
	//
	// s
	//
	void run();

	//
	// sI
	//
	bool isSenctionEnd();
	
	
	void initialize();
	void setRunWay(st_section& sect);

private:
	
	PIDCtrl* m_pPIDCtrl;
	
	StandControl* m_pStandControl;
	
	TailControl* m_pTailControl;
	
	PositionControl* m_pPositionControl;
	
	VectorT<S32> m_cntEndPosition;
	
	S16 m_speed;
	
};

#endif
