//
// t@C : Main.cpp
// Tv       : 2֓|UqCg[X{bgTOPPERS/ATK1(OSEK)pC++TvvO
//

//#include "math.h"

// ECRobot C++ API
#include "TouchSensor.h"
//#include "SonarSensor.h"
#include "LightSensor.h"
#include "GyroSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
//using namespace ecrobot;

#include "UI.h"
#include "Driver.h"
#include "DriverMgr.h"
#include "TailControl.h"
#include "CourseMgr.h"
#include "Em_CourseKind.h"

//=============================================================================
// foCXIuWFNg̒`

GyroSensor gyro(PORT_1);
LightSensor light(PORT_3);
TouchSensor touch(PORT_4);
Motor motorT(PORT_A);
Motor motorR(PORT_B);
Motor motorL(PORT_C);
Nxt nxt;
Lcd lcd;
Clock clock;

CourseMgr courseMgr;
TailControl tailControl(&motorT);
DriverMgr driverMgr(&light, &gyro, &motorL, &motorR, &nxt, &lcd, &tailControl, &courseMgr);
UI ui(&light, &touch, &nxt, &lcd, &driverMgr);

bool bInOutFlag = false;
bool bDifficultStageFlag;

extern "C"
{
//=============================================================================

// ^XN̋N[msec]
#define BACKGROUND_PERIOD (48)
// Bluetooth̃foCXi"ET" + 2011Nx FE[VO ̃`[ID "158"j
#define DEVICE_NAME     "ET158"
// Bluetooth̃pXL[iftHg "1234" ȊOݒ肷Kvj
#define PASS_KEY  "uis_robocon"


//=============================================================================
// ֐	: user_1ms_isr_type2
// 	: Ȃ
// ߂l	: Ȃ
// Tv	: 1msec荞݃tbN֐(OSEK ISR type2JeS)
//=============================================================================
void user_1ms_isr_type2(void)
{
	ecrobot_set_bt_device_name(DEVICE_NAME); //BluetoothfoCXݒ
	(void)SignalCounter(SysTimerCnt); // Alarmnh
	SleeperMonitor(); // NxtI2CfoCX̎gpɕKv
}

//=============================================================================
// ^XN@: TaskMain
// Tv	@: C^XN
//=============================================================================
TASK(TaskMain)
{
	
	SetRelAlarm(Alarm4msec, 1, DRIVE_PERIOD);
	
	ui.selectCource(bInOutFlag, bDifficultStageFlag);
	courseMgr.createCourse(static_cast<Em_CourseKind::eCourseKind>(bInOutFlag));

//	ui.printcalibration();

	ui.waitForTouchSenserOn();

	
}

//=============================================================================
// ^XN@: TaskDrive
// Tv	@: hCu^XN
//=============================================================================
TASK(TaskDrive)
{
	driverMgr.startDrive();
}
};

//=============================================================================
// ^XN@: ecrobot_device_initialize
// Tv	@: foCXptbN֐BnxtOSEKNɎsB
//=============================================================================
void ecrobot_device_initialize(void)
{
	ecrobot_init_bt_slave(PASS_KEY);

}

//=============================================================================
// ^XN@: ecrobot_device_terminate
// Tv	@: foCXIptbN֐BSTOP܂EXIT{^ꂽɎsB
//=============================================================================
void ecrobot_device_terminate(void)
{
	ecrobot_term_bt_connection();
}
