///////////////////////////////////////////////////////////
//  UI.h
//  Implementation of the Class UI
//  Created on:      09-7-2011 20:24:52
//  Original author: u90499
///////////////////////////////////////////////////////////

#ifndef UI_H_
#define UI_H_


#include "TouchSensor.h"
#include "LightSensor.h"
#include "DriverMgr.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
#include "Vector.h"

using namespace ecrobot;

extern "C"
{
	#include "ecrobot_interface.h"
};


class UI
{

public:
	UI(LightSensor* pLightSensor, TouchSensor* pTouchSensor, Nxt* pNxt, Lcd* pLcd, DriverMgr* pDriverMgr);
	virtual ~UI();


	//
	// Lu[Vʂ\
	//
	void printcalibration();
	
	S16 calibrate(char* chData);

	
	//
	// R[Xݒʂ\
	//
	void printCourceSelect();

	void selectCource(bool& bInOutFlag, bool& bDifficultStageFlag);

	
	//
	// ^b`ZT҂
	//
	void waitForTouchSenserOn();
	
	
	void printDifficultStage();



private:
	DriverMgr* m_DriverMgr;
	TouchSensor* m_touch;
	LightSensor* m_light;
	Nxt* m_pNxt;
	Lcd* m_pLcd;
	
	void printData(char* str,int SleepTme);
	void printResult(bool bInOutFlag, bool bDifficultStageFlag);
	bool selectBotton(CHAR chTrueData[],CHAR chFalseData[]);
	bool selectOKNG();

};
#endif
