///////////////////////////////////////////////////////////
//  Course.cpp
//  Implementation of the Class Course
//  Created on:      12-7-2011 0:02:26
//  Original author: u90499
///////////////////////////////////////////////////////////

#include "Course.h"
#include "Em_SectionKind.h"
#include "Em_SectionChange.h"

Course::Course(Em_CourseKind::eCourseKind iCourseKind):
m_iCourseKind(iCourseKind)
{

	//sm
	st_section section;

	if(m_iCourseKind == Em_CourseKind::IN){  //In Course
		
		m_iSectionMax = 6;
		
		section.EndPosition.mX = 360;
		section.EndPosition.mY = 0;
		section.isectionID = 0;
		section.lSpeed       = 150;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[0] = section;

		section.EndPosition.mX = 460;
		section.EndPosition.mY = 60;
		section.isectionID = 1;
		section.lSpeed       = 110;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[1] = section;

		section.EndPosition.mX = 460;
		section.EndPosition.mY = 184;
		section.isectionID = 2;
		section.lSpeed       = 130;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[2] = section;

		section.EndPosition.mX = 290;
		section.EndPosition.mY = 89;
		section.isectionID = 3;
		section.lSpeed       = 100;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[3] = section;

		section.EndPosition.mX = 240;
		section.EndPosition.mY = 200;
		section.isectionID = 4;
		section.lSpeed       = 130;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[4] = section;

		section.EndPosition.mX = 9999;
		section.EndPosition.mY = 9999;
		section.isectionID = 5;
		section.lSpeed       = 130;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[5] = section;

	}else if(m_iCourseKind == Em_CourseKind::OUT){

		m_iSectionMax = 25;
		section.EndPosition.mX = 20;
		section.EndPosition.mY = 0;
		section.isectionID = 0;
		section.lSpeed       = 80;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[0] = section;

		section.EndPosition.mX = 290;
		section.EndPosition.mY = 0;
		section.isectionID = 1;
		section.lSpeed       = 120;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[1] = section;

		section.EndPosition.mX = 400;
		section.EndPosition.mY = 100;
		section.isectionID = 2;
		section.lSpeed       = 100;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[2] = section;

		section.EndPosition.mX = 390;
		section.EndPosition.mY = 200;
		section.isectionID = 3;
		section.lSpeed       = 120;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[3] = section;

		section.EndPosition.mX = 300;
		section.EndPosition.mY = 310;
		section.isectionID = 4;
		section.lSpeed       = 100;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[4] = section;

		section.EndPosition.mX = 310;
		section.EndPosition.mY = 150;
		section.isectionID = 5;
		section.lSpeed       = 100;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[5] = section;

		section.EndPosition.mX = 225;
		section.EndPosition.mY = 150;
		section.isectionID = 6;
		section.lSpeed       = 80;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[6] = section;

		section.EndPosition.mX = 190;
		section.EndPosition.mY = 229;
		section.isectionID = 7;
		section.lSpeed       = 100;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[7] = section;

		section.EndPosition.mX = 115;
		section.EndPosition.mY = 280;
		section.isectionID = 8;
		section.lSpeed       = 80;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[8] = section;

		// x[VbNR[XNA  bNAbvQ[g܂
		section.EndPosition.mX = 0;			// 	gp
		section.EndPosition.mY = 0; 		// 	gp
		section.isectionID = 9;
		section.lSpeed       = 20;
		section.bSonerUse   = true;					
		section.bPIDExec = true;					// 	gp
		section.iXY   = Em_SectionChange::XMinus;	// 	gp
		m_section[9] = section;


		// ŝÎ~邽߂̃_~[̃ZNV
		section.EndPosition.mX = 0;			// 	gp
		section.EndPosition.mY = 0;			// 	gp
		section.isectionID = 10;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	// 	gp
		m_section[10] = section;


		// ŝX邽߂̃_~[̃ZNV
		section.EndPosition.mX = 0;			// 	gp
		section.EndPosition.mY = 0;			// 	gp
		section.isectionID = 11;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	// 	gp
		m_section[11] = section;


		// X܂ܑsZNV
		section.EndPosition.mX = 110;
		section.EndPosition.mY = 0;			// 	gp
		section.isectionID = 12;
		section.lSpeed       = 30;
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;
		m_section[12] = section;

/*
		// ŝÎ~邽߂̃_~[̃ZNV
		section.EndPosition.mX = 0;			// 	gp
		section.EndPosition.mY = 0;			// 	gp
		section.isectionID = 13;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	// 	gp
		m_section[13] = section;


		// ŝ𗧂オ点邽߂̃_~[̃ZNV
		section.EndPosition.mX = 0;			// 	gp
		section.EndPosition.mY = 0;			// 	gp
		section.isectionID = 14;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	// 	gp
		m_section[14] = section;

		// ŝUÎ~邽߂̃_~[̃ZNV
		section.EndPosition.mX = 0;			// 	gp
		section.EndPosition.mY = 0;			// 	gp
		section.isectionID = 15;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	// 	gp
		m_section[15] = section;

		// ςāAETo̍ŏ̃^[Qbg|Cg܂ňړ邽߂̃ZNV	
		section.EndPosition.mX = static_cast<S32>(ET_SUMO_START_POS_X * 100 + 5);	//TODO
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_START_POS_Y * 100);	// 	gp
		section.isectionID = 16;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	//TODO
		m_section[16] = section;
		
		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET1_POS_X * 100 + 5);	//TODO
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET1_POS_Y * 100);	// 	gp
		section.isectionID = 17;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	//TODO
		m_section[17] = section;


		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET2_POS_X * 100);	// 	gp
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET2_POS_Y * 100 + 5); //TODO
		section.isectionID = 18;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::YMinus;	//TODO
		m_section[18] = section;
		

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET3_POS_X * 100 - 5);	//TODO
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET3_POS_Y * 100);	// 	gp
		section.isectionID = 19;
		section.lSpeed       = 30;
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XPlus;	//TODO samplep
		m_section[19] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET4_POS_X * 100);	// 	gp
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET4_POS_Y * 100 + 5);	//TODO
		section.isectionID = 20;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::YMinus;	//TODO
		m_section[20] = section;



		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET5_POS_X * 100 + 5);	//TODO
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET5_POS_Y * 100);		// 	gp
		section.isectionID = 21;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XMinus;	//TODO
		m_section[21] = section;
	
		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET6_POS_X * 100);		// 	gp
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET6_POS_Y * 100 + 5);//TODO
		section.isectionID = 22;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::YMinus;//TODO
		m_section[22] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET7_POS_X * 100 - 5);	//TODO
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET7_POS_Y * 100);		// 	gp
		section.isectionID = 23;
		section.lSpeed       = 30;			// 	gp
		section.bSonerUse   = false;		// 	gp
		section.bPIDExec = true;			// 	gp
		section.iXY   = Em_SectionChange::XPlus;
		m_section[23] = section;

		section.EndPosition.mX = 100;
		section.EndPosition.mY = 0;
		section.isectionID = 24;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[24] = section;
*/
	} else if(m_iCourseKind == Em_CourseKind::IN_NANSYO){  //In Course
		
		m_iSectionMax = 10;

		//V[\[IォEJ[ur܂
		section.EndPosition.mX = 50;
		section.EndPosition.mY = -25;
		section.isectionID = 0;
		section.lSpeed       = 70;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[0] = section;
		//EJ[urEJ[uI܂
		section.EndPosition.mX = 40;
		section.EndPosition.mY = -50;
		section.isectionID = 0;
		section.lSpeed       = 70;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[1] = section;
		//O[][O1iڒO
		section.EndPosition.mX = 20;
		section.EndPosition.mY = -50;
		section.isectionID = 0;
		section.lSpeed       = 20;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[2] = section;
		//1iڏ
		section.EndPosition.mX = 15;
		section.EndPosition.mY = -50;
		section.isectionID = 1;
		section.lSpeed       = 60;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[3] = section;
		//1iڏォ2iڏ钼O
		section.EndPosition.mX = 0;
		section.EndPosition.mY = -50;
		section.isectionID = 2;
		section.lSpeed       = 5;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[4] = section;
		//2iڏ
		section.EndPosition.mX = -5;
		section.EndPosition.mY = -50;
		section.isectionID = 3;
		section.lSpeed       = 60;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[5] = section;
		//2iڏォKi钼O
		section.EndPosition.mX = -30;
		section.EndPosition.mY = -50;
		section.isectionID = 4;
		section.lSpeed       = 10;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[6] = section;
		//Ki肽
		section.EndPosition.mX = -35;
		section.EndPosition.mY = -50;
		section.isectionID = 5;
		section.lSpeed       = 80;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[7] = section;
		//̑xɖ߂
		section.EndPosition.mX = -60;
		section.EndPosition.mY = -50;
		section.isectionID = 5;
		section.lSpeed       = 10;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[8] = section;

		section.EndPosition.mX = 9999;
		section.EndPosition.mY = 9999;
		section.isectionID = 5;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[9] = section;

	} else if(m_iCourseKind == Em_CourseKind::OUT_NANSYO){  //Out Course
		
		m_iSectionMax = 18;
		
		section.EndPosition.mX = 10;
		section.EndPosition.mY = 0;
		section.isectionID = 0;
		section.lSpeed       = 20;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[0] = section;

		section.EndPosition.mX = 200;
		section.EndPosition.mY = 0;
		section.isectionID = 1;
		section.lSpeed       = 40;
		section.bSonerUse   = true;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[1] = section;

		section.EndPosition.mX = 100;
		section.EndPosition.mY = 0;
		section.isectionID = 2;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.iXY   = Em_SectionChange::XPlus;
		section.bPIDExec = true;
		m_section[2] = section;

		section.EndPosition.mX = 100;
		section.EndPosition.mY = 0;
		section.isectionID = 3;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.iXY   = Em_SectionChange::XPlus;
		section.bPIDExec = true;
		m_section[3] = section;

		section.EndPosition.mX = 80;
		section.EndPosition.mY = 0;
		section.isectionID = 4;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.iXY   = Em_SectionChange::XPlus;
		section.bPIDExec = true;
		m_section[4] = section;

		section.EndPosition.mX = 100;
		section.EndPosition.mY = 0;
		section.isectionID = 5;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[5] = section;

		section.EndPosition.mX = 100;
		section.EndPosition.mY = 0;
		section.isectionID = 6;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[6] = section;

		section.EndPosition.mX = 100;
		section.EndPosition.mY = 0;
		section.isectionID = 7;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[7] = section;
		
		section.EndPosition.mX = 220;
		section.EndPosition.mY = 50;
		section.isectionID = 8;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[8] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_START_POS_X * 100 - 5);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_START_POS_Y * 100);
		section.isectionID = 9;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[9] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET1_POS_X * 100 - 5);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET1_POS_Y * 100);
		section.isectionID = 10;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[10] = section;
	
		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET2_POS_X * 100);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET2_POS_Y * 100 - 5);
		section.isectionID = 11;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;	//TODO samplep
		m_section[11] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET3_POS_X * 100 + 5);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET3_POS_Y * 100);
		section.isectionID = 12;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;	//TODO samplep
		m_section[12] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET4_POS_X * 100);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET4_POS_Y * 100 - 5);
		section.isectionID = 13;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;	//TODO samplep
		m_section[13] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET5_POS_X * 100 - 5);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET5_POS_Y * 100);
		section.isectionID = 14;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;	//TODO samplep
		m_section[14] = section;
	
		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET6_POS_X * 100);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET6_POS_Y * 100 - 5);
		section.isectionID = 15;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[15] = section;

		section.EndPosition.mX = static_cast<S32>(ET_SUMO_TARGET7_POS_X * 100 + 5);
		section.EndPosition.mY = static_cast<S32>(ET_SUMO_TARGET7_POS_Y * 100);
		section.isectionID = 16;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XMinus;
		m_section[16] = section;
		
		section.EndPosition.mX = 100;
		section.EndPosition.mY = 0;
		section.isectionID = 17;
		section.lSpeed       = 30;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::XPlus;
		m_section[17] = section;

	} else if(m_iCourseKind == Em_CourseKind::SEESAW){
		m_iSectionMax = 5;
		
		section.EndPosition.mX = 0;
		section.EndPosition.mY = -60;
		section.isectionID = 0;
		section.lSpeed       = 50;
		section.bSonerUse   = false;
		section.bPIDExec = false;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[0] = section;

		section.EndPosition.mX = 0;
		section.EndPosition.mY = -70;
		section.isectionID = 1;
		section.lSpeed       = 20;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[1] = section;

		section.EndPosition.mX = 0;
		section.EndPosition.mY = -80;
		section.isectionID = 2;
		section.lSpeed       = 0;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[2] = section;

		section.EndPosition.mX = 0;
		section.EndPosition.mY = -120;
		section.isectionID = 3;
		section.lSpeed       = 20;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YMinus;
		m_section[3] = section;

		section.EndPosition.mX = 9999;
		section.EndPosition.mY = 9999;
		section.isectionID = 4;
		section.lSpeed       = 80;
		section.bSonerUse   = false;
		section.bPIDExec = true;
		section.iXY   = Em_SectionChange::YPlus;
		m_section[4] = section;
	
	} else{
		
		m_iSectionMax = 13;
		
		for(int i = 0; i < m_iSectionMax;i++){
			section.isectionID = i;
			section.lSpeed       = 30;
			section.bSonerUse   = true;
			section.bPIDExec = true;
			if((i%4) == 0){
				section.EndPosition.mX = 30;
				section.EndPosition.mY = 10;
				section.iXY   = Em_SectionChange::XPlus;
			}else if((i%4) == 1){
				section.EndPosition.mX = 30;
				section.EndPosition.mY = 30;
				section.iXY   = Em_SectionChange::YPlus;
			}else if((i%4) == 2){
				section.EndPosition.mX = 10;
				section.EndPosition.mY = 30;
				section.iXY   = Em_SectionChange::XMinus;
			}else if((i%4) == 3){
				section.EndPosition.mX = 10;
				section.EndPosition.mY = 10;
				section.iXY   = Em_SectionChange::YMinus;
			}else{
				section.EndPosition.mX = 0;
				section.EndPosition.mY = 99999;
				section.iXY   = Em_SectionChange::YPlus;
				}
			m_section[i] = section;
		}
	}
}



Course::~Course(){

}
