//
// Driver.cpp
//
#include "Speaker.h"
#include "Driver.h"
#include "Vector.h"
#include "Lcd.h"
#include "Em_SectionChange.h"
#include "math.h"
#include "Course.h"

//=============================================================================
Driver::Driver(LightSensor* pLightSensor, GyroSensor* pGyroSensor, SonarSensor* pSoner,Motor* pMotorL, Motor* pMotorR, Nxt* pNxt, Lcd* pLcd, TailControl* pTailControl){
	m_pPIDCtrl = new PIDCtrl(pLightSensor, 590, 0.7, 0.5, 13.0);
	m_pPositionControl = new  PositionControl(pMotorL, pMotorR, pLcd);
	m_pStandControl = new StandControl(pGyroSensor, pMotorL, pMotorR, pNxt, m_pPositionControl);
	m_pTailControl = pTailControl;
	m_pSoner = pSoner;
	m_lCt = 0;
	m_TargetAngle = 0;
	m_bRightTurn = false;
	m_lMotorReset = 0;
	m_emCourseKind = Em_CourseKind::NONE;
}

Driver::~Driver(){
	delete m_pPIDCtrl;
	delete m_pStandControl;
}

void Driver::initialize(){
	m_pStandControl->calGyroOffset();
}


void Driver::setRunWay(st_section& sect){
	m_sect = sect;
	m_cntEndPosition = sect.EndPosition;
	m_speed = sect.lSpeed;
	m_isectionID = sect.isectionID;
	m_iXY = sect.iXY;
	m_bDoObstaclesExist = false;
}

void Driver::run(){
	S16 PIDCalcValue = m_pPIDCtrl->calcVal();
	VectorT<S16> command;
	static bool bPIDExec = true;
	
	if(m_sect.bPIDExec == true){
		bPIDExec = true;
	}
	
	if((m_sect.bPIDExec == false) &&  ((180 * m_pPositionControl->get_dW())/(2 * asin(1))) <  165){
		Speaker speaker;
		speaker.playTone(840U, 500U, 30U);

		bPIDExec = false;
	}

	if ((m_emCourseKind == Em_CourseKind::IN) || (m_emCourseKind == Em_CourseKind::IN_NANSYO)){
		// Eg[X
		if(bPIDExec == true)
		command = VectorT<S16>(m_speed, -1 * PIDCalcValue);
		else command = VectorT<S16>(m_speed, 0);
	} else if ((m_emCourseKind == Em_CourseKind::OUT) || (m_emCourseKind == Em_CourseKind::OUT_NANSYO)){
		// g[X
		command = VectorT<S16>(m_speed, PIDCalcValue);
	} else {		
		// Eg[X
		if(bPIDExec == true)
		command = VectorT<S16>(m_speed, -1 * PIDCalcValue);
		else command = VectorT<S16>(m_speed, 0);
	}
	
	if (m_isectionID == 99){
		command = VectorT<S16>(m_speed, 0);
	}
	
	if (m_emCourseKind == Em_CourseKind::OUT){
		
		// Î~
		if (m_isectionID == 10){
			
			command = VectorT<S16>(0, PIDCalcValue);
			m_pTailControl->tail_control(110);
		
		// X
		} else if (m_isectionID == 11){
			
			command = VectorT<S16>(0, 0);
			if (m_lCt < 50){
				command.mX = 20;
				m_pTailControl->tail_control(105);
			} else if (m_lCt < 100){
				command.mX = 20;
				m_pTailControl->tail_control(95);
			} else if (m_lCt < 150){
				command.mX = 20;
				m_pTailControl->tail_control(85);
			} else if (m_lCt < 200){
				command.mX = 20;
				m_pTailControl->tail_control(85);
			}
			m_pStandControl->lean(command);
			return;
		
		// X܂ܑs
		}  else if (m_isectionID == 12){
			
			command = VectorT<S16>(50, PIDCalcValue);
			m_pTailControl->tail_control(85);
			m_pStandControl->leanRun(command);
			return;
		
		// ~܂
		} else if (m_isectionID == 13){
			
			command = VectorT<S16>(0, PIDCalcValue);
			m_pTailControl->tail_control(85);
			m_pStandControl->leanRun(command);
			return;
		
		// オ
		} else if (m_isectionID == 14){

			if((m_lCt % 250) < 10){
				m_pTailControl->stand(100);
				command = VectorT<S16>(-10, 0);
				m_pStandControl->lean(command);
			} else {
				m_pTailControl->tail_control(115);
				command = VectorT<S16>(-10, 0);
				m_pStandControl->lean(command);
			}
			return;
		
		// U~
		} else if (m_isectionID == 15){
			
			m_pTailControl->tail_control(115);
			if (m_lCt < 20){
				command = VectorT<S16>(-10, 0);
				m_pStandControl->lean(command);
				return;
			} 
			command = VectorT<S16>(0, 0);
			m_pStandControl->lean(command);
			return;
		
		// ςāAETo̍ŏ̃^[Qbg|Cg܂ňړ
		} else if (   (m_isectionID == 16)  ||(m_isectionID == 17) || (m_isectionID == 18) ||(m_isectionID == 19)
	           || (m_isectionID == 20) ||(m_isectionID == 21) || (m_isectionID == 22) ||(m_isectionID == 23)){
			m_pTailControl->tail_control(110);
			
			float fTargetPosX = 0;
			float fTargetPosY = 0;
			// ς
			 if (m_isectionID == 16){
			 	fTargetPosX = ET_SUMO_START_POS_X;
			 	fTargetPosY = ET_SUMO_START_POS_Y;
			 	
			 } else if (m_isectionID == 17){
			 	fTargetPosX = ET_SUMO_TARGET1_POS_X;
			 	fTargetPosY = ET_SUMO_TARGET1_POS_Y;
		 	
			 } else if (m_isectionID == 18){
			 	fTargetPosX = ET_SUMO_TARGET2_POS_X;
			 	fTargetPosY = ET_SUMO_TARGET2_POS_Y;
		 	
			 } else if (m_isectionID == 19){
			 	fTargetPosX = ET_SUMO_TARGET3_POS_X;
			 	fTargetPosY = ET_SUMO_TARGET3_POS_Y;
			 	
			 } else if (m_isectionID == 20){
			 	fTargetPosX = ET_SUMO_TARGET4_POS_X;
			 	fTargetPosY = ET_SUMO_TARGET4_POS_Y;
		 	
			 } else if (m_isectionID == 21){
			 	fTargetPosX = ET_SUMO_TARGET5_POS_X;
			 	fTargetPosY = ET_SUMO_TARGET5_POS_Y;
		 	
			 } else if (m_isectionID == 22){
			 	fTargetPosX = ET_SUMO_TARGET6_POS_X;
			 	fTargetPosY = ET_SUMO_TARGET6_POS_Y;
		 	
			 } else if (m_isectionID == 23){
			 	fTargetPosX = ET_SUMO_TARGET7_POS_X;
			 	fTargetPosY = ET_SUMO_TARGET7_POS_Y;
		 	
			 }
			
			m_TargetAngle = m_pPositionControl->calcDirectTarget(fTargetPosX, fTargetPosY, m_bRightTurn);
			
			if (m_pPositionControl->isTurnExec(m_TargetAngle) == true){
				S8 pwm = 0;
				if (m_bRightTurn == true){
					pwm = 20;
				}else{
					pwm = -20;
				}
				m_pStandControl->changeDirection(pwm);
					
			} else {
				command = VectorT<S16>(30, 0);
				m_pStandControl->lean(command);
			}
			return;
		}
	}
	
	m_pStandControl->standRun(command);
}
bool Driver::isSenctionEnd(){
	VectorT<S32> currentPosition = m_pPositionControl->getCurrentPosition();
	
	Speaker speaker;
	
	if (m_isectionID == 99){
		if(m_lCt < 50){
			m_lCt++;
			return false;
		} else{
			m_lCt = 0;
			speaker.playTone(840U, 500U, 50U);
			return true;
		}
	}
	
	if (m_emCourseKind == Em_CourseKind::OUT){
		
		// ŝÎ~
		if (m_isectionID == 10){
			
			if(m_lCt < 300){
				m_lCt++;
				return false;
			} else {
				m_lCt = 0;
				speaker.playTone(250U, 500U, 30U);
				return true;
			}

		// ŝX
		} else if (m_isectionID == 11){
			
			if (m_pTailControl->isAngle(80) == false){
				m_lCt++;
				return false;
			}
			m_lCt = 0;
			speaker.playTone(250U, 500U, 30U);
			return true;

		// ŝÎ~
		} else if (m_isectionID == 13){
			
			if(m_lCt < 401){
				m_lCt++;
				return false;
			} else {
				m_lCt = 0;
				return true;
			}		
		
		// ŝ𗧂オ点
		} else if (m_isectionID == 14){
			if (m_pTailControl->isAngle(110) == false){
				m_lCt++;
				return false;
			}
			m_lCt = 0;
			speaker.playTone(250U, 500U, 30U);
			return true;
		
		// ŝUÎ~
		} else if (m_isectionID == 15){
			if(m_lCt < 200){
				m_lCt++;
				return false;
			} 
			m_lCt = 0;
			speaker.playTone(250U, 500U, 30U);
			return true;
		
		}
	}
	
	if(m_sect.bSonerUse == true){
		return m_bDoObstaclesExist;
	}
	
	if(m_iXY == Em_SectionChange::XPlus){
		if(currentPosition.mX  > m_cntEndPosition.mX){
			speaker.playTone(840U, 500U, 50U);
			m_lCt = 0;
			return true;
		}
	}
	else if(m_iXY == Em_SectionChange::XMinus){
		if(currentPosition.mX  < m_cntEndPosition.mX){
			speaker.playTone(840U, 500U, 50U);
			m_lCt = 0;
			return true;
		}
	}
	else if(m_iXY == Em_SectionChange::YPlus){
		if(currentPosition.mY  > m_cntEndPosition.mY){
			speaker.playTone(840U, 500U, 50U);
			m_lCt = 0;
			return true;
		}
	}
	else{
		if(currentPosition.mY < m_cntEndPosition.mY){
			speaker.playTone(840U, 500U, 50U);
			m_lCt = 0;
			return true;
		}
	}

	return false;
}
