///////////////////////////////////////////////////////////
//  UI.h
//  Implementation of the Class UI
//  Created on:      09-7-2011 20:24:52
//  Original author: u90499
///////////////////////////////////////////////////////////

#ifndef UI_H_
#define UI_H_


#include "TouchSensor.h"
#include "LightSensor.h"
#include "DriverMgr.h"
#include "SonarSensor.h"
#include "Nxt.h"
#include "Clock.h"
#include "Lcd.h"
#include "Vector.h"

using namespace ecrobot;

extern "C"
{
	#include "ecrobot_interface.h"
};


class UI
{

public:
	UI(LightSensor* pLightSensor, TouchSensor* pTouchSensor, SonarSensor* pSoner,Nxt* pNxt, Lcd* pLcd, DriverMgr* pDriverMgr);
	virtual ~UI();


	//
	// Lu[Vʂ\
	//
	void printcalibration();
	
	S16 calibrate(char* chData);

	
	//
	// R[Xݒʂ\
	//
	void printCourceSelect();

	void selectCource(Em_CourseKind::eCourseKind& eInOutFlag, bool& bDifficultStageFlag);

	
	//
	// ^b`ZT҂
	//
	void waitForTouchSenserOn();
	
	
	void printDifficultStage();

	void printResult(Em_CourseKind::eCourseKind eInOutFlag, bool bDifficultStageFlag);

	void notifyTaskEnd(){m_bTaskActive = false;}


private:
	DriverMgr* m_DriverMgr;
	TouchSensor* m_touch;
	LightSensor* m_light;
	Nxt* m_pNxt;
	Lcd* m_pLcd;
	bool m_bTaskActive;
	SonarSensor* m_pSoner;
	
	void printData(char* str,int SleepTme);
	bool selectBotton(CHAR chTrueData[],CHAR chFalseData[]);
	bool selectOKNG();

};
#endif
