package com.yuji.ec;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.yuji.ec.common.CommonUtil;
import com.yuji.ec.common.Constant;
import com.yuji.ec.db.NoteDao;
import com.yuji.ec.task.NoteUpdateTask;
import com.yuji.ec.utility.AsyncTaskCommand;
import com.yuji.ec.utility.BaseActivity;
import com.yuji.ec.utility.EditPrefUtil;
import com.yuji.ec.utility.EvernoteUtil;

public class NoteUpdatorActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);

	private TextView updatorMessage = null;
	private LinearLayout noteLayout = null;
	private Spinner noteTypeSpinner = null;
	private LinearLayout noteTypeLayout = null;
	private TextView noteTypeView = null;
	private Button noteTypeButton = null;
	private Button updateButton = null;
	private Button closeButton = null;

	private String guid;
	private boolean isEmpty = true;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.note_updator);

		updatorMessage = (TextView) this.findViewById(R.id.updatorMessage);
		noteLayout = (LinearLayout) this.findViewById(R.id.updatorLayout);
		noteTypeSpinner = (Spinner) this.findViewById(R.id.updatorNoteSpinner);
		noteTypeLayout = (LinearLayout) this
				.findViewById(R.id.updatorNoteLayout);
		noteTypeView = (TextView) this.findViewById(R.id.updatorNoteText);
		noteTypeButton = (Button) this.findViewById(R.id.updatorNoteButton);

		updateButton = (Button) this.findViewById(R.id.updatorUpdateButton);
		closeButton = (Button) this.findViewById(R.id.updatorCloseButton);

		noteTypeSpinner.setOnItemSelectedListener(new OnItemSelectedListener() {
			public void onItemSelected(AdapterView<?> parent, View view,
					int position, long id) {
				noteTypeSpinnerItemSelected(parent, view, position, id);
			}

			public void onNothingSelected(AdapterView<?> view) {
				;
			}
		});
		noteTypeButton.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				noteTypeButtonOnClick();
			}
		});
		updateButton.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				updateButtonOnClick();
			}
		});
		closeButton.setOnClickListener(new OnClickListener() {
			public void onClick(View view) {
				closeButtonOnClick();
			}
		});

		String msg = getString(R.string.updatorMessage);
		msg = CommonUtil.replaceString(msg, "\\\\n", "\n");
		updatorMessage.setText(msg);
		
		ArrayAdapter<CharSequence> noteTypeAdapter = ArrayAdapter
				.createFromResource(this, R.array.note_item_array,
						android.R.layout.simple_spinner_item);
		noteTypeAdapter
				.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		noteTypeSpinner.setAdapter(noteTypeAdapter);
	}

	@Override
	public void onStart() {
		super.onStart();

		int noteItemType = pref.getInt(Constant.PREF_NOTE_ITEM_TYPE_TMP,
				Constant.NOTE_ITEM_TYPE_ALL);
		noteTypeSpinner.setSelection(noteItemType);

		guid = pref.get(Constant.PREF_NOTE_ITEM_GUID_TMP);

		String title = pref.get(Constant.PREF_NOTE_ITEM_TEXT);
		noteTypeView.setText(title);
	}

	@Override
	public void onPause() {
		int noteItemType = noteTypeSpinner.getSelectedItemPosition();
		pref.put(Constant.PREF_NOTE_ITEM_TYPE_TMP, noteItemType);

		pref.update();

		super.onPause();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (resultCode == RESULT_OK) {
			Bundle ex = data.getExtras();
			String guid = ex.getString(Constant.EXTRA_GUID);
			String title = ex.getString(Constant.EXTRA_TITLE);
			int noteItemType = noteTypeSpinner.getSelectedItemPosition();

			this.guid = guid;
			pref.put(Constant.PREF_NOTE_ITEM_GUID_TMP, guid);
			pref.put(Constant.PREF_NOTE_ITEM_TEXT, title);
			pref.put(Constant.PREF_NOTE_ITEM_GUID_TYPE_TMP, noteItemType);
			pref.update();

			noteTypeView.setText(title);
		}

		setStatus();
	}

	private void noteTypeSpinnerItemSelected(AdapterView<?> parent, View view,
			int position, long id) {
		setStatus();
	}

	private void noteTypeButtonOnClick() {
		NoteTypeListActivity.init();
		Intent intent = new Intent(this, (Class<?>) NoteTypeListActivity.class);
		startActivityForResult(intent, 0);
	}

	private void updateButtonOnClick() {
		int noteItemType = noteTypeSpinner.getSelectedItemPosition();

		NoteUpdateTask task = new NoteUpdateTask(this, noteItemType, guid);
		AsyncTaskCommand command = new AsyncTaskCommand(this, task);
		command.setTitle(getString(R.string.updatorNoteDialogTitle));
		command.setButtonTitle(getString(R.string.cancelButton));
		command.setCancelable(false);
		command.execute("");
	}

	private void closeButtonOnClick() {
		finish();
	}

	public void done(EvernoteUtil.Error errorCode) {
		if (errorCode != null && !errorCode.equals(EvernoteUtil.Error.NONE)) {
			EvernoteUtil util = EvernoteUtil.getInstance();
			Toast.makeText(this, util.getErrorMessage(this, errorCode),
					Toast.LENGTH_LONG).show();

			closeButtonOnClick();
			return;
		}

		int noteItemType = noteTypeSpinner.getSelectedItemPosition();
		pref.put(Constant.PREF_NOTE_ITEM_TYPE, noteItemType);
		pref.copy(Constant.PREF_NOTE_ITEM_GUID_TMP,
				Constant.PREF_NOTE_ITEM_GUID);
		if (noteItemType == Constant.NOTE_ITEM_TYPE_ALL){
			pref.remove(Constant.PREF_NOTE_ITEM_GUID);
			pref.remove(Constant.PREF_NOTE_ITEM_TEXT);
		}
		pref.update();
		
		closeButtonOnClick();
	}

	private void setStatus() {
		int noteItemType = noteTypeSpinner.getSelectedItemPosition();
		int guidType = pref.getInt(Constant.PREF_NOTE_ITEM_GUID_TYPE_TMP, -1);

		boolean enabled = false;
		if (noteItemType == Constant.NOTE_ITEM_TYPE_ALL) {
			enabled = true;
		}
		else if (guidType >= 0 && guidType == noteItemType) {
			enabled = true;
		}

		updateButton.setEnabled(enabled);
		noteTypeLayout
				.setVisibility((noteItemType == Constant.NOTE_ITEM_TYPE_ALL) ? View.GONE
						: View.VISIBLE);

		NoteDao dao = (NoteDao) NoteDao.getInstance();
		isEmpty = dao.isEmpty();
		if (isEmpty) {
			noteLayout.setVisibility(View.VISIBLE);
		} else {
			noteLayout.setVisibility(View.GONE);
		}
	}

	public static void init(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);

		pref.copy(Constant.PREF_NOTE_ITEM_TYPE,
				Constant.PREF_NOTE_ITEM_TYPE_TMP);
		pref.copy(Constant.PREF_NOTE_ITEM_GUID,
				Constant.PREF_NOTE_ITEM_GUID_TMP);
		pref.copy(Constant.PREF_NOTE_ITEM_TYPE,
				Constant.PREF_NOTE_ITEM_GUID_TYPE_TMP);

		pref.update();
	}
}
