package com.yuji.ef.task;

import java.lang.ref.WeakReference;

import com.yuji.ef.SettingActivity;
import com.yuji.ef.utility.AsyncTaskIF;
import com.yuji.ef.utility.FolderUtil;

public class NoteUpdateTask implements AsyncTaskIF {
	private WeakReference<SettingActivity> activityRef;
	
	private boolean isRoot;
	private boolean isBook;
	private boolean isNote;
	private int errorCode = -1;
	
	public NoteUpdateTask(SettingActivity activity, boolean isRoot, boolean isBook, boolean isNote) {
		activityRef = new WeakReference<SettingActivity>(activity);
		this.isRoot = isRoot;
		this.isBook = isBook;
		this.isNote = isNote;
	}

	public void doExecute() {
		// TODO
		// 実行中は、画面操作禁止にする
		try {
			FolderUtil util = FolderUtil.getInstance();
			util.update(isRoot, isBook, isNote);
		}
		catch (Exception e){
			// TODO
			e.printStackTrace();
		}
	}

	public void cancel() {

	}

	public void done(boolean isCancel) {
		SettingActivity activity = activityRef.get();
		if (activity != null) {
			activity.done(errorCode);
			activityRef = null;
		}
	}

	@Override
	public int getStatus() {
		// TODO
		return 0;
	}
}
