/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.conn.mobile;

import com.evernote.client.conn.mobile.DiskBackedByteStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TEvernoteHttpClient
extends TTransport {
    private static final int MEMORY_BUFFER_SIZE = 524288;
    private URL url_ = null;
    private String userAgent = null;
    private final DiskBackedByteStore requestBuffer_;
    private InputStream inputStream_ = null;
    private Map<String, String> customHeaders_ = null;
    private HttpRequestBase request = null;
    private HttpParams httpParameters = new BasicHttpParams();
    private ClientConnectionManager mConnectionManager;
    private DefaultHttpClient mHttpClient;

    public TEvernoteHttpClient(String url, String userAgent, File tempDir) throws TTransportException {
        this.getHTTPClient();
        this.userAgent = userAgent;
        try {
            this.url_ = new URL(url);
            this.requestBuffer_ = new DiskBackedByteStore(tempDir, "http", 524288);
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public void setConnectTimeout(int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpParameters, (int)timeout);
    }

    public void setReadTimeout(int timeout) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParameters, (int)timeout);
    }

    public void setCustomHeaders(Map<String, String> headers) {
        this.customHeaders_ = headers;
    }

    public void setCustomHeader(String key, String value) {
        if (this.customHeaders_ == null) {
            this.customHeaders_ = new HashMap<String, String>();
        }
        this.customHeaders_.put(key, value);
    }

    public void open() {
    }

    public void close() {
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
        if (this.mConnectionManager != null) {
            this.mConnectionManager.shutdown();
            this.mConnectionManager = null;
        }
    }

    public boolean isOpen() {
        return true;
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int ret = this.inputStream_.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            return ret;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    private DefaultHttpClient getHTTPClient() {
        try {
            if (this.mConnectionManager != null) {
                this.mConnectionManager.closeExpiredConnections();
                this.mConnectionManager.closeIdleConnections(1L, TimeUnit.SECONDS);
            } else {
                BasicHttpParams params = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
                ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)20);
                ConnManagerParams.setTimeout((HttpParams)params, (long)10000L);
                ConnPerRouteBean connPerRoute = new ConnPerRouteBean(18);
                ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRoute);
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
                this.mConnectionManager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
                DefaultHttpClient httpClient = new DefaultHttpClient(this.mConnectionManager, (HttpParams)params);
                httpClient.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                        return 120000L;
                    }
                });
                httpClient.setReuseStrategy(new ConnectionReuseStrategy(){

                    public boolean keepAlive(HttpResponse response, HttpContext context) {
                        return true;
                    }
                });
                this.mHttpClient = httpClient;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return this.mHttpClient;
    }

    public void write(byte[] buf, int off, int len) {
        this.requestBuffer_.write(buf, off, len);
    }

    public void flush() throws TTransportException {
        long timer = System.currentTimeMillis();
        HttpEntity httpEntity = null;
        try {
            try {
                HttpPost request = new HttpPost(this.url_.toExternalForm());
                this.request = request;
                request.addHeader("Content-Type", "application/x-thrift");
                request.addHeader("Cache-Control", "no-transform");
                if (this.customHeaders_ != null) {
                    for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                        request.addHeader(header.getKey(), header.getValue());
                    }
                }
                InputStreamEntity entity = new InputStreamEntity(this.requestBuffer_.getInputStream(), (long)this.requestBuffer_.getSize());
                request.setEntity((HttpEntity)entity);
                request.addHeader("Accept", "application/x-thrift");
                request.addHeader("User-Agent", this.userAgent == null ? "Java/THttpClient" : this.userAgent);
                request.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                DefaultHttpClient dHTTP = this.getHTTPClient();
                HttpResponse response = dHTTP.execute((HttpUriRequest)request);
                httpEntity = response.getEntity();
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode != 200) {
                    if (httpEntity != null) {
                        httpEntity.consumeContent();
                    }
                    throw new TTransportException("HTTP Response code: " + responseCode);
                }
                this.requestBuffer_.reset();
                this.inputStream_ = response.getEntity().getContent();
            }
            catch (IOException iox) {
                throw new TTransportException((Throwable)iox);
            }
            catch (Exception ex) {
                throw new TTransportException((Throwable)ex);
            }
        }
        finally {
            try {
                this.requestBuffer_.reset();
            }
            catch (IOException iOException) {}
            this.request = null;
        }
    }

    public void cancel() {
        try {
            if (this.request != null) {
                this.request.abort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
    }

    public void reset() {
    }
}

