package com.yuji.em.utility;

import android.content.Context;

import com.yuji.em.common.CommonUtil;
import com.yuji.em.common.Constant;

public class PasswordUtil {
	 private static Encryption encryption = Encryption.getInstance();

	 public static String getUsername(Context context){
		EditPrefUtil pref = new EditPrefUtil(context);	
		String str = pref.get(Constant.PREF_USER);
		if (CommonUtil.isNull(str)){
			return null;
		}
		return encryption.getDecrypted(context, str);
	}

	public static String getPassword(Context context){
		EditPrefUtil pref = new EditPrefUtil(context);	
		String str = pref.get(Constant.PREF_PASSWORD);
		if (CommonUtil.isNull(str)){
			return null;
		}
		return encryption.getDecrypted(context, str);
	}
	
	public static void setUserAndPassword(Context context, String user, String password){
		EditPrefUtil pref = new EditPrefUtil(context);	

		 String str;
		 
		 str = encryption.getEncrypted(context, user);
		 pref.put(Constant.PREF_USER, str);

		 str = encryption.getEncrypted(context, password);
		 pref.put(Constant.PREF_PASSWORD, str);

		 pref.update();
	}
}
