package com.yuji.em;

import java.util.List;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import com.yuji.em.common.CommonUtil;
import com.yuji.em.common.Constant;
import com.yuji.em.data.Note;
import com.yuji.em.data.NoteDao;
import com.yuji.em.utility.BaseActivity;
import com.yuji.em.utility.EditPrefUtil;

public class SelectNoteListActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);
	private LinearLayout messageLayout = null;
	private TextView titleView = null;
	private TextView messageView = null;
	private Button editButton;
	private Button deleteButton;
	private Button cancelButton;
	private Button yesButton;
	private Button noButton;
	private ListView selectListView;
	private boolean isEmpty = true;

	private static int selectedIndex = -1;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.select_note_list);

		titleView = (TextView) this.findViewById(R.id.selectListTitle);
		messageLayout = (LinearLayout) this.findViewById(R.id.selectListLayout);
		messageView = (TextView) this.findViewById(R.id.selectListConfirmDeleteMsg);
		editButton = (Button) this.findViewById(R.id.selectListEditButton);
		deleteButton = (Button) this.findViewById(R.id.selectListDeleteButton);
		cancelButton = (Button) this.findViewById(R.id.selectListCancelButton);
		yesButton = (Button) this.findViewById(R.id.selectListYesButton);
		noButton = (Button) this.findViewById(R.id.selectListNoButton);
		selectListView = (ListView) this.findViewById(R.id.selectListView);

		editButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				editButtonOnClick();
			}
		});

		deleteButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				deleteButtonOnClick();
			}
		});

		cancelButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				cancelButtonOnClick();
			}
		});

		yesButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				yesButtonOnClick();
			}
		});

		noButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				noButtonOnClick();
			}
		});

		selectListView.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> parent, View view,
					int position, long id) {
				selectListViewOnItemClick(parent, view, position, id);
			}
		});

		// #27899
		selectListView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		updateList();
		selectedIndex = pref.getInt(Constant.PREF_NOTE_INDEX);
		setStatus(null);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (resultCode == RESULT_OK) {
			init(this);	
			updateList();
			setStatus(null);
		}
	}

	@Override
	protected void onStart(){
		super.onStart();
		
		selectedIndex = pref.getInt(Constant.PREF_NOTE_INDEX);
	}
	
	@Override
	protected void onPause() {
		pref.put(Constant.PREF_NOTE_INDEX, selectedIndex);
		pref.update();
		
		super.onPause();
	}

	private void updateList() {
		NoteDao dao = NoteDao.getInstance();
		List<Note> list = dao.search(this);
		ArrayAdapter<Note> adapter = new ArrayAdapter<Note>(this,
				R.layout.simple_list_item_2, R.id.text3, list);
		selectListView.setAdapter(adapter);

		isEmpty = dao.isEmpty(list);
	}

	protected void selectListViewOnItemClick(AdapterView<?> parent, View view,
			int position, long id) {
		selectedIndex = position;
		setStatus(parent);
	}

	private void editButtonOnClick() {
		if (selectedIndex < 0) {
			return;
		}

		Intent intent = new Intent(this, (Class<?>) NoteListActivity.class);
		intent.putExtra(Constant.EXTRA_INDEX, selectedIndex);
		startActivityForResult(intent, 0);
	}

	private void deleteButtonOnClick() {
		setStatus(deleteButton);
	}

	private void cancelButtonOnClick() {
		finish();
	}

	private void yesButtonOnClick() {
		if (selectedIndex < 0) {
			return;
		}

		NoteDao dao = NoteDao.getInstance();
		Note note = new Note("", "");
		dao.update(this, note, selectedIndex);

		updateList();

		setStatus(yesButton);
	}

	private void noButtonOnClick() {
		setStatus(noButton);
	}

	private boolean isSelected() {
		return selectedIndex >= 0;
	}

	private void setStatus(View view) {
		if (view == null) {
			if (isEmpty) {
				messageLayout.setVisibility((isEmpty) ? View.VISIBLE
						: View.GONE);
				messageView.setText(R.string.selectListConfirmNoteMsg);
				selectListView.setEnabled(true);
				editButton.setVisibility(View.VISIBLE);
				editButton.setEnabled(false);
				deleteButton.setVisibility(View.VISIBLE);
				deleteButton.setEnabled(false);
				yesButton.setVisibility(View.GONE);
				noButton.setVisibility(View.GONE);
			} if (!isSelected()){
				messageLayout.setVisibility((isEmpty) ? View.VISIBLE
						: View.GONE);
				selectListView.setEnabled(true);
				editButton.setVisibility(View.VISIBLE);
				editButton.setEnabled(false);
				deleteButton.setVisibility(View.VISIBLE);
				deleteButton.setEnabled(false);
				yesButton.setVisibility(View.GONE);
				noButton.setVisibility(View.GONE);
			}
			else {
				messageLayout.setVisibility((isEmpty) ? View.VISIBLE
						: View.GONE);
				selectListView.setEnabled(true);
				editButton.setVisibility(View.VISIBLE);
				editButton.setEnabled(true);
				Note item = (Note) selectListView.getItemAtPosition(selectedIndex);
				deleteButton.setVisibility(View.VISIBLE);
				deleteButton.setEnabled(!CommonUtil.isNull(item.getTitle()));
				yesButton.setVisibility(View.GONE);
				noButton.setVisibility(View.GONE);
			}
		} else if (view == selectListView) {
			messageLayout.setVisibility((isEmpty) ? View.VISIBLE : View.GONE);
			selectListView.setEnabled(true);
			editButton.setVisibility(View.VISIBLE);
			editButton.setEnabled(isSelected());
			Note item = (Note) selectListView.getItemAtPosition(selectedIndex);
			deleteButton.setVisibility(View.VISIBLE);
			deleteButton.setEnabled(isSelected() && !CommonUtil.isNull(item.getTitle()));
			yesButton.setVisibility(View.GONE);
			noButton.setVisibility(View.GONE);
		} else if (view == deleteButton) {
			messageLayout.setVisibility(View.VISIBLE);
			messageView.setText(getString(R.string.selectListConfirmDeleteMsg));
			selectListView.setEnabled(false);
			editButton.setVisibility(View.GONE);
			deleteButton.setVisibility(View.GONE);
			yesButton.setVisibility(View.VISIBLE);
			noButton.setVisibility(View.VISIBLE);
		} else if (view == yesButton) {
			setStatus(null);
		} else if (view == noButton) {
			setStatus(selectListView);
		}
	}
	
	public static void init(Context context){
		EditPrefUtil pref = new EditPrefUtil(context);
		pref.put(Constant.PREF_NOTE_INDEX, -1);
		pref.update();
		
		selectedIndex = -1;
	}
}
