package com.yuji.em.task;

import java.lang.ref.WeakReference;
import java.util.List;

import com.evernote.edam.notestore.NoteList;
import com.yuji.em.NoteListActivity;
import com.yuji.em.utility.AsyncTaskIF;
import com.yuji.em.utility.EvernoteUtil;

public class NoteListTask implements AsyncTaskIF {
	private EvernoteUtil util = EvernoteUtil.getInstance();
	private List<NoteList> noteListList;
	private WeakReference<NoteListActivity> activityRef;
	private EvernoteUtil.Error errorCode = null;

	public NoteListTask(NoteListActivity activity) {
		activityRef = new WeakReference<NoteListActivity>(activity);
	}

	@Override
	public void doExecute() {
		synchronized (util) {
			try {
				noteListList = util.getNoteList();
			} finally {
				errorCode = util.getErrorCode();
			}
		}
	}

	@Override
	public void cancel() {

	}

	@Override
	public void done(boolean isCancel) {
		NoteListActivity activity = activityRef.get();
		if (activity != null) {
			activity.done((!isCancel ? noteListList : null), errorCode);
			activityRef = null;
		}
	}

	@Override
	public int getStatus() {
		return 0;
	}

	public List<NoteList> getNoteList() {
		return noteListList;
	}

	public EvernoteUtil.Error getErrorCode() {
		return errorCode;
	}
}
