<?php
App::uses('AppController', 'Controller');
/**
 * DbTables Controller
 *
 * @property DbTable $DbTable
 */
class DbTablesController extends AppController {

    public $components = array('eXmasCake');

/**
 * script method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function script($id = null) {
        $this->DbTable->id = $id;
        if (!$this->DbTable->exists()) {
            throw new NotFoundException(INVALID_ID);
        }
		$dbTable = $this->DbTable->read(null, $id);
		$this->set('script',$this->eXmasCake->getTableSql($dbTable));
		$this->set('dbTable', $dbTable);
    }
/**
 * model method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function model($id = null) {
        $this->DbTable->id = $id;
        if (!$this->DbTable->exists()) {
            throw new NotFoundException(INVALID_ID);
        }
        $dbTable = $this->DbTable->read(null, $id);

		$names = $this->eXmasCake->getNames($dbTable['DbTable']);


        $this->set('dbTable', $dbTable);

		$displayField = '';
		$rules = '';

		$hasmany = array();
        $belongsto = '';


        if (!empty($dbTable['TableField'])) {
			$displayField = $this->eXmasCake->getDisplayField($dbTable['TableField']);
			$rules = $this->getRules($dbTable['TableField']);
			$belongs = $this->eXmasCake->getBelongsTo($dbTable['TableField']);
			$hasmanies = $this->DbTable->getHasmany($dbTable['DbTable']['symbol']);

			$hasmany = $this->eXmasCake->getHasmanies($hasmanies);
			
			if (!empty($belongs)) {
				$belongsto = SP1.'public $belongsTo = array('.PHP_EOL;
				foreach($belongs as $data) {
					foreach ($data as $key=>$value) {
        				$table = $value[0];
		        		$field = $value[1];
						$belongsto .= SP2."'$table' => array(".PHP_EOL;
				        $belongsto .= SP3."'className' => '$table',".PHP_EOL;
				        $belongsto .= SP3."'foreignKey' => '$key',".PHP_EOL;
						$belongsto .= SP3."'conditions' => '',".PHP_EOL;
						$belongsto .= SP3."'fields' => '',".PHP_EOL;
						$belongsto .= SP3."'order' => ''".PHP_EOL;
						$belongsto .= SP2."),".PHP_EOL;
					}
				}
				$belongsto .= SP1.");".PHP_EOL;
			}
		}	
		if ($rules != '') {
			$rules = SP1.'public $validate = array('.PHP_EOL.$rules.SP1.');'.PHP_EOL;
		}
		$this->set('names',$names);
	    $this->set('rules',$rules);
        $this->set('displayField',$displayField);
		$this->set('belongs',$belongsto);
		$this->set('hasmany',$hasmany);
	}
/**
 * getRules method
 *
 * @return $rules
 */
	public function getRules($tableFields) {
		$rules = '';
        foreach ($tableFields as $tableField) {
            $symbol =  $tableField['symbol'];
			$check = $this->eXmasCake->getRule($tableField);
			if (count($check)) {
				$rules .= SP2."'$symbol' => array(".PHP_EOL;
				foreach($check as $value) {
					list($rule,$message) = $value;
					$rules .= SP3."'$rule' => array(".PHP_EOL;
					$rules .= SP4."'rule' => array('$rule'),".PHP_EOL;
					$rules .= SP4."'message' => $message,".PHP_EOL;
					$rules .= SP3."),".PHP_EOL;
				}
            }
		}
		return $rules;
	}
/**
 * create_controller method
 *
 * @return void
 */
    public function create_controller($id = null) {
        $this->DbTable->id = $id;
        if (!$this->DbTable->exists()) {
            throw new NotFoundException(INVALID_ID);
        }
        $dbTable = $this->DbTable->read(null, $id);
		$belongs = $this->eXmasCake->getBelongsTo($dbTable['TableField']);
		$this->set('dbTable', $dbTable);
		$index = $this->getIndexMethod($dbTable['DbTable']['symbol']);
		$view = $this->getViewMethod($dbTable['DbTable']['symbol']);
		$add = $this->getAddMethod($dbTable,$belongs);
		$edit = $this->getEditMethod($dbTable,$belongs);
		$delete = $this->getDeleteMethod($dbTable['DbTable']['symbol']);
        $className = Inflector::camelize($dbTable['DbTable']['symbol']);
        $property =  Inflector::classify($dbTable['DbTable']['symbol']);
        $this->set('className',$className);
        $this->set('property',$property);
		$this->set('index',$index);
		$this->set('view',$view);
		$this->set('add',$add);
		$this->set('edit',$edit);
		$this->set('delete',$delete);
	}
/**
 * getIndexMethod method
 *
 * @return $index
 */
	public function getIndexMethod($symbol) {
		$index = SP1.'public function index() {'.PHP_EOL;
		$index .= SP2.'$this->'.Inflector::classify($symbol).'->recursive = 0;'.PHP_EOL;
		$index .= SP2.'$this->set(\''.$symbol.'\', $this->paginate());'.PHP_EOL;
		$index .= SP1.'}'.PHP_EOL;
		return $index;
	}
/**
 * getViewMethod method
 *
 * @return $view
 */
	public function getViewMethod($symbol) {
		$property = Inflector::classify($symbol);
    	$view = SP1.'public function view($id = null) {'.PHP_EOL;
        $view .= SP2.'$this->'.$property.'->id = $id;'.PHP_EOL;
        $view .= SP2.'if (!$this->'.$property.'->exists()) {'.PHP_EOL;
	    $view .= SP3.'throw new NotFoundException(INVALID_ID);'.PHP_EOL;
		$view .= SP2.'}'.PHP_EOL;
		$view .= SP2.'$this->set(\''.strtolower($property).'\', $this->'.$property.'->read(null, $id));'.PHP_EOL;
		$view .= SP1.'}';
		return $view;
	}

/**
 * getAddMethod
 *
 * @return $add
 */
	public function getAddMethod($dbTable,$belongs) {
		$symbol = $dbTable['DbTable']['symbol'];

		$property = Inflector::classify($symbol);

		$add = SP1.'public function add() {'.PHP_EOL;
		$add .= SP2.'if ($this->request->is(\'post\')) {'.PHP_EOL;
		$add .= SP3.'$this->'.$property.'->create();'.PHP_EOL;
		$add .= SP3.'if ($this->'.$property.'->save($this->request->data)) {'.PHP_EOL;
		$add .= SP4.'$this->Session->setFlash(SAVE_OK);'.PHP_EOL;
		$add .= SP4.'$this->redirect(array(\'action\' => \'index\'));'.PHP_EOL;
		$add .= SP3.'} else {'.PHP_EOL;
		$add .= SP4.'$this->Session->setFlash(SAVE_NG);'.PHP_EOL;
		$add .= SP3.'}'.PHP_EOL;
		$add .= SP2.'}'.PHP_EOL;
		if (!empty($belongs)) {
            foreach($belongs as $data) {
				foreach ($data as $key=>$value) {
					$val = strtolower(Inflector::pluralize($value[0]));
					$add .= SP2.'$'.$val.' = $this->'.$property.'->'.Inflector::classify($value['0']).'->find(\'list\');'.PHP_EOL;
					$add .= SP2.'$this->set(compact(\''.$val.'\'));'.PHP_EOL;
				}
			}
		}
		$add .= SP1.'}'.PHP_EOL;
		return $add;
	}
/**
 * 
 */
	public function getEditMethod($dbTable,$belongs) {
		$property = Inflector::classify($dbTable['DbTable']['symbol']);
		$edit = SP1.'public function edit($id = null) {'.PHP_EOL;
		$edit .= SP2.'$this->'.$property.'->id = $id;'.PHP_EOL;
		$edit .= SP2.'if (!$this->'.$property.'->exists()) {'.PHP_EOL;
		$edit .= SP3.'throw new NotFoundException(INVALID_ID);'.PHP_EOL;
		$edit .= SP2.'}'.PHP_EOL;
		$edit .= SP2.'if ($this->request->is(\'post\') || $this->request->is(\'put\')) {'.PHP_EOL;
		$edit .= SP3.'if ($this->'.$property.'->save($this->request->data)) {'.PHP_EOL;
		$edit .= SP4.'$this->Session->setFlash(SAVE_OK);'.PHP_EOL;
		$edit .= SP4.'$this->redirect(array(\'action\' => \'index\'));'.PHP_EOL;
		$edit .= SP3.'} else {'.PHP_EOL;
		$edit .= SP4.'$this->Session->setFlash(SAVE_NG);'.PHP_EOL;
		$edit .= SP3.'}'.PHP_EOL;
		$edit .= SP2.'} else {'.PHP_EOL;
		$edit .= SP3.'$this->request->data = $this->'.$property.'->read(null, $id);'.PHP_EOL;
		$edit .= SP2.'}'.PHP_EOL;
        if (!empty($belongs)) {
            foreach($belongs as $data) {
                foreach ($data as $key=>$value) {
                    $val = strtolower(Inflector::pluralize($value[0]));
                    $edit .= SP2.'$'.$val.' = $this->'.$property.'->'.Inflector::classify($value['0']).'->find(\'list\');'.PHP_EOL;
                    $edit .= SP2.'$this->set(compact(\''.$val.'\'));'.PHP_EOL;
                }
            }
        }
		$edit .= SP1.'}'.PHP_EOL;
		return $edit;
	}	
/**
 * getDeleteMethod method
 *
 * return $delete
 */
	public function getDeleteMethod($symbol) {
		$property = Inflector::classify($symbol);
		$delete = SP1.'public function delete($id = null) {'.PHP_EOL;
		$delete .= SP2.'if (!$this->request->is(\'post\')) {'.PHP_EOL;
		$delete .= SP3.'throw new MethodNotAllowedException();'.PHP_EOL;
		$delete .= SP2.'}'.PHP_EOL;
		$delete .= SP2.'$this->'.$property.'->id = $id;'.PHP_EOL;
		$delete .= SP2.'if (!$this->'.$property.'->exists()) {'.PHP_EOL;
		$delete .= SP3.'throw new NotFoundException(INVALID_ID);'.PHP_EOL;
		$delete .= SP2.'}'.PHP_EOL;   
		$delete .= SP2.'if ($this->'.$property.'->delete()) {'.PHP_EOL;
		$delete .= SP3.'$this->Session->setFlash(DEL_OK);'.PHP_EOL;
		$delete .= SP3.'$this->redirect(array(\'action\' => \'index\'));'.PHP_EOL;
		$delete .= SP2.'}'.PHP_EOL;   
		$delete .= SP2.'$this->Session->setFlash(DEL_NG);'.PHP_EOL;
		$delete .= SP2.'$this->redirect(array(\'action\' => \'index\'));'.PHP_EOL;
		$delete .= SP1.'}'.PHP_EOL;       		
		return $delete;
	}

/**
 * index_view method
 *
 * @return void
 */
	public function index_view($id = null) {
		$this->DbTable->id = $id;
		if (!$this->DbTable->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$this->data_set($id);
	}
/**
 * add_view method
 *
 * @return void
 */
    public function add_view($id = null) {
        $this->DbTable->id = $id;
        if (!$this->DbTable->exists()) {
            throw new NotFoundException(INVALID_ID);
        }
		$this->data_set($id);
    }

/**
 * edit_view method
 *
 * @return void
 */
    public function edit_view($id = null) {
        $this->DbTable->id = $id;
        if (!$this->DbTable->exists()) {
            throw new NotFoundException(INVALID_ID);
		}   
		$this->data_set($id);
    }   
/** 
 * view_view method
 *      
 * @return void
 */     
    public function view_view($id = null) {
        $this->DbTable->id = $id;
        if (!$this->DbTable->exists()) {
            throw new NotFoundException(INVALID_ID);
        }   
        $this->data_set($id);
    }   

/*
 * data_set method
 *
 * @return void
 */
	public function data_set($id) {
        $dbTable = $this->DbTable->read(null, $id);
        $this->set('dbTable', $dbTable);
        $className = Inflector::camelize($dbTable['DbTable']['symbol']);
        $property =  Inflector::classify($dbTable['DbTable']['symbol']);
        $this->set('className',$className);
        $this->set('property',$property);
	}
/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->DbTable->recursive = 0;
		$this->paginate=array(
    		'limit' => 10, 
    		'sort' => 'id',
		 );	
		$this->set('dbTables', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function view($id = null) {
		$this->DbTable->id = $id;
		if (!$this->DbTable->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$this->set('dbTable', $this->DbTable->read(null, $id));
	}
/**
	* related_view method
	*
	* @throws NotFoundException
	* @param string $id
	* @return void
 */
	public function related_view($id = null) {
		$this->DbTable->id = $id;
		if (!$this->DbTable->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$this->set('dbTable', $this->DbTable->read(null, $id));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->DbTable->create();
			if ($this->DbTable->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		}
		$dbs = $this->DbTable->Db->find('list');
		$this->set(compact('dbs'));
	}
/**
	* related_add method
	*
	* @return void
 */
	public function related_add($id=null) {
		if ($this->request->is('post')) {
			if ($this->DbTable->existsName($id,$this->request->data['DbTable']['name'],$this->request->data['DbTable']['symbol'])) {
				$this->Session->setFlash(UNIQUE_NG);
				$this->redirect(array('controller'=>'dbs','action' => 'view'.DS.$id));
			} else {
				$this->DbTable->create();
				if ($this->DbTable->save($this->request->data)) {
					$this->Session->setFlash(SAVE_OK);
					$this->redirect(array('controller'=>'dbs','action' => 'view'.DS.$id));
				} else {
					$this->Session->setFlash(SAVE_NG);
				}
			}
		}
		$dbs = $this->DbTable->Db->read(null,$id);
		$this->set('dbs',$dbs);
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function edit($id = null) {
		$this->DbTable->id = $id;
		if (!$this->DbTable->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->DbTable->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		} else {
			$this->request->data = $this->DbTable->read(null, $id);
		}
		$dbs = $this->DbTable->Db->find('list');
		$this->set(compact('dbs'));
	}

/** reted_edit method
	*
	* @throws NotFoundException
	* @param string $id
	* @return void
*/
public function related_edit($id = null) {
	$this->DbTable->id = $id;
	if (!$this->DbTable->exists()) {
		throw new NotFoundException(INVALID_ID);
	}
	if ($this->request->is('post') || $this->request->is('put')) {
		if ($this->DbTable->save($this->request->data)) {
			$this->Session->setFlash(SAVE_OK);
			$this->redirect(array('action' => 'related_view'.DS.$id));
		} else {
			$this->Session->setFlash(SAVE_NG);
		}

	} else {
		$this->request->data = $this->DbTable->read(null, $id);
	}
	$dbs = $this->DbTable->Db->find('list');
	$this->set(compact('dbs'));
}
/*
 * delete method
 *
 * @throws MethodNotAllowedException
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function delete($id = null) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->DbTable->id = $id;
		if (!$this->DbTable->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->DbTable->delete()) {
			$this->Session->setFlash(DEL_OK);
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(DEL_NG);
		$this->redirect(array('action' => 'index'));
	}
/*
	* related_delete method
	*
	* @throws MethodNotAllowedException
	* @throws NotFoundException
	* @param string $id
	* @return void
 */
	public function related_delete($id = null,$db_id) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->DbTable->id = $id;
		if (!$this->DbTable->exists()) {
			throw new NotFoundException(INVALID_ID);
		}

		$options = array();
		$options['TableField.db_table_id'] = $id; 
		$this->DbTable->TableField->deleteAll($options);

		if ($this->DbTable->delete()) {
			$this->Session->setFlash(DEL_OK);
			$this->redirect(array('controller'=>'dbs','action' => 'view'.DS.$db_id));
		}
		$this->Session->setFlash(DEL_NG.$this->DbTable);
		$this->redirect(array('controller'=>'dbs','action' => 'view'.DS.$db_id));
    }	

}
