<?php
App::uses('AppModel', 'Model');
/**
 * DbTable Model
 *
 * @property Db $Db
 * @property TableField $TableField
 */
class DbTable extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => NOTEMPTY,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'symbol' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => NOTEMPTY,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'db_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'message' => NUMERIC,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
			'notempty' => array(
				'rule' => array('notempty'),
				'message' => NOTEMPTY,
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Db' => array(
			'className' => 'Db',
			'foreignKey' => 'db_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'TableField' => array(
			'className' => 'TableField',
			'foreignKey' => 'db_table_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => 'line_no',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

	public function existsName($db_id,$name,$symbol) {
		$que = "select count(*) as num from db_tables where (symbol = '$symbol' or name = '$name') and db_id = $db_id ";
		$res = $this->Query($que);
		return ($res[0][0]['num'] > 0) ? true:false;
	}

	public function getHasmany($symbol) {
		$que = "select a.symbol as table_name,b.symbol as field_name from db_tables as a, table_fields as b where b.foreign_table ilike '$symbol' and a.id = b.db_table_id";
		$res = $this->Query($que);
		if (count($res)) {
			return $res[0];
		} else {
			return null;
		}
	}

}
