<?php
App::uses('AppController', 'Controller');
/**
 * Projects Controller
 *
 * @property Project $Project
 */
class ProjectsController extends AppController {

    var $status = array('0'=>'開始前','1'=>'実施中','9'=>'完了');

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Project->recursive = 0;
		$this->set('projects', $this->paginate());
        $this->set('status',$this->status);
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function view($id = null) {
		$this->Project->id = $id;
		if (!$this->Project->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$this->set('project', $this->Project->read(null, $id));
        $this->set('status',$this->status);
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Project->create();
			if ($this->Project->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		}
        $this->set('status',$this->status);
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function edit($id = null) {
		$this->Project->id = $id;
		if (!$this->Project->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Project->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		} else {
			$this->request->data = $this->Project->read(null, $id);
        	$this->set('status',$this->status);
		}
	}

/**
 * delete method
 *
 * @throws MethodNotAllowedException
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function delete($id = null) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->Project->id = $id;
		if (!$this->Project->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->Project->delete()) {
			$this->Session->setFlash(DEL_OK);
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(DEL_NG);
		$this->redirect(array('action' => 'index'));
	}
}
