<?php
App::uses('AppController', 'Controller');
/**
 * TableFields Controller
 *
 * @property TableField $TableField
 */
class TableFieldsController extends AppController {

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->TableField->recursive = 0;
        $this->paginate=array(
	        //  'conditions' => array(検索条件),
	        //  'fields' => array(取得するカラム),
	        //  'page' => int(数値,最初に表示するページ。デフォルトは1,'last'(小文字)も可*1),
	       'limit' => 10, // int(数値：showでも可。デフォルトは20),
		   'sort' => 'db_table_id',
		   'order' => array('db_table_id','line_no'),
		   'direction' => 'asc',
		   //  'recursive' => findAllに与える。
		);

		$this->set('tableFields', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function view($id = null) {
		$this->TableField->id = $id;
		if (!$this->TableField->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		$this->set('tableField', $this->TableField->read(null, $id));
	}
    public function related_view($id = null) {
        $this->TableField->id = $id;
        if (!$this->TableField->exists()) {
            throw new NotFoundException(INVALID_ID);
        }
        $this->set('tableField', $this->TableField->read(null, $id));
    }

/**
 * add method
 *
 * @return void
 */
	public function add() {
       if ($this->request->is('post')) {
            $db_table_id = $this->request->data['TableField']['db_table_id'];                    
            $this->request->data['TableField']['line_no'] = $this->TableField->newLine($db_table_id);    
			$this->TableField->create();
			if ($this->TableField->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		}
		$dbTables = $this->TableField->DbTable->find('list');
		$this->set(compact('dbTables'));
	}
/**
	* related_add method
	*
	* @return void
 */
	public function related_add($id) {
		if ($this->request->is('post')) {
			$db_table_id = $this->request->data['TableField']['db_table_id'];
			$this->request->data['TableField']['line_no'] = $this->TableField->newLine($db_table_id);
			$this->TableField->create();
			if ($this->TableField->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('controller'=>'db_tables','action' => 'related_view'.DS.$id));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		}
		$dbTables = $this->TableField->DbTable->read(null,$id);
		$this->set('dbTables',$dbTables);
	}

/**
 * delete method
 *
 * @throws MethodNotAllowedException
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function delete($id = null) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}
		$this->TableField->id = $id;
		if (!$this->TableField->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->TableField->delete()) {
			$this->Session->setFlash(DEL_OK);
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(DEL_NG);
		$this->redirect(array('action' => 'index'));
	}
/**
 * realed_edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function related_edit($id = null) {
		$this->TableField->id = $id;
		if (!$this->TableField->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			$tf = $this->request->data['TableField'];
			if ($tf['current_line_no'] != $tf['line_no']) {
				$this->TableField->resetLineNo($tf['db_table_id'],$tf['current_line_no'] ,$tf['line_no']);
			}
		
			if ($this->TableField->save($this->request->data)) {
				$this->Session->setFlash(SAVE_OK);
				$this->redirect(array('action' => 'related_view'.DS.$id));
			} else {
				$this->Session->setFlash(SAVE_NG);
			}
		} else {
			$this->request->data = $this->TableField->read(null, $id);
		}
		$dbTables = $this->TableField->DbTable->find('list');
		$this->set(compact('dbTables'));
	}
/**
 * related_delete method
 *
 * @throws MethodNotAllowedException
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function related_delete($id = null,$line_no,$table_id) {
		if (!$this->request->is('post')) {
			throw new MethodNotAllowedException();
		}

		$max = $this->TableField->maxLine($table_id);
		$this->TableField->resetLineNo($table_id,$line_no,$max);
		
		$this->TableField->id = $id;
		if (!$this->TableField->exists()) {
			throw new NotFoundException(INVALID_ID);
		}
		if ($this->TableField->delete()) {
			$this->Session->setFlash(DEL_OK);
			$this->redirect(array('controller'=>'db_tables','action' => 'related_view',$table_id));
		}
		 
		$this->Session->setFlash(DEL_NG);
		$this->redirect(array('action' => 'related_view',$id));
	}
}
