#fddialogs

require 'swin'
require 'vr/vruby'
require 'vr/vrdialog'
require 'vr/vrcomctl'
require 'vr/vrhandler'
require 'vr/vrowndraw'
require 'fdvr/fdresources'

include SWin

SendDlgItemMessage=Win32API.new('user32','SendDlgItemMessage','LLLLL','L')
SendDlgItemMessage2=Win32API.new('user32','SendDlgItemMessage','LLLLP','L')
DrawFrameControl=Win32API.new('user32','DrawFrameControl','LPII','I')

module DrawFrameConst
  DFC_CAPTION = 1
  DFC_MENU = 2
  DFC_SCROLL = 3
  DFC_BUTTON = 4
  DFCS_CAPTIONCLOSE = 0
  DFCS_CAPTIONMIN = 1
  DFCS_CAPTIONMAX = 2
  DFCS_CAPTIONRESTORE = 3
  DFCS_CAPTIONHELP = 4
  DFCS_MENUARROW = 0
  DFCS_MENUCHECK = 1
  DFCS_MENUBULLET = 2
  DFCS_MENUARROWRIGHT = 4
  DFCS_SCROLLUP = 0
  DFCS_SCROLLDOWN = 1
  DFCS_SCROLLLEFT = 2
  DFCS_SCROLLRIGHT = 3
  DFCS_SCROLLCOMBOBOX = 5
  DFCS_SCROLLSIZEGRIP = 8
  DFCS_SCROLLSIZEGRIPRIGHT = 16
  DFCS_BUTTONCHECK = 0
  DFCS_BUTTONRADIOIMAGE = 1
  DFCS_BUTTONRADIOMASK = 2
  DFCS_BUTTONRADIO = 4
  DFCS_BUTTON3STATE = 8
  DFCS_BUTTONPUSH = 16
  DFCS_INACTIVE = 256
  DFCS_PUSHED = 512
  DFCS_CHECKED = 1024
  DFCS_ADJUSTRECT = 0x2000
  DFCS_FLAT = 0x4000
  DFCS_MONO = 0x8000
end

module EditMsgConst
  EM_CANUNDO = 198
  EM_CHARFROMPOS = 215
  EM_EMPTYUNDOBUFFER = 205
  EM_FMTLINES = 200
  EM_GETFIRSTVISIBLELINE = 206
  EM_GETHANDLE = 189
  EM_GETLIMITTEXT = 213
  EM_GETLINE = 196
  EM_GETLINECOUNT = 186
  EM_GETMARGINS = 212
  EM_GETMODIFY = 184
  EM_GETPASSWORDCHAR = 210
  EM_GETRECT = 178
  EM_GETSEL = 176
  EM_GETTHUMB = 190
  EM_GETWORDBREAKPROC = 209
  EM_LIMITTEXT = 197
  EM_LINEFROMCHAR = 201
  EM_LINEINDEX = 187
  EM_LINELENGTH = 193
  EM_LINESCROLL = 182
  EM_POSFROMCHAR = 214
  EM_REPLACESEL = 194
  EM_SCROLL = 181
  EM_SCROLLCARET = 183
  EM_SETHANDLE = 188
  EM_SETLIMITTEXT = 197
  EM_SETMARGINS = 211
  EM_SETMODIFY = 185
  EM_SETPASSWORDCHAR = 204
  EM_SETREADONLY = 207
  EM_SETRECT = 179
  EM_SETRECTNP = 180
  EM_SETSEL = 177
  EM_SETTABSTOPS = 203
  EM_SETWORDBREAKPROC = 208
  EM_UNDO = 199
  EN_CHANGE = 768
  EN_ERRSPACE = 1280
  EN_HSCROLL = 1537
  EN_KILLFOCUS = 512
  EN_MAXTEXT = 1281
  EN_SETFOCUS = 256
  EN_UPDATE = 1024
  EN_VSCROLL = 1538
end

module ListBoxDlgMessage
  def initialize
    super
    @sendDlgMsg=Win32API.new('user32','SendDlgItemMessage',["L"]*5,"L")
    @sendDlgMsg2=Win32API.new('user32','SendDlgItemMessage',
                                            ["L","L","L","L","P"],"L")
    @drawFrame=Win32API.new('user32','DrawFrameControl',['L','P','L','L'],'L')
    @setBkMode = Win32API.new("GDI32", "SetBkMode", ['L']*2, 'L')
    @selectObject = Win32API.new("GDI32", "SelectObject", ['L']*2, 'L')
    @textOut = Win32API.new("GDI32","TextOut",['L','L','L','P','L'],'L')
  end

  def bt_checked?(id)
    @sendDlgMsg.call(self.hWnd,id,WMsg::BM_GETCHECK,0,0)
  end

  def bt_setcheck(id)
    @sendDlgMsg.call(self.hWnd,id,WMsg::BM_SETCHECK,0,0)
  end

  def lb_addString(id,str)
    @sendDlgMsg2.call(self.hWnd,id,WMsg::LB_ADDSTRING,0,str)
  end
  def lb_insertString(id,nStart,nEnd)
    @sendDlgMsg2.call(self.hWnd,id,WMsg::LB_INSERTSTRING,nStart,nEnd)
  end
  def lb_getcount(id)
    @sendDlgMsg.call(self.hWnd,id,WMsg::LB_GETCOUNT,0,0)
  end
  def lb_getsel(id,index)
    @sendDlgMsg.call(self.hWnd,id,WMsg::LB_GETSEL,index,0)
  end
  def lb_findsel(id)
    lb_getcount(id)
    r = nil
    for i in 0..lb_getcount(id)-1
      unless lb_getsel(id,i) == 0 then
        r = i ; break
      end
    end
    r
  end

  def lb_gettext(id,idx)
    str=" " * @sendDlgMsg.call(self.hWnd,id,WMsg::LB_GETTEXTLEN,idx.to_i,0)
    @sendDlgMsg2.call(self.hWnd,id,WMsg::LB_GETTEXT,idx.to_i,str)
    str
  end
  def lb_getitemdata(id,index)
    @sendDlgMsg.call(self.hWnd,id,WMsg::LB_GETITEMDATA,index,0)
  end
  def lb_setitemdata(id,index,data)
    @sendDlgMsg.call(self.hWnd,id,WMsg::LB_SETITEMDATA,index,data)
  end
  def lb_replacesel(id,str)
    @sendDlgMsg2.call(self.hWnd,id,WMsg::EM_REPLACESEL,0,str)
  end
  def lb_setlistStrings(id,a)
    a.each{|i|
      lb_addString(id,i)
    }
  end
  def lb_getlistStrings(id)
    n=lb_getcount(id) ; r = []
    for i in 0 .. n-1
      r << lb_gettext(id,i)
    end
    r
  end

  def cb_addString(id,str)
    @sendDlgMsg2.call(self.hWnd,id,WMsg::CB_ADDSTRING,0,str)
  end
  def cb_insertString(id,nStart,nEnd)
    @sendDlgMsg2.call(self.hWnd,id,WMsg::CB_INSERTSTRING,nStart,nEnd)
  end
  def cb_getcount(id)
    @sendDlgMsg.call(self.hWnd,id,WMsg::CB_GETCOUNT,0,0)
  end
  def cb_getsel(id,index)
    @sendDlgMsg.call(self.hWnd,id,WMsg::CB_GETSEL,index,0)
  end
  def cb_getitemdata(id,index)
    @sendDlgMsg.call(self.hWnd,id,WMsg::CB_GETITEMDATA,index,0)
  end
  def cb_setitemdata(id,index,data)
    @sendDlgMsg.call(self.hWnd,id,WMsg::CB_SETITEMDATA,index,data)
  end
  def cb_selectedString(id)
    @sendDlgMsg.call(self.hWnd,id,WMsg::CB_GETCURSEL,0,0)
  end

  def cb_select(id,idx)
    @sendDlgMsg.call(self.hWnd,id,WMsg::CB_SETCURSEL,idx,0)
  end

end

class OwnerDrawModalDlg < VRModalDialog

  WM_DRAWITEM = 0x002B

  def OwnerDrawModalDlg.new(screen,template)
    r=screen.factory.newdialog(template.to_template,self)
    r.parentinit(screen)
    r.options={}
    r.addEvent WMsg::WM_INITDIALOG
    r.addEvent WMsg::WM_COMMAND
    r.addEvent WM_DRAWITEM
    return r
  end
end

class ListBoxDlg < OwnerDrawModalDlg #style Dialog
  include ListBoxDlgMessage
  include DrawFrameConst

  def msghandler(msg)
    case msg.msg
    when WMsg::WM_INITDIALOG
      setListTextData(@options["target"],@options["default"]) if @options["target"]
      setCBTextData(@options["target2"],@options["default2"]) if @options["target2"]
    when WMsg::WM_COMMAND
      if msg.wParam == @options["okbutton"] then
        close self.getListTextData(@options["target"],@options["target2"])
      elsif msg.wParam==@options["cancelbutton"] then
        close false
      elsif HIWORD(msg.wParam) == WMsg::LBN_SELCHANGE &&
                             LOWORD(msg.wParam) == @options["target"] then
        lb_selchange(LOWORD(msg.wParam))
      elsif HIWORD(msg.wParam) == WMsg::CBN_SELCHANGE &&
                             LOWORD(msg.wParam) == @options["target2"] then
        cb_selchange(LOWORD(msg.wParam))
      end
    when WM_DRAWITEM
      drawitem(SWin::Application.cstruct2array(msg.lParam,'UUUUUUUUUUUU'))
    end
  end

  def setListTextData(id,a)
    n = 0
    a.each{|i|
      lb_addString(id,i[0])
      lb_setitemdata(id,n,i[1])
      n += 1
    }
  end

  def setCBTextData(id,a)
    n = 0
    sel = a.shift
    a.each{|i|
      cb_addString(id,i[0])
      cb_setitemdata(id,n,i[1])
      n += 1
    }
    cb_select(id,sel)
  end

  def getListTextData(id1,id2)
    r = []
    r << cb_getitemdata(id2,cb_selectedString(id2)) if @options["target2"]
    for i in 0..lb_getcount(id1)-1
      r << [lb_gettext(id1,i),lb_getitemdata(id1,i)]
    end
    r
  end

  def lb_selchange(id)
     sel=lb_findsel(id)
   unless  lb_getitemdata(id,sel) == 1 then
    lb_setitemdata(id,sel,1)
   else
    lb_setitemdata(id,sel,0)
   end
   self.refresh
  end

  def drawitem(args)
    hdc=args[6];l=args[7];t=args[8];i=args[2];id=args[1]
    @setBkMode.call(hdc,1)
    a = [2,t+1,16,t+15].pack("LLLL")
    if lb_getitemdata(id,i) == 1 then
      @drawFrame.call(hdc,a,DFC_BUTTON,DFCS_BUTTONCHECK | DFCS_CHECKED )
    else
      @drawFrame.call(hdc,a,DFC_BUTTON,DFCS_BUTTONCHECK)
    end
    s = lb_gettext(id,i)
    @textOut.call(args[6],l+20,t+0,s,s.size)
  end

  def cb_selchange(id)
    #p "cb_selchage"
  end

end

class PrDlg < VRModalDialog # for preferences Dialog
  include VRCommonDialog

  def msghandler(msg)
    if msg.msg == WMsg::WM_INITDIALOG then
      self.setItemTextOf(@options["target"],@options["default"].to_s)
      self.setItemTextOf(@options["target2"],@options["default2"].to_s)
      self.bt_check(@options["checkbox"],@options["check"])
    end

    if msg.msg == WMsg::WM_COMMAND then
      if msg.wParam==@options["okbutton"] then
        close [
          self.getItemTextOf(@options["target"]),
          self.getItemTextOf(@options["target2"]) ,
          self.bt_checked?(@options["checkbox"])
        ]
      elsif msg.wParam==@options["cancelbutton"] then
        close false
      elsif msg.wParam==@options["browsebutton"] then
        if @editpath=openFilenameDialog([["Editor","*.exe"]]) then
          self.setItemTextOf(@options["target2"],@editpath.to_s)
        end
      end
    end
  end
  
  def bt_checked?(id)
    SendDlgItemMessage.call(self.hWnd,id,WMsg::BM_GETCHECK,0,0) == 1 ? true : false
  end
  
  def bt_check(id,v)
    SendDlgItemMessage.call(self.hWnd,id,WMsg::BM_SETCHECK,((v) ? 1 : 0),0)
  end

end

module EditDlgMsg
  include EditMsgConst
  def ed_getSel
    r = SendDlgItemMessage.call self.hWnd,@id,EM_GETSEL,0,0
    return LOWORD(r),HIWORD(r)
  end
  
  def ed_setSel(st,en,noscroll=0)
    SendDlgItemMessage.call self.hWnd,@id,EM_SETSEL,st,en
  end
  
  def ed_setCaret(r)
    ed_setSel(r,r)
  end
  
  def ed_replaceSel(newstr)
    SendDlgItemMessage2.call self.hWnd,@id,EM_REPLACESEL,0,newstr.to_s
  end
  
  def ed_text
    r = ""
    SendDlgItemMessage2.call self.hWnd,@id,WMsg::WM_GETTEXT,2,r
    r
  end

end

class ArrayEditDialog < VRModalDialog #for menu editor and toolbar editor
  include EditMsgConst
  include EditDlgMsg
  
  def initialize
    super
  end
  
  def msghandler(msg)
    case msg.msg
    when WMsg::WM_INITDIALOG
      setItemTextOf(@options["target"],@options["default"])
      @buff = @options["default"]
      @buff0 = @buff.dup
    when WMsg::WM_COMMAND
      if msg.wParam == @options["okbutton"] then
        close self.getItemTextOf(@options["target"])
      elsif msg.wParam==@options["cancelbutton"] then
        close false
      elsif HIWORD(msg.wParam) == EN_CHANGE  &&
                             LOWORD(msg.wParam) == @options["target"] then
        @id = @options["target"]
        ed_changed unless @supplaceMsg
        @supplaceMsg = nil
      end
    else
    end
  end
  
  def ed_changed
    @buff = self.getItemTextOf(@id)
    if @buff.size-@buff0.size == 1 then
      @supplaceMsg = true
      n=ed_getSel[0]
      case @buff[n-1]
      when '"'[0] 
        ed_replaceSel('"')
      when "'"[0]
        ed_replaceSel("\'")
      when '['[0]
        ed_replaceSel(']')
      end
      ed_setCaret n
    elsif @buff.size-@buff0.size == 2
      @supplaceMsg = true
      n=ed_getSel[0]
      case @buff[n-1]
      when 10
        astr =get_prev_line(n)
        @indent = 0
        @indent = astr[/^ */].size if astr
        s = " " * @indent
        if @buff[n-2] == 13 && @buff[n-3] == '['[0] && @buff[n] == ']'[0] then
          ed_replaceSel "#{s}  \r\n#{s}"
          n += 2 + @indent
        else
          ed_replaceSel(s); n += @indent
        end
      end
      ed_setCaret n
    end
    @buff0 = self.getItemTextOf(@id)
  end
  
  def get_prev_line(n)
    return if n == 0
    i0 = -1
    (n-3).downto(0){|i| if @buff[i] == 10 then i0 = i; break; end}
    if i0 < n-3 then @buff[i0+1..n-3] else nil end
  end
  
end

class ExamineModalDlg < VRModalDialog
  include VRStdControlContainer

  def vrinit
    super
    target = @options["target"]
  end

  def msghandler(msg)
    if msg.msg == WMsg::WM_INITDIALOG then
      self.setItemTextOf(@options["target"],@options["default"].to_s)
    end

    if msg.msg == WMsg::WM_COMMAND then
      if msg.wParam==@options["okbutton"] then
        close true
      elsif msg.wParam==@options["cancelbutton"] then
        close false
      end
    end
  end
end

class EDListview < VRListview
  class InplaceEdit < VREdit
    include VRKeyFeasible
    include VRFocusSensitive

    def self_char(ch,data)
      case ch
      when 13
        @parent.update
      end
    end
    
    def self_lostfocus
      @parent.update
    end
  end
  
  include VRParent
  include VRStdControlContainer
  include VRMouseFeasible
  attr :ed,1
  attr :fixfirstcolumn,1
    
  def construct
    @font= @screen.factory.newfont("ms gothic",14)
    self.setFont(@font)
    self.reportview
    addControl(InplaceEdit,'ed','')
    @ed.setFont(@font)
    @ed.hide
  end
  
  def hittest3(x,y)
    idx = hittest2(x,y)[3]
    w=0;left=0;cw=0
    subitem = 0.upto(countColumns-1){|i| 
      left=w 
      cw=getColumnWidthOf(i)
      break(i) if (w+=cw) > x 
    }
    l1,top,right,bottom = getItemRect(idx)
    [idx,subitem,left,top,cw,bottom-top]
  end
  
  def self_lbuttondown(shift,x,y)
    @ed.hide
    @idx,@subitem,left,top,width,height = *hittest3(x,y)
    selectItem(@idx,false)
    return if @fixfirstcolumn && @subitem==0
    @ed.move(left-1,top-1,width+2,height+2)
    @ed.text=getItemTextOf(@idx,@subitem)
    @ed.show
    @ed.focus
    refresh
  end
  
  def update    
    setItemTextOf(@idx,@subitem,@ed.text)
  end
  
end

class ItemEditDlg < VRModalDialog
  include VRComCtlContainer
  attr :position,1
  POS=[]
  ADDREMOVE=[] #enable add&remove
  FIXCOLUMN=[]
  TITLES=[]
  ITEMS=[]
  ADDINGNAME=[]
  UPDOWN=[]
  STYLES=[]
  LISTWIDTH=[392]
  def _itemEdit_init
    font = @screen.factory.newfont "Terminal",-13,0,0,0,0,0,1,128,100,0
    self.caption = 'ItemEditor'
    self.move(POS[0][0],POS[0][1],POS[0][2],POS[0][3])
    addControl(EDListview,'listView1','listView1',0,0,LISTWIDTH[0],240)
    addControl(VRButton,'btOk','O  K',224,246,80,24)
    addControl(VRButton,'btCan','Cansel',312,246,80,24)
    addControl(VRButton,'btAdd','Add',0,246,80,24) if ADDREMOVE[0]
    addControl(VRButton,'btRemove','Remove',88,246,80,24) if ADDREMOVE[0]
    addControl(VRUpdown,'updown1','updown1',180,246,24,24)
    addControl(VRRadiobutton,'radioBtn0',STYLES[0][0],260,32,160,24).setFont(font) if 
                                                                      STYLES[0]&&STYLES[0][0]
    addControl(VRRadiobutton,'radioBtn1',STYLES[0][1],260,56,160,24).setFont(font) if
                                                                      STYLES[0]&&STYLES[0][1]
    addControl(VRRadiobutton,'radioBtn2',STYLES[0][2],260,80,160,24).setFont(font) if
                                                                      STYLES[0]&&STYLES[0][2]
    addControl(VRRadiobutton,'radioBtn3',STYLES[0][3],260,104,160,24).setFont(font) if
                                                                       STYLES[0]&&STYLES[0][3]
    addControl(VRRadiobutton,'radioBtn4',STYLES[0][4],260,128,160,24).setFont(font)if 
                                                                       STYLES[0]&&STYLES[0][4]
    addControl(VRRadiobutton,'radioBtn5',STYLES[0][5],260,128,160,24).setFont(font)if
                                                                       STYLES[0]&&STYLES[0][5]
    @current_pos = 0
  end

  def construct
    _itemEdit_init
    @listView1.lvexstyle=ADDREMOVE[0]? 33 : 1
    @listView1.reportview
    TITLES[0].each{|i|
      @listView1.addColumn(i[0],i[1])
    }
    0.upto(ITEMS[0].size-1){|i|
      @listView1.addItem(ITEMS[0][i])
    }
    @listView1.fixfirstcolumn=FIXCOLUMN[0]
    @updown1.visible = UPDOWN[0]
    @updown1.setRange(0,ITEMS[0].size-1)
  end
  
  def btOk_clicked
    a=[]
    0.upto(@listView1.countItems-1){|i|
      a1=[]
      0.upto(@listView1.countColumns-1){|j|
        a1 << @listView1.getItemTextOf(i,j)
      }
      a << a1
    }
    @parent._return_val = a
    close 0
  end
  
  def btCan_clicked
    close 1
  end
  
  def btAdd_clicked
    if ADDINGNAME[0] == 'tab' then
      s = ADDINGNAME[0] + (@listView1.countItems+1).to_s
    else
      s = @parent.get_serial_name(ADDINGNAME[0]+'1')
    end
    @listView1.addItem(['',s])
    @listView1.setItemStateOf(@listView1.countItems-1,1)
    @listView1.selectItem(@listView1.countItems-1,true)
    @updown1.setRange(0,@listView1.countItems-1)
  end
  
  def btRemove_clicked
    @listView1.deleteItem(@listView1.focusedItem)
    @updown1.setRange(0,@listView1.countItems-1)
  end
  
  def listView1_itemchanged(idx,state)
    @current_pos=@listView1.countItems-1-idx
    @updown1.position=@current_pos
  end


  def updown1_changed(pos)
    return if pos == @current_pos
    @listView1.ed.hide
    s = []
    p0 = @listView1.countItems-@current_pos-1
    p1 = @listView1.countItems-pos-1
#    p ['current:',p0,' pos:',p1]
    0.upto(@listView1.countColumns-1){|i| s << @listView1.getItemTextOf(p0,i)}
    if p0 > p1
      @listView1.insertItem(p1,s)
      @listView1.deleteItem(p1+2)
      @listView1.selectItem(p1+1,false)
    else
      @listView1.insertItem(p1+1,s)
      @listView1.deleteItem(p1-1)
      @listView1.selectItem(p1-1,false)
    end
    @listView1.selectItem(p1,true)
    @listView1.setItemStateOf(p1,1)
  end

  def radioBtn0_clicked
    @listView1.setItemTextOf(@listView1.focusedItem,0,@radioBtn0.caption) if 
                                     @listView1.focusedItem > -1
  end
  
  def radioBtn1_clicked
    @listView1.setItemTextOf(@listView1.focusedItem,0,@radioBtn1.caption) if 
                                     @listView1.focusedItem > -1
  end
  
  def radioBtn2_clicked
    @listView1.setItemTextOf(@listView1.focusedItem,0,@radioBtn2.caption) if 
                                     @listView1.focusedItem > -1
  end
  
  def radioBtn3_clicked
    @listView1.setItemTextOf(@listView1.focusedItem,0,@radioBtn3.caption) if 
                                     @listView1.focusedItem > -1
  end
  
  def radioBtn4_clicked
    @listView1.setItemTextOf(@listView1.focusedItem,0,@radioBtn4.caption) if 
                                     @listView1.focusedItem > -1
  end
  
  def radioBtn5_clicked
    @listView1.setItemTextOf(@listView1.focusedItem,0,@radioBtn5.caption) if 
                                     @listView1.focusedItem > -1
  end
  
end

class MenuAnalizer
  attr :colCount
  def maxCol(n)
    @colCount = n if n > colCount
  end
  
  def __analize(ar)
    ar.each{|i|
      if i[1].is_a? Array then
        a = [[""]*@n,i[0].gsub(/\t/,'\t')].flatten
        @ar << a
        @colCount = a.size if a.size > @colCount
        @n += 1
        __analize(i[1])
      else
        a = [[""]*@n,i].flatten.select{|i| i .is_a? String}.collect{|i| i.gsub /\t/,'\t'}
        @colCount = a.size if a.size > @colCount
        @ar << a
      end
    }
    @n -= 1
  end
  
  def analize(ar)
    @ar=[]
    @n = 0
    @colCount=0
    __analize(ar)
    @ar
  end
  
  def __unanalize(s,level=0)
    r = []
    i = 0
    while(i < s.size) do
      l0 = 0
      data=[]
      flag0=nil
      s[i].each{|j|
        if j=="" then
          unless flag0 then l0 += 1 else break end
        else
          data << j.sub(/\\t/,"\t") if j
          flag0 = true
        end
      }
      case l0 <=> level
      when -1
        return r,i-1
      when 0
        if data == ["sep","_vrmenusep"] then 
          r << ["sep","_vrmenusep",2048]
        else
          r << data
        end
      when 1
        a = __unanalize(s[i,s.size-i],l0)
        r.last << a[0]
        i += a[1]
      end
      i += 1
    end #while
    [r,i]
  end
  
  def unanalize(ar)
    __unanalize(ar,0)[0]
  end
  
end

class Bt_UP < VROwnerDrawButton
  
  def drawpushed(left,top,right,bottom,state)
    rect=[left,top,right,bottom].pack("iiii")
    DrawFrameControl.call(hdc,rect,4,0x210)
    drawBitmap(OwnerDrawBtnBmp::BmpUP,5,5)
  end
  
  def drawreleased(left,top,right,bottom,state)
    rect=[left,top,right,bottom].pack("iiii")
    DrawFrameControl.call(hdc,rect,4,0x10)
    drawBitmap(OwnerDrawBtnBmp::BmpUP,4,4)
  end
  
end

class Bt_DN < VROwnerDrawButton
    def drawpushed(left,top,right,bottom,state)
      rect=[left,top,right,bottom].pack("iiii")
      DrawFrameControl.call(hdc,rect,4,0x210)
      drawBitmap(OwnerDrawBtnBmp::BmpDN,5,5)
    end
    
    def drawreleased(left,top,right,bottom,state)
      rect=[left,top,right,bottom].pack("iiii")
      DrawFrameControl.call(hdc,rect,4,0x10)
      drawBitmap(OwnerDrawBtnBmp::BmpDN,4,4)
    end
end

class MnEDListview < EDListview
  attr :level
  attr :items
  attr :ed
  def getItemsAttr(idx)
    items = []
    level = 0
    flag0 = nil
    0.upto(countColumns-1){|i|
      if s=getItemTextOf(idx,i) == "" then
        break if flag0
        level += 1
      else
        items << getItemTextOf(idx,i)
        flag0 = true
      end
    }
    [items,level]
  end
  
  def self_lbuttondown(shift,x,y)
    @items = []
    @level=0
    flag0 = nil
    @ed.hide
    @idx,@subitem,left,top,width,height = *hittest3(x,y)
    @items,@level=getItemsAttr(@idx)
=begin
    0.upto(countColumns-1){|i|
      if s=getItemTextOf(@idx,i) == "" then
        break if flag0
        @level += 1
      else
        @items << getItemTextOf(@idx,i)
        flag0 = true
      end
    }
=end
    if @items.size > 1 then
      0.upto(countColumns-1){|i|
        if i == @level then 
          s = 'Item Caption' 
        elsif i == @level+1
          s = 'Item Event' 
        else s = '' end
        setColumnTextOf(i,s)
      }
    else
      0.upto(countColumns-1){|i|
        if i == @level then s = 'Menu Caption' else s = '' end
        setColumnTextOf(i,s)
      }
    end
    return if @subitem < @level or @subitem >= @level + @items.size 
    selectItem(@idx,false)
    return if @fixfirstcolumn && @subitem==0
    @ed.move(left-1,top-1,width+2,height+2)
    @ed.text=getItemTextOf(@idx,@subitem)
    @ed.show
    @ed.focus
    refresh
  end
end

class MenuEditDlg < VRModalDialog
  include VRComCtlContainer
  include VROwnerDrawControlContainer
  attr :position,1
  POS=[[100,100,464,250]]
  FIXCOLUMN=[]
  TITLES=[]
  ITEMS=[]
  ADDINGNAME=[]
  UPDOWN=[]
  STYLES=[]
  LISTWIDTH=[460]
  def _itemEdit_init
    font = @screen.factory.newfont "Terminal",-13,0,0,0,0,0,1,128,100,0
    self.caption = 'ItemEditor'
    self.move(POS[0][0],POS[0][1],POS[0][2],POS[0][3])
    addControl(MnEDListview,'listView1','listView1',0,0,LISTWIDTH[0],240)
    addControl(VRButton,'btAddMnu','AddMnu',0,246,64,24)
    addControl(VRButton,'btAddItm','AddItm',68,246,64,24)
    addControl(VRButton,'btAddSep','AddSep',136,246,64,24)
    addControl(VRButton,'btRemove','Remove',204,246,64,24)
    addControl(Bt_UP,'btUP','',272,246,24,24)
    btDN=addControl(Bt_DN,'btDN','',298,246,24,24)
    addControl(VRButton,'btOk','O  K',326,246,64,24)
    addControl(VRButton,'btCan','Cansel',394,246,64,24)
    @current_pos = 0
  end

  def construct
    _itemEdit_init
    @listView1.lvexstyle=33
    @listView1.reportview
    TITLES[0].each{|i|
      @listView1.addColumn(i[0],i[1])
    }
    0.upto(ITEMS[0].size-1){|i|
      @listView1.addItem(ITEMS[0][i])
    }
    @listView1.fixfirstcolumn=FIXCOLUMN[0]
  end

  def btOk_clicked
    a=[]
    0.upto(@listView1.countItems-1){|i|
      a1=[]
      0.upto(@listView1.countColumns-1){|j|
        a1 << @listView1.getItemTextOf(i,j)
      }
      a << a1
    }
    @parent._return_val = a
    close 0
  end
  
  def btCan_clicked
    close 1
  end
  
  def find_next(pos)
    n = 0
    pos.upto(@listView1.countItems){|i|
      n = i
      return nil if @listView1.level>0 && @listView1.getItemTextOf(i,@listView1.level-1)!=""
      break if @listView1.getItemTextOf(i,@listView1.level) != "" 
    }
    n = nil if n == @listView1.countItems
    n
  end
  
  def find_prev(pos)
    n = 0
    pos.downto(0){|i|
      n = i
      break if @listView1.getItemTextOf(i,@listView1.level) != "" 
    }
    n
  end
  
  def btAddMnu_clicked
    @listView1.ed.hide
    if @listView1.items.size == 1 then
      n=find_next(@listView1.focusedItem+1)
      @listView1.insertItem(n,['']*(@listView1.level)+['Menu'])
    else
      @listView1.insertItem(@listView1.focusedItem+1,['']*(@listView1.level)+['Menu'])
    end  if @listView1.items
  end
  
  def btAddItm_clicked
    @listView1.ed.hide
    if @listView1.items.size == 1 then
      if @listView1.countColumns < @listView1.level+@listView1.items.size+2 then
        @listView1.insertColumn(@listView1.countColumns,'',112) 
      end
      @listView1.insertItem(@listView1.focusedItem+1,
                                            ['']*(@listView1.level+1)+['item','event'])
    else
      @listView1.insertItem(@listView1.focusedItem+1,
                                              ['']*(@listView1.level)+['item','event'])
    end  if @listView1.items
  end

  def btAddSep_clicked
    @listView1.ed.hide
    if @listView1.items.size == 1 then
      if @listView1.countColumns < @listView1.level+@listView1.items.size+2 then
        @listView1.insertColumn(@listView1.countColumns,'',112) 
      end
      @listView1.insertItem(@listView1.focusedItem+1,
                                            ['']*(@listView1.level+1)+['sep','_vrmenusep'])
    else
      @listView1.insertItem(@listView1.focusedItem+1,
                                              ['']*(@listView1.level)+['sep','_vrmenusep'])
    end  if @listView1.items
  end
  
  def btRemove_clicked
    @listView1.ed.hide
    if @listView1.items.size == 1 then
      nf=@listView1.focusedItem
      n=find_next(nf+1)
      @listView1.focusedItem.upto(n-1){|i|
        @listView1.deleteItem(nf)
      }
    else
      @listView1.deleteItem(@listView1.focusedItem)
    end  if @listView1.items
  end
  
  def btUP_clicked
    @listView1.ed.hide
    nf=@listView1.focusedItem
    if @listView1.items.size == 1 then
      n0=find_prev(nf-1)
      n1=find_next(nf+1)
      a = []
      (nf-1).downto(n0){|i|
        a = []
        0.upto(@listView1.countColumns-1){|j| a << @listView1.getItemTextOf(i,j)}
        @listView1.insertItem(n1,a)
      }
      (nf-1).downto(n0){|i|
        @listView1.deleteItem(n0)
      }
    else
      as = []
      a0 = []
      0.upto(@listView1.countColumns-1){|i|as << @listView1.getItemTextOf(nf,i)}
      0.upto(@listView1.countColumns-1){|i|if s=@listView1.getItemTextOf(nf-1,i) != ''  then 
      a0 << s end}
      return if a0.size <= 1
      @listView1.insertItem(nf-1,as)
      @listView1.deleteItem(nf+1)
      @listView1.selectItem(nf-1,true)
      @listView1.setItemStateOf(nf-1,1)
    end  if @listView1.items
  end
  
  def btDN_clicked
    @listView1.ed.hide
    nf=@listView1.focusedItem
    if @listView1.items.size == 1 then
      n1=find_next(nf+1)
      return unless n1
      if @listView1.getItemTextOf(n1,@listView1.level+1) != "" then #same level item
        n2 = n1+1
      elsif @listView1.level==0 || @listView1.getItemTextOf(n1,@listView1.level-1) == "" 
        n2=find_next(n1+1)  # same level menu
      else #higher level item
        return
      end
      (n1-1).downto(nf){|i|
        a = []
        0.upto(@listView1.countColumns-1){|j| a << @listView1.getItemTextOf(i,j)}
        @listView1.insertItem(n2,a)
      }
      (n1-1).downto(nf){|i|
        @listView1.deleteItem(nf)
      }
    else
      as = []
      a0 = []
      0.upto(@listView1.countColumns-1){|i|as << @listView1.getItemTextOf(nf,i)}
      0.upto(@listView1.countColumns-1){|i|if s=@listView1.getItemTextOf(nf+1,i) != '' then
                                           a0 << s end}
      a0,l0=@listView1.getItemsAttr(nf+1)
      if a0.size == 1 && @listView1.level == l0
        n2=find_next(nf+2)
        return unless n2
      elsif a0.size == 1
        n2 = nf + 2
      end
      @listView1.insertItem(n2,as)
      @listView1.deleteItem(nf)
      @listView1.selectItem(nf+1,true)
      @listView1.setItemStateOf(nf+1,1)
    end if @listView1.items
  end
  
  def listView1_itemchanged(idx,state)
    @current_pos=@listView1.countItems-1-idx
  end

end
