# m17n.rb
# Multilingualization Module
#
# Programmed by yukimi_sake@mbi.nifty.com
# Copyright 2001-2004 Yukio Sakaue

require 'vr/vrcontrol'
require 'vr/vrcomctl'

module EN
  
  HTML_Help=File.dirname(__FILE__).gsub(/\//,'\\')+'\doc\vrswin-en.chm'
  module FDItems
    FDMenuTemplate=
    [
      ["&File",   [ ["&New\tCtrl+N","new"],
                    ["&Open","open"],
                    ["&Save","save"],
                    ["Save&As","saveas"],
                    VRMenu::SEPARATOR,
                    ["E&xit","exit"]]],
      ["&Edit",   [ ["&Delete","doDelete"],
                    ["Cu&t","cut"],
                    ["&Copy","copy"],
                    ["&Paste","paste"]]],
      ["&Help",   [ ["Versio&n","version"]]]
    ]
    FDPopupMenuTemplate=[["&Delete\tDelete","doDelete"],VRMenu::SEPARATOR,
                  ["&Copy\tCtrl+C","doCopy"],["&Paste\tCtrl+V","doPaste"]]
    FDToolbarTemplate =
       [['toolButton1'],
        ['toolButton2',WConst::TBSTYLE_SEP],
        ['toolButton3',WConst::TBSTYLE_CHECKGROUP],
        ['toolButton4',WConst::TBSTYLE_CHECKGROUP],
        ['toolButton5',WConst::TBSTYLE_CHECKGROUP]]
  
    FDDlgFilterTemplate=[["all(*.*)","*.*"]]

  end

  module FDMenuItems
    FDMainmenu=[
    ["&File",   [ ["&NewForm\tCtrl+N",
                    [ ["Form","new_form"],
                      ["ModelessForm","new_modeless_form"],
                      ["ModelessDialog","new_modeless_dlg"]]],
                    ["&Open\tCtrl+O","open"],
                    ["OpenWith&RDE\tCtrl+R","open_rde"],
                    ["ChangeMainformType",
                      [ ["Form","change_to_mainform"],
                        ["ModelessForm","change_to_modeless_mainform"],
                        ["ModelessDialog","change_to_modeless_maindlg"]]],
                    ["&Save\tCtrl+S","save"],
                    ["Save&As",
                      [ ["FormsOnly","saveas_form"],
                        ["ProjectWithSeparated Forms","saveas_proj_part"],
                        ["ProjectWithBuiltForms","saveas_proj_mono"]]],
                    VRMenu::SEPARATOR,
                    ["&EditProject\tCtrl+E","run_editor"],
                    ["Update&Project","update_proj"],
                    VRMenu::SEPARATOR,
                    ["E&xit\tAlt+F4","exit"]]],
      ["&Insert", [ ["Form","insert_form"],
                    ["Mode&lessForm","insert_modelessform"],
                    ["&ModalForm","insert_modalform"],
                    ["ChangeFormType",
                      [ ["Form","change_to_form"],
                        ["ModelessForm","change_to_modeless_form"],
                        ["ModalForm","change_to_modal_form"]]],
                    VRMenu::SEPARATOR,
                    ["ReadFromFile","insert_form_from_file"],
                    ["SaveThisForm","save_this_form"],
                    VRMenu::SEPARATOR,
                    ["&DeleteThisForm","delete_this_form"]]],
      ["&Edit",   [ ["&Delete\tDelete","doDelete"],
                    VRMenu::SEPARATOR,
                    ["Cu&t\tCtrl+X","doCut"],
                    ["&Copy\tCtrl+C","doCopy"],
                    ["&Paste\tCtrl+V","doPaste"],
                    VRMenu::SEPARATOR,
                    ["&BackToParent\tHome","back_to_parent"]]],
      ["&Window", [  VRMenu::SEPARATOR,
                    ["&Inspect","inspectShow",VRMenuItem::CHECKED]]],
      ["&Run",    [ ["E&xecute\tF5","execute"],
                    ["Examine","examine"]]],
      ["&Option", [ ["&Preferences","prefer"],
                    VRMenu::SEPARATOR,
                    ["Grid","gridState",VRMenuItem::CHECKED]]],
      ["&Tool",   [ ["Bmp2Str","bmp2str"]]],
      ["&Help",   [ ["&Show topic\tF1","show_topic"],
                    ["&Show SDKtopic\tF2","show_SDK_topic"],
                    ["Versio&n","version"]]]
    ]
  
    FDPopupmenu=[ ["&Delete\tDelete","doDeletepop"],
                  VRMenu::SEPARATOR,
                  ["Cu&t\tCtrl+X","doCutpop"],
                  ["&Copy\tCtrl+C","doCopypop"],
                  ["&Paste\tCtrl+V","doPastepop"],
                  VRMenu::SEPARATOR,
                  ["&BackToParent\tHome","back_to_parentpop"]]
  end
  
  module FDMsgItems
    Sorry="Sorry just moment"
    NoChosen = "Nothing is chosen."
    NoFileError=["#{ARGV[0]} is not exist","No file error",16]
    OptionError=["too many arguments","Option error" ,16]
    DoYouSave="Do you save this file?"
    OpenPreare="Open file"
    FileNotExist=[" is not exist","File not exist",16]
    FileWasModified=["This working file was modifyed by other apprication."+
    "\r\nDo you read new file?","Working file was modifyed" ,0x0003]
    SaveBeforeEdit=["Please save befor editing","This is new project",0x30]
    SaveFromEditor=["Have you saved Project from Editor?",
    "Updating Project ",0x31]
    ThisIsMain=["This is Main Form.", "Cannot Change",16]
    OerationCannotUndo=["This operation cannot UNDO.\r\n\r\nDo you delete anyway?",
    "Delete this form",0x34]
    GridMustBe=["Grid span must be in 2 to 100" ,"Warning!!",16]
    Base64Finish="Base64 string was copied into clipboard"
    SaveBrforeExit=["Do you save this file?","Exit FormDesigner",0x1023]
    InDDEmode=["Here is in DDE mode. Do you exit realy?","Exit FormDesigner",0x1034]
    Modified="Modified"
    Saved=" was saved."
    Noform=["There is none to raed or old file","Read form from file",16]
    NoPaste=["Cannot paste to this parent","Invalid parent",16]
    DialogRunning=[" dialog is running. ","Running dialog",0x30]
  end
  
  module FDPrfItems
    Preferences="Preferences"
    CROnly="CR Only"
    CgwinLS="Cygwin's line separator"
    Gridsize="Glid Size"
    DockInspect='Dock inspect window'
    Editor="Editor"
    UseJp='Use Japanese'
    Font="Font"
    NextStart='(Enable next starting)'
    Verbose='Output comments of caution'
    OK="O   K"
    Cancel="Cancel"
  end
  
  module FDNewProjectItem
    NewProject=" is new project"
    Prompt="Please select type which you'd like"
  end
  
  module FDProjectTypes
    Apart="project with separated forms"
    Form="forms only"
    Mono="project with built forms"
  end
end

module JA
  HTML_Help=File.dirname(__FILE__).gsub(/\//,'\\')+'\doc\vrswin-ja.chm'
  module FDItems
    FDMenuTemplate=
      [
        ["t@C(&F)",   [
                    ["VK쐬(&N)\tCtrl+N","new"],
                    ["J(&O)","open"],
                    ["ۑ(&S)","save"],
                    ["Otĕۑ(&A)","saveas"],
                    VRMenu::SEPARATOR,
                    ["I(&X)","exit"]]],
        ["ҏW(&E)",   [ ["폜(&D)","doDelete"],
                    ["Jbg(&T)","cut"],
                    ["Rs[(&C)","copy"],
                    ["\t(&P)","paste"]]],
        ["wv(&H)",   [ ["o[W","version"]]]
      ]
    FDPopupMenuTemplate=[["폜(&D)\tDelete","doDelete"],VRMenu::SEPARATOR,
                  ["Rs[(&C)\tCtrl+C","doCopy"],["\t(&P)\tCtrl+V","doPaste"]]
    FDToolbarTemplate =
       [['toolButton1'],
        ['toolButton2',WConst::TBSTYLE_SEP],
        ['toolButton3',WConst::TBSTYLE_CHECKGROUP],
        ['toolButton4',WConst::TBSTYLE_CHECKGROUP],
        ['toolButton5',WConst::TBSTYLE_CHECKGROUP]]
  
    FDDlgFilterTemplate=[["S(*.*)","*.*"]]

  end

  module FDMenuItems
    FDMainmenu=[
      ["t@C(&F)",[
                    ["VKtH[",
                      [ ["tH[","new_form"],
                        ["[hXtH[","new_modeless_form"],
                        ["[hX_CAO","new_modeless_dlg"]]],
                    ["J(&O)\tCtrl+O","open"],
                    ["RDEŊJ(&R)\tCtrl+R","open_rde"],
                    ["CtH[ʂύX",
                      [ ["tH[","change_to_mainform"],
                        ["[hXtH[","change_to_modeless_mainform"],
                        ["[hX_CAO","change_to_modeless_maindlg"]]],
                    ["㏑ۑ(&S)\tCtrl+S","save"],
                    ["Otĕۑ(&A)",
                      [ ["tH[","saveas_form"],
                        ["tH[^vWFNg","saveas_proj_part"],
                        ["tH[^vWFNg","saveas_proj_mono"]]],
                    VRMenu::SEPARATOR,
                    ["(&E)vWFNgҏW\tCtrl+E","run_editor"],
                    ["(&U)vWFNgAbvf[g\tCtrl+U","update_proj"],
                    VRMenu::SEPARATOR,
                    ["I(&X)\tAlt+F4","exit"]]],
      ["}(&I)",   [
                       ["tH[","insert_form"],
                       ["[hXtH[","insert_modelessform"],
                       ["[_tH[","insert_modalform"],
                       ["tH[ʂύX",
                         [ ["tH[","change_to_form"],
                           ["[hXtH[","change_to_modeless_form"],
                           ["[_tH[","change_to_modal_form"]]],
                       VRMenu::SEPARATOR,
                       ["t@C","insert_form_from_file"],
                       ["̃tH[ۑ","save_this_form"],
                       VRMenu::SEPARATOR,
                       ["̃tH[폜","delete_this_form"],
                     ]],
      ["ҏW(&E)",   [ ["폜(&D)\tDelete","doDelete"],
                    VRMenu::SEPARATOR,
                    ["Jbg(&T)\tCtrl+X","doCut"],
                    ["Rs[(&C)\tCtrl+C","doCopy"],
                    ["\t(&P)\tCtrl+V","doPaste"],
                    VRMenu::SEPARATOR,
                    ["eEChEֈړ(&B)\tHome","back_to_parent"]]],
      ["EChE(&W)", [
                    VRMenu::SEPARATOR,
                    ["&Inspect","inspectShow",VRMenuItem::CHECKED]]],
      ["s(&R)",    [ ["s(&X)\tF5","execute"],
                    ["R[h\","examine"]]],
      ["IvV(&O)", [ ["ݒ(&P)","prefer"],
                    VRMenu::SEPARATOR,
                    ["Obh","gridState",VRMenuItem::CHECKED]]],
      ["c[(&T)",   [ ["Bmp2Str","bmp2str"]]],
      ["wv(&H)",   [ ["gsbN̕\\tF1","show_topic"],
                         ["SDKgsbN̕\\tF2","show_SDK_topic"],
                         ["o[W(&N)","version"]]]]
  
    FDPopupmenu=[ ["폜(&D)\tDelete","doDeletepop"],
                  VRMenu::SEPARATOR,
                  ["Jbg(&X)\tCtrl+X","doCutpop"],
                  ["Rs[(&C)\tCtrl+C","doCopypop"],
                  ["\t(&P)\tCtrl+V","doPastepop"],
                  VRMenu::SEPARATOR,
                  ["eEChEֈړ(&B)\tHome","back_to_parentpop"]]
  end
  
  module FDMsgItems
    Sorry="Ƒ҂Ă"
    NoChosen = "I"
    NoFileError=["#{ARGV[0]} ݂͑܂","t@C܂",16]
    OptionError=["܂","IvVG[" ,16]
    DoYouSave="̃t@Cۑ܂H"
    OpenPreare="t@CJ"
    FileNotExist=[" ݂܂","t@C݂܂",16]
    FileWasModified=["̍ƃt@C͑̃AvP[Vɂď܂B"+
    "\r\nVt@Cǂݍ݂܂H","ƃt@CύX܂" ,0x0003]
    SaveBeforeEdit=["ҏW̑OɃvWFNgۑĂ","VKvWFNg",0x30]
    SaveFromEditor=["GfB^vWFNgۑ܂H",
    "vWFNgAbvf[g",0x31]
    ThisIsMain=["CtH[͍폜ł܂.", "폜s",16]
    OerationCannotUndo=["AhDł܂񂪁A{ɍ폜܂H",
    "̃tH[폜",0x34]
    GridMustBe=["Obh 2  100܂ł̐łȂ΂Ȃ܂" ,"x!!",16]
    Base64Finish="Base64 񂪃Nbv{[hɕۑ܂"
    SaveBrforeExit=["t@Cۑ܂H","FormDesigneȑI",0x1023]
    InDDEmode=["DDE[hłB{ɏI܂H","FormDesigneȑI",0x1034]
    Modified="ύX"
    Saved=" ۑς"
    Noform=["ǂ߂tH[AÂt@Cł","t@C}",16]
    NoPaste=["̐eEChEɓ\t邱Ƃ͏o܂","ȐeEChE",16]
    DialogRunning=[" _CAOsł","_CAOs",0x30]
  end
  
  module FDPrfItems
    Preferences="ݒ"
    CROnly="CR ̂"
    CgwinLS="Cygwinł̉sL"
    Gridsize="Obh"
    DockInspect='CXyNgEChEhbN'
    Editor="GfB^"
    UseJp='{gp'
    Font="tHg"
    NextStart='(̋NŗL)'
    Verbose='xRgo'
    OK="O   K"
    Cancel="LZ"
  end
  
  module FDNewProjectItem
    NewProject=" ͐VKvWFNgł"
    Prompt="ꂩ̃^CvIĂ"
  end
    
  module FDProjectTypes
    Apart="tH[^vWFNg"
    Form="tH["
    Mono="tH[^vWFNg"
  end
end

if $Lang=="JA"
  include JA
else
  include EN
end

