# fdcfg.rb
# Configuration File of FormDesigner for Visualu Ruby 
#
# Programmed by yukimi_sake@mbi.nifty.com
# Copyright 2001-2008 Yukio Sakaue

require 'fdvr/fdcontrols'
require 'fdvr/fddialogs'
=begin
module VRParent
  def parentinit(screen)
    @screen=screen
    @controls=OHash.new
    @_vr_cid=0
  end
end
=end
class VRControl
  def setFont(font,redraw=true)
    if self.dopaint then
      super font
    end
    if font.is_a?(SWin::Font) then
      self.properties["font"]=font
      sendMessage WMsg::WM_SETFONT,font.hfont, ( (redraw)? 1 : 0 )
    elsif !font
      sendMessage WMsg::WM_SETFONT,0,1
      self.properties["font"]=nil
    else
      raise "#{font} is not a font."
    end
  end
end

class VRLayoutFrame  
  def reset_registerd
    @_vr_layoutclients.each do|i|
      if i.is_a? SWin::Window
        i.setMargin(nil,nil,nil,nil)
      elsif i
        i.reset_registerd
      end
      i.registerd_to.clear
    end
  end
end

class VRTwoPaneFrame
  module VRTwoPaneFrameUsable
    def self_vrsepl2buttondown(s,x,y)
      @_vr_twopaneframes.each do |f|
        if f.hittest(x,y)
          f.setDragCur
          f.dragstart 
          @_vr_current_tpframe=f
          @_fd_dragging=true
        end
      end
    end

    def self_vrsepl2dragend
      @_vr_current_tpframe=nil
      @_vr_twopaneframes.each do |f|
        f.dragend
        @_fd_dragging=false
      end
      refresh
    end
  end
  
  def reset_registerd
    if @pane1.is_a? Array
      @pane1.each do|i|
        if i.is_a? SWin::Window
          i.setMargin(nil,nil,nil,nil)
          i.registerd_to.clear
        else
          i.reset_registerd
          i.container.registerd_to.clear
        end
      end
    elsif @pane1
      if @pane1.is_a? SWin::Window
        @pane1.setMargin(nilnilnilnil)
        @pane1.registerd_to.clear
      else
        @pane1.reset_registerd
        @pane1.container.registerd_to.clear
      end
    end
    if @pane2.is_a? Array
      @pane2.each do|i|
        if i.is_a? SWin::Window
          i.setMargin(nil,nil,nil,nil)
          i.registerd_to.clear
        else
          i.reset_registerd
          i.container.registerd_to.clear
        end
      end
    elsif @pane2
      if @pane2.is_a? SWin::Window
        @pane2.setMargin(nilnilnilnil)
        @pane2.registerd_to.clear
      else
        @pane2.reset_registerd
        @pane2.container.registerd_to.clear
      end
    end
  end
end

module VRMarginedFrameUseable
  module VRMgdLayoutFrame
    def register(*ctls)
      @_vr_layoutclients.concat(ctls.flatten.map{|i|
        unless  $subwnd
          i.registerd_to = [self.container,0]
          unless i.is_a?(FDContainer)
            i.margined = true
            i.extend(VRMargin).initMargin(0,0,0,0)
            i
          else
            i.substance
          end
        else
          i.extend(VRMargin).initMargin(0,0,0,0) unless i.is_a?(FDContainer)
        end
      })
      _vr_relayout
    end
  end

  class VRMgdGridLayoutFrame
    def register(*ctls)
      if ctls[0].is_a? Array
        ctls.each do|i|
          unless $subwnd
            i[0].margined = true
            i[0].registerd_to = [self.container,0]
          end
          i[0].extend(VRMargin).initMargin(0,0,0,0) unless
                                                         i[0].is_a?(FDContainer)
          super(*i)
        end
      else
        unless $subwnd
          ctls[0].margined = true
          ctls[0].registerd_to = [self.container,0]
        end
        ctls[0].extend(VRMargin).initMargin(0,0,0,0) unless
                                                      ctls[0].is_a?(FDContainer)
        super
      end
    end
    
    def xsize=(xs) @_vr_xsize = xs end
    def ysize=(ys) @_vr_ysize = ys end
    def xsize() @_vr_xsize end
    def ysize() @_vr_ysize end
  end
  
  Curs = SWin::Application::SysCursors
  
  class VRMgdVertTwoPaneFrame
    alias :_vr_draw_bevel_org :_vr_draw_bevel
    alias :_vr_relayout_org :_vr_relayout
    
    def _vr_relayout
      _vr_relayout_org
      unless $designfrm.coverfrm.opend_holes[self]
        $designfrm.coverfrm.open_hole(self,
              @_vr_lxs, @_vr_lys, @_vr_lxe, @_vr_lye, Curs.SizeNS, window_parent)
      end
      $designfrm.coverfrm.move_hole(self, @_vr_lxs, @_vr_lys, @_vr_lxe, @_vr_lye)
    end
    
    def _vr_draw_bevel(win)
      _vr_draw_bevel_org(win) if $subwnd || !@container.registerd_to.empty? ||
          (window_parent.__regsterd_vr_margined_frame == self)
    end
  end
  
  class VRMgdHorizTwoPaneFrame
    alias :_vr_draw_bevel_org :_vr_draw_bevel
    alias :_vr_relayout_org :_vr_relayout
    
    def _vr_relayout
      _vr_relayout_org
      unless $designfrm.coverfrm.opend_holes[self]
        $designfrm.coverfrm.open_hole(self,
              @_vr_lxs, @_vr_lys, @_vr_lxe, @_vr_lye, Curs.SizeWE, window_parent)
      end
      $designfrm.coverfrm.move_hole(self, @_vr_lxs, @_vr_lys, @_vr_lxe, @_vr_lye)
    end
    
    def _vr_draw_bevel(win)
      _vr_draw_bevel_org(win) if  $subwnd || !@container.registerd_to.empty? ||
          (window_parent.__regsterd_vr_margined_frame == self)
    end
  end
end

module ExecuteDesignfrm
  include VRDestroySensitive
#  include VRMouseFeasible
  
  def vrinit
    super
    $subwnd = self
  end
  def self_destroy
    $main.exitExec if $main.alive?
    $subwnd = nil
  end
end

class Array
  def format
    r = "[\n"
    self.each{|i|
      if i == self.last
        r += "  " + i.inspect + "\n"
      else
        r += "  " + i.inspect + ",\n"
      end
    }
    r += "]\n"
  end
end

class Integer
  def to_x
    sprintf "%#x", self
  end
end

class String
  def esc
    self.gsub /\"/,'\"'
  end
end

class MenuStrMaker
  def _analize(ar,mn=nil)
    @ar += "  "*@n + "[\"#{mn}\",[\n" if mn
    ar.each{|i|
      if i[1].is_a? Array then
        @n += 1
        _analize(i[1],i[0])
        @ar[@ar.size-1,0]=','
      else
        @ar += "  "*(@n+1) + i.inspect + ",\n"
      end
    }
    @ar[@ar.size-2,1]="]"
    @ar += "  "*@n + "]\n"
    @n -= 1
  end
  
  def makeStr(ar)
    @ar="[\n"
    @n = 0
    _analize(ar)
    @ar[@ar.size-4,1]=''
    @ar
  end
end

class OHash < Hash
  attr_reader :order
  def self.[](*arg)
    obj = self.new
    (arg.flatten!.size/2).times{|i| obj[arg[i*2]] = arg[i*2+1]}
    obj
  end
  
  def initialize() @order = []; super; end
  
  def []=(key,value) @order << key unless @order.index(key); super; end
  
  def delete(key) @order.delete(key); super; end
  
  def each() @order.each{|k| yield(k, self[k])}; end
  
  alias each_paire each
  
  def each_key() @order.each{|k| yield(k)}; end
  
  def update(other) super(other); @order.concat(other.order).uniq!; self; end 
  
  alias merge! update
  
  def keys() @order; end
  
  def values() @order.map{|k| self[k]}; end
  
  def to_a() @order.map{|k| [k,self[k]]}; end
  
  def find() r = super ; r = [r, self[r]] unless r.is_a?(Array); r; end
  
  def dup()
    r = super
    r.class.module_eval("attr_accessor :order")
    r.order=@order.dup
    r.class.module_eval("attr_reader :order")
    r
  end
end

module FDCommonMethod
  attr_reader :controls
  
=begin  
  def vrinit
    super
    @controls = OHash.new ; p [self,@controls]
  end
=end
  def setcontrols(contorls)
    @controls = contorls
  end
    
  def  use_parent_of?(obj)
    obj.is_a?(FDContainer) || !obj.respond_to?(:addControl)
  end

  def getFormPos(c, quad = nil, client = nil)
    return [0,0] unless c
    x0, y0, w0, h0 = *c.windowrect
    pos = [x0,y0].pack('ll')
    client = c.parent unless client
    User32::ScreenToClient.call(client.hWnd, pos)
    x1, y1 = pos.unpack('ll')
#    p;p [:fdcfg259,c,client,[x0, y0], [x1, y1]]
    quad ? [x1, y1, w0, h0] : [x1, y1]
  end
  module_function :getFormPos
  
  def checkfocus(x,y)
    px, py, pw, ph = 0, 0, 0x100000000, 0x100000000
    r = nil
    @controls.each { |i,c|
      unless c.is_a?(VRToolbar::VRToolbarButton) ||
              (c.respond_to?(:ignore_formdesigner) && c.ignore_formdesigner) ||
              !c.visible?
        cx, cy, cw, ch = *getFormPos(c, true)
        if (cx < x) && (cx + cw > x) && (cy < y ) && (cy + ch > y)
          if px < cx || py < cy || pw > cw || ph > ch
            px, py, pw, ph = cx, cy, cw, ch
            r=c
            if c && c.respond_to?(:addControl) && c.visible?
              r1 = c.checkfocus(x-cx,y-cy)
              r=r1 if r1
            end
          end
        end
      end
    }
    r
  end

  def findCtrl(s)
    c=nil
    @controls.each { |id,item|
      unless use_parent_of?(item)
       return c if c = item.findCtrl( s )
      end
      return item if item.name == s
    }
    c
  end

end


# module WMsg
#   RB_IDTOINDEX = WM_USER + 16
# end

module CreateCtrl
  include FDControls

  attr_reader :cmodules, :cinfo, :_vr_menu, :_hsh_font, :required, :modules

  Stylehash = {
      "TBSTYLE_BUTTON"        => 0,
      "TBSTYLE_SEP"           => 1,
      "TBSTYLE_CHECK"         => 2,
      "TBSTYLE_GROUP"         => 4,
      "TBSTYLE_CHECKGROUP"    => 6
    }
  Indent_Str = '  '
  
  module FDControlExt
    include VRMessageHandler
    attr_reader :__org_x,:__org_y,:__org_w,:__org_h
    attr_accessor :form , :oldname, :items , :modules, :owndraw,
                  :registerd_to, :margined, :_default_style, :_maskstyle,
                  :attributes
    def self.extended(c)
      c.class.module_eval <<-EEOOSS
      def self.instance() @@instance end
      def self.instance=(i) @@instance = i end
      EEOOSS
      c._ext_init
    end
    
    def _ext_init()
      @modules = []; @owndraw = 0; @taborder = -1; @form = @parent.form;
      @oldname = @name ;@registerd_to = [] ;@margined = nil
      @_default_style = 0; @_addstyle = 0; @attributes = []
      self.class.instance = self
    end
    
    def get_client_pos() FDCommonMethod.getFormPos(self, true, self.parent) end
    
    def x=(xpos) self.move(xpos,self.y,self.w,self.h) end
    def y=(ypos) self.move(self.x,ypos,self.w,self.h) end
    def w=(width) self.move(self.x,self.y,width,self.h) end
    def h=(height) self.move(self.x,self.y,self.w,height) end
    
    def set_modules(m) (@modules << m).uniq! end
    
    def get_parents_str(c)
      return "" if c.is_a? VRForm
      s = "_#{c.name}"
      s[0,0] = get_parents_str(c.parent) unless c.parent.is_a? VRForm
      s
    end
    
    def getLevel(c)
      if c.is_a?(VRForm) || c.is_a?(VRDialogComponent) then
        ""
      else
        getLevel(c.parent) + Indent_Str
      end
    end
    
    def owndraw_used?
      FDOwnerDraw::ODConst[self.class].each{|key,value|
        return key if value == @owndraw } if @owndraw != 0
      'not used'
    end
    
    def tab_order
      if (self.style & WStyle::WS_TABSTOP) == 0 then
        ""
      else
        @taborder.to_s
      end
    end
    
    def set_owndraw(state)
      @owndraw=0 unless @owndraw=FDOwnerDraw::ODConst[self.class][state]
    end
    
    def mk_addstr(cnt, name, caption, x, y, w, h, sty)
      st = ','+sprintf("%#x",sty) unless sty == 0
      c = (respond_to?(:addControl) || !@modules.empty? || @owndraw > 0) ?
                                                         name.capitalize1 : cnt
      "addControl(#{c},'#{name}',\"#{caption}\",#{x},#{y},#{w},#{h}#{st})\n"
    end
    
    def singleton_method_added(sym)
      __send__ sym if sym == :init_singleton_class
    end
  end

  module FDParent
    include FDCommonMethod
    include CreateCtrl
    include VRContainersSet
    
    attr_reader :included, :names, :cntnmodules,
                :_fd_dragging, :_vr_twopaneframes, :selected, :coverfrm
    attr_accessor :tabOrders, :__regsterd_vr_margined_frame,
                  :_default_font, :_prev_dflt_hfont
    
    def self.extended(c)
      c.fd_parent_init()
    end
    
    def fd_parent_init()
#      vrinit
      @included = []; @tabOrders = []; @cntnmodules = []
      @controls = OHash.new
      unless self.is_a?(VRTabbedPanel) || self.is_a?(VRRebar) || self.is_a?(VRForm) || self.is_a?(VRGroupbox)
        addHandler(WMsg::WM_PAINT,"__fd_paint",MSGTYPE::ARGNONE,nil)
        addEvent WMsg::WM_PAINT
      end
    end
    
    def self___fd_paint()
      $designfrm.coverfrm.userMessage('paint_handles')
    end
   
    def addControl(*args)
      r = super
      if @_default_font
        r.setFont(@_default_font)
      end
      r
    end
    
    def delete_child_controls
      @controls.each{|k,v|
        v.terminate if v.respond_to? :terminate
        deleteControl(v)
        @form.delete_serial_name(v.name)
        delete_child_controls if v.respond_to? :addControl
      }
    end
    
    def getDEFAULTFONT(lv)
      return "" unless @_default_font
      hf=@_default_font.hfont
      n = @form.get_font_number(hf)
      "#{lv}  DEFAULT_FONT=#{@form.name.capitalize1}_fonts[#{n}]\n"
    end

    def getFontStrParent(lv)
      return "" if !@_default_font || self.parent.is_a?(VRTabbedPanel)
      hf = @_default_font.hfont
      if (n = @form.get_font_number(hf))
        lv + "    self.setFont(#{@form.name.capitalize1}_fonts[#{n}])\n"
      else  "" end
    end
    
    def get_childs_source(novrinit=nil)
      ctls = @controls.dup
      @cntnmodules=[]
      r=[]
      rf=[]
      lv=getLevel(self)
      s="\n"+lv+"class #{self.name.capitalize1} < #{self.class}\n"; sattr=""
      incld1 = []
      @modules.uniq!
      analize_frame = lambda do |frame|
        if frame.is_a? VRTwoPaneFrame
          frame.pane1.each do |i|
            unless i.is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i.container.etc)
              rf << yield(c)
            end
          end
          frame.pane2.each do |i|
            unless i.is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i.container.etc)
              rf << yield(c)
            end
          end
        elsif frame.is_a? VRGridLayoutFrame
          frame._vr_layoutclients.each do |i|
            unless i[0].is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i[0].container.etc)
              rf << yield(c)
           end
          end
        else
          frame._vr_layoutclients.each do |i|
            unless i.is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i.container.etc)
              rf << yield(c)
            end
          end
        end
      end
      
      if @__regsterd_vr_margined_frame
        analize_frame.call(@__regsterd_vr_margined_frame)
        c = ctls.delete( @__regsterd_vr_margined_frame.container.etc)
        rf << yield(c)
      end
      @tabOrders.each{|id| item = ctls.delete(id)
        next if item.respond_to?(:ignore_formdesigner) &&
                                                       item.ignore_formdesigner
        if item.is_a? VRNotifyControl then
          (incld1 << "VRComCtlContainer").uniq!
        else
          (incld1 << "VRStdControlContainer").uniq!
        end
        (@modules << "VROwnerDrawControlContainer").uniq! if
                                item.respond_to?(:owndraw) && (item.owndraw > 0)
        sattr += lv+"  attr_reader :#{item.name}\n"
        item.style = item.style+WStyle::WS_TABSTOP
        r << yield(item)
      }
      
      ctls.each{|id,item|
        next if @tabOrders.index(id)
        next if item.respond_to?(:ignore_formdesigner) &&
                                                       item.ignore_formdesigner
        if item.is_a? VRNotifyControl then
          (incld1 << "VRComCtlContainer").uniq!
        else
          (incld1 << "VRStdControlContainer").uniq!
        end
        (@modules << "VROwnerDrawControlContainer").uniq! if item.owndraw > 0
        sattr += lv+"  attr_reader :#{item.name}\n"
        r << yield(item)
      }
      unless @modules.empty? then
        incld1 = incld1 + @modules
        @modules.each{|m|
          if rq = FDModules::StdModules["#{m}".intern ] then
            (@form.required << rq.requires).uniq!
            @form.required.reject!{|i| !i} #delete nil
          end
        }
      end
      s1 = []
      incld1.each{|i| s1 << lv+"  include #{i}"}
      @included.each{|m| s1 << lv+"  include #{m} if defined? #{m}" if m} unless
                                                                @included.empty?
      s += s1.join("\n") + "\n"
      s += getDEFAULTFONT(lv) if @_default_font
      s += sattr
      s += @cntnmodules.join("") if @cntnmodules
      s += "\n#{lv}  def construct\n"
#      s += getFontStrParent(lv)
      s += r.join("\n")
      s += rf.join("\n")
      s += lv+"  end\n"
      s += lv+"end\n"
      s
    end

    def set_include(i)
      @included << i
      @included.uniq!
    end

  end

  module STDSourceMaker
    def getFontStr(lv)
      hf=sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
      if  (n = @form.get_font_number(hf)) &&
             (!@parent._default_font || @parent._default_font.hfont != hf)
        lv + "  @#{name}.setFont(#{@form.name.capitalize1}_fonts[#{n}])\n"
      else  "" end
    end
        
    def addRequire
      unless @modules.empty? then
        @modules.each{|m|
          if rq = FDModules::StdModules["#{m}".intern ] then
            (@form.required << rq.requires).uniq!
            @form.required.reject!{|i| !i}
          end
        }
      end
    end

    def addModules
      sp=get_parents_str(self.parent)
      lv=getLevel(self)
      ms = lv+"class #{name.capitalize1} < #{self.class}\n"
      @modules.each{|m|
        ms += lv+"  include #{m}\n";
        (@form.required << FDModules::StdModules["#{m}".intern ].requires).uniq!
        @form.required.reject!{|i| !i}
      }
      ms += lv+"end\n\n"
      @parent.cntnmodules << ms
    end
    
    def attr_to_asignment(lv)
      s = ""
      @attributes.each do |i|
        case i[2]
        when "num"
          s += lv + "  " + "@#{self.name}.#{i[0]} = #{send(i[0])}\n"
        when "str"
          s += lv + "  " + "@#{self.name}.#{i[0]} = \"#{send(i[0])}\"\n"
        end
      end
      s
    end

    def create_std_source_str
      if respond_to? :initMargin
        x0=@__org_x; y0=@__org_y; w0=@__org_w; h0=@__org_h
      else
        x0,y0,w0,h0 = get_client_pos
      end
      str = ""
      sty = (self.style|@owndraw)-@_default_style
      lv = getLevel(self)
      cnt = self.class.to_s
      sp = lv + "  "
      if block_given?
        str += yield(sp,cnt,name,caption.esc,x0,y0,w0,h0,sty)
      else
        str += sp + mk_addstr(cnt,name,caption.esc,x0,y0,w0,h0,sty)
      end
      if respond_to?(:addControl)
        @parent.cntnmodules << get_childs_source{|i| i.createSourceStr}
        addRequire
      elsif !@modules.empty? || @owndraw > 0
        addModules 
      else
      end
      str += getFontStr(lv)
      str += attr_to_asignment(lv)
      str
    end
    
    def createSourceStr() create_std_source_str end
  end
  
  def set_modules(m) (@modules << m) ; @modules.uniq! end

  def findPalletItem(cnt)
    r = nil
    if cnt.is_a? FDStruct then
        return cnt
    else
      if cnt.respond_to?(:substance) then
        c = cnt.substance
      else
        c = cnt
      end
      $conf.each{|pallet|
        r = pallet.items.find{|i| (c == i.klass) || (c.class == i.klass)}
        return(r) if r
      }
    end
    r
  end

  def set_cnt_attr(a,cnt)
    @required = [] unless @required
    @required << cnt.required
    @required.flatten!
    @required.uniq!
    @cmodules={} unless @cmodules
    @cinfo={} unless @cinfo
    @cmodules[a.etc]=a.inspect.sub(/#<(.+):.*>/,'\1')
    @cinfo[a.etc]=cnt.klass
    @owndraw = 0
    a.extend FDControlExt
    a._default_style = cnt.styles[:default_style]
    a._maskstyle = cnt.maskstyle
    a.attributes = cnt.attrs.select{|i|
      i.is_a?(Array)    &&
      i[0] != 'font'    &&
      i[0] != 'style'   &&
      i[0] != 'modules' &&
      i[0] != 'tabOrder'&&
      i[0] != 'owndraw'
    }
  end
  
  def check_owndraw(c,addstyle)
    if ods = FDOwnerDraw::ODConst[c.klass]
      ods.each{|key,value|
        return value if addstyle & value != 0
      }
    end
    0
  end
  
  #definiton of creating methods on FormDesigner
  
  def newFDControl(prnt,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
    c = findPalletItem(cnt)
    addstyle |= c.maskstyle
    od = check_owndraw(c, addstyle)
    addstyle &= (~od)
    eval c.precreation if c.is_a?(FDStruct) && c.precreation
    a = prnt.addControl(c.klass,name,caption,x,y,w,h,addstyle)
    prnt.set_include(c.included)
    set_cnt_attr(a, c)
    a.owndraw = od
    a.extend(FDParent) if a.respond_to?(:addControl)
    a.extend(STDSourceMaker)
    a.extend(eval(c.createmethods.to_s)) if c.createmethods
    a.post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_items, c) if
                                                   a.respond_to?(:post_created)
    a
  end
  
  def newFDContainer(prnt,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
    c = findPalletItem(cnt)
    eval c.precreation if c.is_a?(FDStruct) && c.precreation
    a = prnt.addControl(FDContainer,name,caption,x,y,w,h,addstyle)
    prnt.set_include(c.included)
    set_cnt_attr(a, c)
    a.bmp=SWin::Bitmap.loadString(c.bmp)
#    a.extend(STDSourceMaker)
    a.extend(eval(c.createmethods.to_s)) if c.createmethods
    a.post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_items, c) if
                                                   a.respond_to?(:post_created)
    a
  end
  
  
#### Additional modules for creation
  
  module NewFDCombo
    
    def drop_h() @_drop_h=h unless @_drop_h; @_drop_h end
    
    def drop_h=(h) @_drop_h=h end
    
    def createSourceStr
      create_std_source_str {|sp,cnt,name,caption,x0,y0,w0,h0,sty|
        sp + mk_addstr(cnt,name,caption,x0,y0,w0,@_drop_h,sty)
      }
    end
      
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_items,c)
      _x, _y, _w, _h = windowrect
      self.move(self.x, self.y, _w, _h)
      @_drop_h = h
    end
  end
  
  ## Common controls
  
  module NewFDToolbar
    def getItemsStr(option=nil)
      lv=getLevel(self)
      s = lv+"  ["
      0.upto(countButtons-1){|i|
        b = getButton(i)
        st = option ? b[3].to_s : Stylehash.invert[b[3]].to_s
        s<<"\n#{lv}    [\"#{@parent._vr_toolbar_buttons[b[1]].name}\",#{st}],"
      }
      if s[s.size-1] == ','[0]
        s[s.size-1,1] = "\n#{lv}  ]"
      else
        s << "]"
      end
        s
    end
    
    def getItems2
      s = []
      0.upto(countButtons-1){|i|
        b = getButton(i)
          st = Stylehash.invert[b[3]].to_s
        s << [st,@parent._vr_toolbar_buttons[b[1]].name]
      }
      s
    end

    def refreshItems(ar)
      begin
        ar.collect!{|i| [i[1],Stylehash[i[0]]]}
        self.terminate
        setButtons(ar)
        @_fd_items = ar
      rescue Exception
        messageBox $!,'Illegal setting of items',16
      end
    end

    def terminate
      (countButtons-1).downto(0){|i|
        b = getButton(i)
        @parent._vr_toolbar_buttons.delete(b[1])
        deleteButton(i)
      }
    end
    
    def createSourceStr
      if respond_to? :initMargin
        x0=@__org_x; y0=@__org_y; w0=@__org_w; h0=@__org_h
      else
        x0,y0,w0,h0 = get_client_pos
      end
      str = ""
      sty = self.style-@_default_style
      cnt=self.class.to_s
      lv=getLevel(self)
      str += lv+"  "+ mk_addstr(cnt,name,caption.esc,x0,y0,w0,h0,sty)
      if countButtons > 0 then
        str += lv+"  "+"@#{name}.setButtons(\n#{getItemsStr(true)})\n"
      else
        str += "\n"
      end
    end

    def eventList
      as = []
      0.upto(countButtons-1){|i|
        b = getButton(i)
        as << @parent._vr_toolbar_buttons[b[1]].name+"_clicked" unless b[3]==1
      }
      as
    end
      
    def buttons
      @form._return_val=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::LISTWIDTH[0] = 254
      ItemEditDlg::ADDINGNAME[0] = 'toolButton'
      ItemEditDlg::ADDREMOVE[0] = true
      ItemEditDlg::TITLES[0]=[['button style',140],['button name',110]]
      ItemEditDlg::ITEMS[0] = getItems2
      ItemEditDlg::FIXCOLUMN[0] = true
      ItemEditDlg::UPDOWN[0] = true
      ItemEditDlg::STYLES[0]=['TBSTYLE_BUTTON','TBSTYLE_SEP','TBSTYLE_CHECK',
                              'TBSTYLE_GROUP','TBSTYLE_CHECKGROUP']
      ItemEditDlg::DEFAULTSTR[0]='TBSTYLE_BUTTON'
      VRLocalScreen.modalform @form ,nil,ItemEditDlg
      r = @form._return_val
      refreshItems(r) if r
      @form.update_inspectfrm(self)
    end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle, c_items,c)
      self.class.module_eval "attr_reader :_vr_toolbar_buttons"
      prnt.extend VRToolbarUseable
      if parent.is_a?(VRRebar)
        style = style | 4
        move(0,0,60,24)
      end 
      if c_items
        setButtons(c_items)
        @_fd_items = c_items
      elsif @_fd_items
        setButtons(a.items)
      else
        items2 = c.items.dup.collect!{|i|
          [$designfrm.get_serial_name(i[0]),i[1]]
        }
        setButtons(items2)
        @_fd_items = items2
      end
    end
  end

  module NewFDRebar
    include STDSourceMaker
    def self.extended(mod)
      mod.class.module_eval(
                       "USE_THIS_PARENT=true unless defined?( USE_THIS_PARENT)")
    end
    
    def get_childs_source(novrinit=nil)
      @cntnmodules = []
      lv=getLevel(self)
      r=[]
      s=""
      incld1 = []
      @modules.uniq!
      @_fd_items.each{|i|
        ct = instance_eval("#{i[0]}")
        break if ct.is_a?(VRStatic) && i[0] == "@__"+ct.parent.name
        if ct.kind_of? VRNotifyControl
            (incld1 << "VRComCtlContainer").uniq!
        else
          (incld1 << "VRStdControlContainer").uniq!
        end
        r << yield(ct,i[1],i[2],i[3])
      }
      unless @modules.empty?
        incld1 = incld1 + @modules
        @modules.each{|m|
          if rq = FDModules::StdModules["#{m}".intern ]
            (@form.required << rq.requires).uniq!
            @form.required.reject!{|i| !i} #delete nil
          end
        }
      end
      s += "\n#{lv}  def construct\n"
#      s += getFontStrParent(lv)
      s += r.join("\n")
      s1 = []
      incld1.each{|i| s1 << "#{lv}  include #{i}"}
      @included.each{|m|
        s1<<"#{lv}  include #{m} if defined? #{m}" if m
      } unless @included.empty?
      sp=get_parents_str(self.parent)
      s = s1.join("\n")+ "\n" + s
      s[0,0] = getDEFAULTFONT(lv) if @_default_font
      s[0,0] = "\n#{lv}class #{name.capitalize1} < #{self.class}\n"
      s += "#{lv}  end\n"
      s += "#{lv}end\n"
      s
    end

    def  createSourceStr
      if respond_to? :initMargin
        x0=@__org_x; y0=@__org_y; w0=@__org_w; h0=@__org_h
      else
        x0,y0,w0,h0 = get_client_pos
      end
      str = ""
      sty = self.style-@_default_style
      sp=get_parents_str(self.parent)
      lv=getLevel(self)
      cnt=self.class.to_s
      if respond_to?(:addControl)
        str += lv+"  "+ mk_addstr(name.capitalize1,name,caption.esc,
                                                               x0,y0,w0,h0,sty)
        @parent.cntnmodules << get_childs_source{|c,t,w,h|
          s=c.createSourceStr
          s.sub! /^ +/,lv+"    @#{c.name}="
          s << lv+"    insertband(@#{c.name},'#{t}',#{w},#{h})\n"
          s
        }
        addRequire
      elsif !@modules.empty?
        str += lv+"  "+
                        mk_addstr(name.capitalize1,name,caption.esc,x,y,w,h,sty)
        addModules
      else
        str += lv+"  "+ mk_addstr(cnt,name,caption.esc,x,y,w,h,sty)
      end
      str+= getFontStr(lv)
      str
    end
    
    def refreshItems(ar)
      @_fd_items.each_index{|i|
        i0 =ar.select{|j| @_fd_items[i][0] == j[0]}[0]
        @_fd_items[i][1] = i0[1]
        @_fd_items[i][2] = i0[2].to_i
        @_fd_items[i][3] = i0[3].to_i
        setbandattr(i,i0[1],i0[2].to_i,i0[3].to_i)
      }
    end

    def bands
      @form._return_val=nil
      ItemEditDlg::LISTWIDTH[0] = 392
      ItemEditDlg::STYLES[0]=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::ADDREMOVE[0] = false
      ItemEditDlg::UPDOWN[0] = false
      ItemEditDlg::TITLES[0]=[['control',100],['text',100],
                                                      ['min w',92],['min h',92]]
      ItemEditDlg::ITEMS[0] = @_fd_items
      ItemEditDlg::FIXCOLUMN[0] = true
      VRLocalScreen.modalform @form ,nil,ItemEditDlg
      r = @form._return_val
      refreshItems(r) if r
    end

    def setbandattr(idx,txt="",minx=30,miny=30)
      unless idx.is_a? Integer
        n = @_fd_items.index(items.find{|i| i[0] == "@#{idx.name}" })
        idx = n
      end
      mask= WConst::RBBIM_TEXT | WConst::RBBIM_STYLE | WConst::RBBIM_CHILD |
                               WConst::RBBIM_CHILDSIZE | WConst::RBBIM_SIZE
      t= ""
      tis = [56,mask,0,0,0,t,0,0,0,0,0,0,0,0,0].pack(
                                                    "LLLLLP#{t.length}LLLLLLLL")
      sendMessage WMsg::RB_GETBANDINFO,idx,tis
      a = tis.unpack("LLLLLPLLLLLLLL")
      a[5]= txt; a[9]=minx; a[10]=miny
      rbbi=a.pack("LLLLLP#{txt.length}LLLLLLLL")
      sendMessage(WMsg::RB_INSERTBAND+5,idx,rbbi)
    end
    
    def deleteband(idx)
      sendMessage WMsg::RB_DELETEBAND,idx,0
    end
      
    def update_items(oldname,newname)
      @_fd_items.find{|i|i[0]=='@'+oldname}[0] = '@' + newname
    end
    
=begin    
    def terminate
      @_fd_items.reject!{|i|
        unless i[0] == "@__#{self.name}"
          deleteControl(instance_eval("#{i[0]}"))
          child_deleted(instance_eval("#{i[0]}"))
        end
        true
      }
    end
=end
    
    def child_created(c)
      if c0=@_fd_items.find{|i| i[0] == "@__#{self.name}"}
        deleteControl(instance_eval("#{c0[0]}"))
        @_fd_items.delete_at(0)
        deleteband(0)
      end
      @parent.instance_eval("@#{c.name}=nil")
      @parent.instance_eval "@controls.delete(c.etc)"
      @controls[c.etc] = c
      unless itm=@_fd_items.find{|i| i[0] == '@'+c.name}
        @_fd_items << itm=['@'+c.name,c.name,30,c.h+2]
      end
      instance_eval "@#{c.name}=c"
      insertband(c,itm[1],itm[2],itm[3])
      relayout
    end
    
    def child_deleted(c)
      idx = @_fd_items.index(@_fd_items.find{|i| i[0] == '@'+c.name })
      @_fd_items.delete_at(idx)
      deleteband(idx)
      if @_fd_items.empty?
        cv=addControl(VRStatic,"__#{name}",'',0,0,25,25)
        @parent.instance_eval("@#{cv.name}=nil")
        @parent.instance_eval "@controls.delete(cv.etc)"
        @controls[cv.etc] = cv
        instance_eval("@#{cv.name}=cv")
        insertband(cv,"",0,30)
        @_fd_items = [['@'+cv.name,""]]
        c1 = findPalletItem(cv)
        @form.set_cnt_attr(cv,c1)
      end
    end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_items,c)
      self.extend FDParent
      unless c_items
        cv = addControl(VRStatic,"__#{name}",'',0,0,25,25)
        parent.instance_eval("@#{cv.name}=nil")
        parent.instance_eval "@controls.delete(cv.etc)"
        @controls[cv.etc] = cv
        instance_eval("@#{cv.name}=cv")
        insertband(cv,"",0,30)
        @_fd_items = [['@'+cv.name,""]]
        c1 = findPalletItem(cv)
        set_cnt_attr(cv,c1)
      else
        @_fd_items = c_items 
      end
    end
  end
  
  module NewFDTabControl
    include STDSourceMaker
    
    def tabs
      @form._return_val=nil
      ItemEditDlg::LISTWIDTH[0] = 392
      ItemEditDlg::STYLES[0]=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::ADDINGNAME[0] = 'tab'
      ItemEditDlg::ADDREMOVE[0] = true
      ItemEditDlg::UPDOWN[0] = false
      ItemEditDlg::TITLES[0]=[['name',0],['title',200]]
      ItemEditDlg::ITEMS[0] = getItems
      ItemEditDlg::FIXCOLUMN[0] = true
      VRLocalScreen.modalform @form ,nil,ItemEditDlg
      r = @form._return_val
      return unless r
      clearTabs
      r.each_with_index{|v,i|insertTab(i,v[1])}
      @form.refreshCntName
      @form.update_inspectfrm(self)
    end
    
    def getItems
      r = []
      0.upto(countTabs-1){|i| r << ['',getTabTextOf(i)]}
      r
    end
    
  end
  
  module NewFDTabbedPanel
    include STDSourceMaker
    
    def self.extended(mod)
      mod.class.module_eval(
                       "USE_THIS_PARENT=true unless defined?( USE_THIS_PARENT)")
      mod.addHandler(WMsg::WM_SIZE,"_vr_tabpanelresize", MSGTYPE::ARGLINTINT,nil)
      mod.acceptEvents [WMsg::WM_SIZE]
    end
    
    def getItemsStr(option=nil)
      lv=getLevel(self)
      s = "[\n"
      0.upto(countTabs-1){ |i|
        s += "#{lv}      ['#{getTabTextOf(i)}'," +
                     "#{@panels[i].name.capitalize1},'#{@panels[i].name}'],\n"}
      s[s.size-2,2] = "\n#{lv}    ]"
      s
    end
    
    def getItems2
      s = []
      0.upto(countTabs-1){ |i| s << [@panels[i].name,getTabTextOf(i)]}
      s
    end

    def refreshItems(a0)
      @_fd_items = a0.collect{|i| i[1]}
      a1 = a0.select{|i| i[0]!=""}.collect{|i| instance_eval('@'+i[0])}
      @panels.each_with_index{|itm,idx|
        unless a1.find{|j| j == itm }
          @panels[idx].delete_child_controls
          deleteControl(@panels[idx])
          @panels.delete_at(idx)
        end
      }
      @panels.each{|i| 
        instance_eval "@#{i.name}=nil"
        i.name = "___"+i.name
      }
      clearTabs
      0.upto(a0.size-1){|i|
        insertTab(i,a0[i][1])
        if (n=a0[i][0]) != ''
          m = 0.upto(@panels.size-1){|j|
            break j if @panels[j].name == "___#{n}" }
          @panels[i,0] = @panels.delete_at(m)
          instance_eval "@#{@panels[i].name.sub(/^___/,'')}=nil"
          @panels[i].name = "panel#{i}"
          instance_eval "@#{@panels[i].name}=@panels[i]"
        else
          @panels[i,0] = nil
          x,y,w,h = adjustRect(0,0,self.w,self.h,false)
          @panels[i] = addControl(VRPanel,"panel#{i}","panel#{i}",x,y,w-x,h-y)
          @panels[i].extend VRContainersSet
          @panels[i].containers_init
          @panels[i].show 0
          c1 = @form.findPalletItem(@panels[i])
          @form.set_cnt_attr(@panels[i],c1)
          @panels[i].extend STDSourceMaker
          @panels[i].extend(FDParent)
          @panels[i].extend CreateCtrl
        end
        @panels[i]._default_font = self._default_font
      }
      #selectTab 0
    end
    
    def terminate() end
    
    def createSourceStr
      lv = getLevel(self)
      if respond_to? :initMargin
        x0=@__org_x; y0=@__org_y; w0=@__org_w; h0=@__org_h
        sr = lv + "  auto_panelresize(true)\n"
      else
        x0,y0,w0,h0 = get_client_pos
        sr = ""
      end
      str = ""
      sty = self.style+@owndraw-@_default_style
      cnt=self.class.to_s
      str += lv+"  "+
      mk_addstr(name.capitalize1,name,caption.esc,x0,y0,w0,h0,sty)
      s2 = ""
      sattr=""
      @panels.each{|i|
        i.modules = self.modules
        sattr += lv+"  attr_reader :#{i.name}\n"
        s2 << i.get_childs_source(true){|j| j.createSourceStr}
      }
      s2 += "\n" + lv + "  def construct\n"
      s2 += getFontStrParent(lv)
      s2 += lv+"    setupPanels(*#{getItemsStr(true)})\n" if @panels.size > 0 
      s2 += lv+"  end\n"
      @parent.cntnmodules <<
                            "\n#{lv}class #{name.capitalize1} < #{self.class}\n"
      @modules.each{|m|
        @parent.cntnmodules << lv+"  include #{m}\n";
        (@form.required <<
                           FDModules::StdModules["#{m}".intern ].requires).uniq!
        @form.required.reject!{|i| !i}
      }
      @parent.cntnmodules << "#{sattr}"
      @parent.cntnmodules << getDEFAULTFONT(lv) if @_default_font
      @parent.cntnmodules << sr
      @parent.cntnmodules << s2 + "#{lv}end\n"
      str += getFontStr(lv)
      str
    end
    
    def pages
      @form._return_val=nil
      ItemEditDlg::LISTWIDTH[0] = 392
      ItemEditDlg::STYLES[0]=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::ADDINGNAME[0] = 'tab'
      ItemEditDlg::ADDREMOVE[0] = true
      ItemEditDlg::UPDOWN[0] = false
      ItemEditDlg::TITLES[0]=[['panel',120],['title',100]]
      ItemEditDlg::ITEMS[0] = getItems2
      ItemEditDlg::FIXCOLUMN[0] = true
      VRLocalScreen.modalform @form ,nil,ItemEditDlg
      r = @form._return_val
      refreshItems(r) if r
      @form.refreshCntName
      @form.update_inspectfrm(self)
    end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_items,c)
      if c_items
        setupPanels(*c_items)
        @_fd_items = c_items
      elsif @_fd_items
        setupPanels(*@_fd_items)
      else
        setupPanels(*c.items)
        @_fd_items = c.items
      end
      panels.each{|i|
        c1 = findPalletItem(i)
        set_cnt_attr(i,c1)
        i.extend STDSourceMaker
        i.extend(FDParent)
      }
    end
  end
  
  ## Menu and other object (except kind of SWin::Window)
  
  module NewFDMenu    
    def createMthodStr(t)
      s= "@#{self.name}.#{t}"
      s
    end
      
    def getItemsStr
      mn=MenuStrMaker.new
      mn.makeStr(@_fd_items)
    end
    
    def refreshItems(a)
      begin
        @_fd_items = a
        @parent._vr_menus.clear
        self.terminate
        self.substance = @parent.newMenu.set(@_fd_items)
        @parent.setMenu self.substance,false
      rescue Exception
        messageBox $!,'Illegal setting of items',16
      end
    end

    def terminate
      @parent.setMenu @parent.newMenu,false if parent.visible?
    end
    
    def set_attrs(a) end #do nothing
    
    def createSourceStr
      r =  "    \#$_addControl(VRMenu,'#{name}',\"\",#{x},#{y},24,24)\n"
      r += "    @#{self.name} = newMenu.set(\n"
      r += self.getItemsStr.gsub(/^/," "*6)
      r += "    )\n"
      @_kb_accel=false unless @_kb_accel
      r += "    setMenu(@#{self.name},#{@_kb_accel})\n"
      #r += "    \#$_ctn_#{self.name}=[#{self.x},#{self.y}]\n"
      r
    end

    def eventList
      s_ary = []
      @parent._vr_menus.each{|i,c|
        s_ary << c.name + "_clicked" unless c.name == '_vrmenusep'
      }
      s_ary
    end
    
    def menus
      a = []
      @form._return_val=nil
      analizer = MenuAnalizer.new
      MenuEditDlg::ITEMS[0] = analizer.analize(@_fd_items)
      MenuEditDlg::POS[0] = [@form.x+50,@form.y+50,468,300]
      0.upto(analizer.colCount-1){|i| a << ["#{i+1}",112]}
      MenuEditDlg::TITLES[0]=a
      VRLocalScreen.modalform @form ,nil,MenuEditDlg
      r = analizer.unanalize(@form._return_val) if @form._return_val
      refreshItems(r) if r
      @form.update_inspectfrm(self)
    end
    
    def accel(a = true) @_kb_accel = a end
      
    def getaccel() @_kb_accel end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_items,c)
      if c_items
        @_fd_items=c_items
      elsif c.items
        @_fd_items=c.items
      else
        @_fd_items=FDMenuTemplate
      end
      accel(true)
      @substance = $designfrm.newMenu.set @_fd_items
      $designfrm.setMenu @substance,false
    end
  end
  
  module NewFDPopup
    def createMthodStr(t)
      case t
      when /^showPopup/
        s=t.sub /(\(.+\))/,"(@#{self.name})"
      else
        s= "@#{self.name}.#{t}"
      end
      s
    end
    
    def getItemsStr
      mn=MenuStrMaker.new
      mn.makeStr(@_fd_items)
    end
    
    def set_attrs(a) end #do nothing
    
    def createSourceStr
      r =  "    \#$_addControl(FDPopup,'#{name}',\"\",#{x},#{y},24,24)\n"
      r += "    @#{self.name} = newPopupMenu.set(\n"
      r += self.getItemsStr.gsub(/^/," "*6)
      r += "    )\n"
      r
    end

    def menus
      a = []
      @form._return_val=nil
      analizer = MenuAnalizer.new
      MenuEditDlg::ITEMS[0] = analizer.analize(@_fd_items)
      MenuEditDlg::POS[0] = [@form.x+50,@form.y+50,468,300]
      0.upto(analizer.colCount-1){|i| a << ["#{i+1}",112]}
      MenuEditDlg::TITLES[0]=a
      VRLocalScreen.modalform @form ,nil,MenuEditDlg
      @_fd_items = analizer.unanalize(@form._return_val) if @form._return_val
      @form.update_inspectfrm(self)
    end
    
    def eventList
      ar = []
      an = MenuAnalizer.new
      ana = an.analize(@_fd_items)
      ana.each{|i|
        level = 0
        flag0 = nil
        a = []
        i.each{|j|
          if j == ""
            break if flag0
            level += 1
          else
            a << j
            flag0 = true
          end
        }
        ar << a[1]+'_clicked' if a.size > 1 && a[1] != "_vrmenusep"
      }
      ar
    end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_items,c)
      if c_items
        @_fd_items=c_items
      elsif c.items
        @_fd_items=c.items
      else
        @_fd_items=FDItems::FDPopupMenuTemplate
      end
      @substance = c.klass.new 
    end
  end

  module NewFDOpenSaveDlg#(prnt,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
#    c = findPalletItem(cnt)
#    a=addControl(FDContainer,name,caption,x,y,w,h,addstyle )
#    class << a

      def createSourceStr
        cnt=self.substance.class.name.sub /^.*::/,''
        sb = self.substance
        sty = sprintf("%#x",style)
        r =  "    \#$_addControl(#{cnt},'#{name}',\"\",#{x},#{y},24,24)\n"
        r +=
        "    \#$_ctn_#{self.name}=[#{sb.filters.inspect},#{sb.flags.to_x},"+
                          "#{sb.title.inspect},#{sb.defaultExt.inspect}]\n"
        r
      end

      def createMthodStr(s)
        sb = self.substance
        str = s.sub /\(.*$/ , ''
        fs = sb.flags ? sb.flags.to_x : 'nil'
        "#{str}(#{sb.filters.inspect},#{fs},#{sb.title.inspect},"+
        "#{sb.defaultExt.inspect})"
      end

      def set_attrs(a)
        @substance.filters = a[0]
        @substance.flags = a[1]
        @substance.title = a[2]
        @substance.defaultExt = a[3]
      end

      def filters
        @substance.filters = [["all(*.*)","*.*"]] unless @substance.filters
        @form._return_val=nil
        ItemEditDlg::LISTWIDTH[0] = 392
        ItemEditDlg::STYLES[0]=nil
        ItemEditDlg::POS[0] = [100,100,400,300]
        ItemEditDlg::ADDINGNAME[0] = '*.*'
        ItemEditDlg::ADDREMOVE[0] = true
        ItemEditDlg::UPDOWN[0] = true
        ItemEditDlg::TITLES[0]=[['title',200],['filter',100]]
        ItemEditDlg::ITEMS[0] = @substance.filters
        ItemEditDlg::FIXCOLUMN[0] = false
        VRLocalScreen.modalform @form ,nil,ItemEditDlg
        r = @form._return_val
        @substance.filters=r if r
        @form.update_inspectfrm(self)
      end

      def flags
        if @substance.class == FDFakeClass::FDOpenDlg
          aryFlags = FDComDlgItems::OpenFileFlag
          @substance.flags = aryFlags['OFN_FILEMUSTEXIST'] unless
                                                             @substance.flags
        else
          aryFlags = FDComDlgItems::SaveFileFlag
          @substance.flags = aryFlags['OFN_OVERWRITEPROMPT'] unless
                                                             @substance.flags
        end
        a = []
        aryFlags.each{|k,v|
          n = ((@substance.flags & v) == 0 ) ? 0 : 1
          a << [k.dup,n]
        }
        if s = @form.showModDlg(a,104,195)
          n = 0
          s.each{|i| n |=  aryFlags[i[0]] if i[1] !=0}
          @substance.flags=n
        end
        @form.update_inspectfrm(self)
      end

      def title() @substance.title end

    def defaultExt() @substance.defaultExt end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_itemms,c)
      @substance = c.klass.new 
      @substance.filters = FDItems::FDDlgFilterTemplate
      if @substance.class == FDFakeClass::FDOpenDlg
        aryFlags = FDComDlgItems::OpenFileFlag
        @substance.flags = aryFlags['OFN_FILEMUSTEXIST']
      else
        aryFlags = FDComDlgItems::SaveFileFlag
        @substance.flags = aryFlags['OFN_OVERWRITEPROMPT']
      end
      @substance.title = nil
      @substance.defaultExt = nil
    end
  end

  module NewFDSelectDir
      def flags
        a = []
        FDComDlgItems::BrowseFolderFlag.each{|k,v|
          n = ((@substance.flags & v) == 0 ) ? 0 : 1
          a << [k.dup,n]
        }
        if s = @form.showModDlg(a,104,195) then
          n = 0
          s.each{|i| n |=  FDComDlgItems::BrowseFolderFlag[i[0]] if i[1] !=0}
          @substance.flags = n
        end
      end
    
      def set_attrs(a) end #do nothing
    
      def title() @substance.title end

      def initialdir() @substance.initialdir end

      def terminate() end
    
      def createSourceStr
        cnt=self.substance.class.name.sub /^.*::/,''
        sty = sprintf("%#x",style)
        r =  "    \#$_addControl(#{cnt},'#{name}',\"\",#{x},#{y},24,24)\n"
        r += "    \#$_ctn_#{self.name}=[#{self.x},#{self.y},"+
                "#{@substance.title.inspect},#{@substance.initialdir.inspect},"+
                "#{@substance.flags.to_x}]\n"
        r
      end
      
      def createMthodStr(s)
        sb = self.substance
        str = s.sub /\(.*$/ , ''
        fs = sb.flags ? sb.flags.to_x : 'nil'
        "#{str}(#{sb.title.inspect},#{sb.initialdir.inspect},#{fs})"
      end
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,c_itemms,c)
      @substance = c.klass.new 
      @substance.flags=FDComDlgItems::BrowseFolderFlag["BIF_RETURNONLYFSDIRS"]
    end
  end
  
  ## Layouts
  
  module NewFD2Pane
    
    def getItemsStr(option=nil) "" end
      
    def set_attrs(a) end #do nothing
      
    def refreshItems(ar) end
      
    def terminate
      if parent.__regsterd_vr_margined_frame == self.substance
        parent.__regsterd_vr_margined_frame=nil;GC.start
      end
      @substance.bevel=@substance.class::BevelNone
      @substance.gap=0
      @substance.pane1.each{|i|
        if i.is_a? SWin::Window
          i.setMargin(nil,nil,nil,nil)
          i.registerd_to = []
          i.margined = nil
        end
      } if @substance.pane1
      @substance.pane2.each{|i|
        if i.is_a? SWin::Window
          i.setMargin(nil,nil,nil,nil)
          i.registerd_to = []
          i.margined = nil
        end
      } if @substance.pane2
      $designfrm.coverfrm.close_hole(@substance);p [1603,@substance]
    end
    
    def createSourceStr
      def self.create_setmargin(lv,name,o)
        "#{lv}  @#{name}.setMargin("+o.mgLeft.inspect+','+o.mgTop.inspect+
                              ','+o.mgRight.inspect+','+o.mgBottom.inspect+")\n"
      end
      make_panes = lambda do |p|
        s=p.map{|i|
          '@'+(i.is_a?(SWin::Window) ? i.name : i.container.name)+','}.join("")
        s[0,s.size-1]
      end
      lv = getLevel(self)
      sb = self.substance
      cnt=sb.class.name.sub /^.*::/,''
      sty = sprintf("%#x",style)
      r = "#{lv}  \#$_addControl(#{cnt},'#{name}',\"\",#{x},#{y},24,24)\n"
      if parent.__regsterd_vr_margined_frame == self.substance
        r += "#{lv}  @#{self.name}=setMarginedFrame(#{cnt}," +
             "[#{make_panes.call(sb.pane1)}],[#{make_panes.call(sb.pane2)}])\n"
        r += create_setmargin(lv,self.name,sb)
      else
        r += "#{lv}  @#{self.name}=#{cnt}.new([#{make_panes.call(sb.pane1)}]," +
                                 "[#{make_panes.call(sb.pane2)}]).setup(self)\n"
      end
      r += "#{lv}  @#{self.name}.ratio=#{sb.ratio}\n" if sb.ratio
      r += "#{lv}  @#{self.name}.position=#{sb.position}\n" if sb.position
      r += "#{lv}  @#{self.name}.gap=#{sb.gap}\n"
      r += "#{lv}  @#{self.name}.bevel=VRMgdTwoPaneFrame::Bevel" +
           @form.instance_eval("lambda{|c| #{@form.prBevel}}").call(self) + "\n"
      r += "#{lv}  @#{self.name}.lLimit=#{sb.lLimit}\n" if sb.lLimit > 0
      if sb.is_a? VRHorizTwoPaneFrame
        r += "#{lv}  @#{self.name}.rLimit=#{sb.rLimit}\n" if sb.rLimit > 0
      else
        r += "#{lv}  @#{self.name}.uLimit=#{sb.uLimit}\n" if sb.uLimit > 0
      end
      sb.pane1.each do |i|
        if i.is_a? SWin::Window
          r += create_setmargin(lv,i.name,i)
        else
          r += create_setmargin(lv,i.container.name,i)
        end
      end
      sb.pane2.each do |i|
        if i.is_a? SWin::Window
          r += create_setmargin(lv,i.name,i)
        else
          r += create_setmargin(lv,i.container.name,i)
        end
      end
      r
      end
    
    def createMthodStr(s)
      str = s.sub(/\(.*$/ , '')
      "#{str}"
    end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,items,c)
      prnt.addHandler(WMsg::WM_SIZE,'vrmgresize', MSGTYPE::ARGLINTINT, nil)
      prnt.addEvent WMsg::WM_SIZE
      c.klass.module_eval("attr_accessor :pane1, :pane2, :container")
      c.klass.module_eval("attr_reader :_vr_lxs, :_vr_lys, :_vr_lxe, :_vr_lye")
      first = nil
      first = items.pop if items.is_a?(Array) && items.last == true
      if first || (!items && !prnt.__regsterd_vr_margined_frame)
        if items
          @substance = prnt.setMarginedFrame(c.klass,
          items[0].map{|i|
            (j= prnt.instance_eval(i)).is_a?(FDContainer)? j.substance : j},
          items[1].map{|i|
            (j= prnt.instance_eval(i)).is_a?(FDContainer)? j.substance : j})
          @substance.pane1.each do |i|
            if i.is_a?(SWin::Window)
            i.registerd_to=[self,0]
              i.margined = true
            else
              i.container.registerd_to=[self,0]
            end
          end
          @substance.pane2.each do |i|
            if i.is_a?(SWin::Window)
              i.registerd_to=[self,1]
              i.margined = true
            else
              i.container.registerd_to=[self,1]
            end
          end
        else
          @substance = prnt.setMarginedFrame(c.klass,[],[])
        end
      else
        if items
          @substance = c.klass.new(
          items[0].map{|i|
            (j= prnt.instance_eval(i)).is_a?(FDContainer)? j.substance : j},
          items[1].map{|i|
            (j= prnt.instance_eval(i)).is_a?(FDContainer)? j.substance : j})
          @substance.pane1.each do |i|
            if i.is_a?(SWin::Window)
              i.registerd_to=[self,0]
            else
              i.container.registerd_to=[self,0]
            end
          end
          @substance.pane2.each do |i|
            if i.is_a?(SWin::Window)
              i.registerd_to=[self,1]
            else
              i.container.registerd_to=[self,1]
            end
          end
        else
          @substance = c.klass.new([],[]).initMargin(0,0,0,0)
        end
        @substance.setup(prnt)
        bm1 = SWin::Bitmap.newBitmap(23,23)
        0.upto(self.bmp.width-1) do |i|
          0.upto(self.bmp.height-1) do |j|
            clr = self.bmp[i,j]
            bm1[i,j] = [clr[1],clr[2],clr[0]]
          end
        end
        self.bmp=bm1
      end
      @substance.container = self
      @substance.bevel = VRMarginedFrameUseable::VRMgdTwoPaneFrame::BevelGroove1
      _x,_y,_w,_h= prnt.clientrect
      prnt.sendMessage(WMsg::WM_SIZE,0,MAKELPARAM(_w,_h))
    end
    
  end
  
  module NewFDLayout 
    def getItemsStr(option=nil) "" end
    
    def set_attrs(ar) end
    
    def refreshItems(ar) end
    
    def terminate
      if parent.__regsterd_vr_margined_frame == self.substance
        parent.__regsterd_vr_margined_frame=nil
      end
      @substance._vr_layoutclients.each{|i|
        if i.is_a? SWin::Window then
          i.setMargin(nil,nil,nil,nil)
          i.registerd_to = nil
          i.margined = nil
        end
      }
    end
    
    def createSourceStr
      def self.create_setmargin(lv,name,o)
        "#{lv}  @#{name}.setMargin("+o.mgLeft.inspect+','+o.mgTop.inspect+
                              ','+o.mgRight.inspect+','+o.mgBottom.inspect+")\n"
      end
      make_panes=lambda do |p|
        unless self.substance.is_a? VRGridLayoutFrame
          s=p.map{|i|
            '@'+
            if i.is_a?(SWin::Window)
              i.name
            elsif i.is_a? Array
              if i[0].is_a? SWin::Window
                i[0].name
              else
                i[0].container.name
              end
            else
              i.container.name
            end +','
          }.join("")
        else
          s=p.map{|i|
            '[@' +
            if i.is_a?(SWin::Window)
              i.name+",#{i.x},#{i.y},#{i.w},#{i.h}"
            elsif i.is_a? Array
              if i[0].is_a? SWin::Window
                i[0].name+",#{i[0].x},#{i[0].y},#{i[0].w},#{i[0].h}"
              else
                i[0].container.name + ",#{i[0].parent.x},#{i[0].parent.y}"+
                                      ",#{i[0].parent.w},#{i[0].parent.h}"
              end
            else
              i.container.name + ",#{i.parent.x},#{i.parent.y}"+
                                 ",#{i.parent.w},#{i.parent.h}"
            end  + '],'
            }.join("")
        end
        s[0,s.size-1]
      end
      lv = getLevel(self)
      sb = self.substance
      cnt=sb.class.name.sub /^.*::/,''
      sty = sprintf("%#x",style)
      r =  "#{lv}  \#$_addControl(#{cnt},'#{name}',\"\",#{x},#{y},24,24)\n"
      if parent.__regsterd_vr_margined_frame == sb
        unless sb.is_a? VRGridLayoutFrame
          r += "#{lv}  @#{self.name}=setMarginedFrame(#{cnt})\n"
        else
          r += "#{lv}  @#{self.name}=setMarginedFrame(#{cnt},"+
          "#{sb.instance_eval('@_vr_xsize')},"+
          "#{sb.instance_eval('@_vr_ysize')})\n"
        end
        unless sb._vr_layoutclients.empty?
          r += "#{lv}  @#{self.name}.register(" +
                                  "#{make_panes.call(sb._vr_layoutclients)})\n" 
          r += create_setmargin(lv,self.name,sb)
        end
      else
        if sb.is_a?(VRMarginedFrameUseable::VRMgdGridLayoutFrame)
          r += "#{lv}  @#{self.name}=#{cnt}.new(" +
          "#{sb.instance_eval('@_vr_xsize')}," +
          "#{sb.instance_eval('@_vr_ysize')})\n"
        else
          r += "#{lv}  @#{self.name}=#{cnt}.new\n"
        end
      end
      sb._vr_layoutclients.each do |i|
        if i.is_a? SWin::Window
          r += create_setmargin(lv,i.name,i)
        elsif i.is_a? Array
          if i[0].is_a? SWin::Window
            r += create_setmargin(lv,i[0].name,i[0])
          else
            r += create_setmargin(lv,i[0].container.name,i[0])
          end
        else
          r += create_setmargin(lv,i.container.name,i)
        end
      end
      r
      end
    
    def createMthodStr(s)
      str = s.sub /\(.*$/ , ''
      "#{str}"
    end
    
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,items,c)
      prnt.addHandler(WMsg::WM_SIZE,'vrmgresize', MSGTYPE::ARGLINTINT, nil)
      prnt.addEvent WMsg::WM_SIZE
      c.klass.module_eval("attr_accessor :_vr_layoutclients, :container")
      first = nil
      first = items.pop if items.is_a?(Array) && items.last == true
      if first || (!items && !prnt.__regsterd_vr_margined_frame)
        if items
          if c.klass == VRMarginedFrameUseable::VRMgdGridLayoutFrame
            @substance = prnt.setMarginedFrame(c.klass,prnt.w,prnt.h)
          else
            @substance = prnt.setMarginedFrame(c.klass,
            items.map{|i|
              (j= prnt.instance_eval(i)).is_a?(FDContainer)? j.substance : j})
          end
        else
          if c.klass == VRMarginedFrameUseable::VRMgdGridLayoutFrame
            @substance = prnt.setMarginedFrame(c.klass,prnt.w,prnt.h)
          else
            @substance = prnt.setMarginedFrame(c.klass)
          end
        end
      else
        if items
          if c.klass <= VRGridLayoutFrame
            @substance = c.klass.new(prnt.w,prnt.h).initMargin(0,0,0,0)
          else
            @substance = c.klass.new.initMargin(0,0,0,0)
          end
        else
          if c.klass <= VRGridLayoutFrame
            @substance = c.klass.new(prnt.w,prnt.h).initMargin(0,0,0,0)
          else
            @substance = c.klass.new.initMargin(0,0,0,0)
          end
        end
        bm1 = SWin::Bitmap.newBitmap(23,23)
        0.upto(self.bmp.width-1) do |i|
          0.upto(self.bmp.height-1) do |j|
            clr = self.bmp[i,j]
            bm1[i,j] = [clr[1],clr[2],clr[0]]
          end
        end
        self.bmp=bm1
      end
      @substance.container = self
      _x,_y,_w,_h= prnt.clientrect
      prnt.sendMessage(WMsg::WM_SIZE,0,MAKELPARAM(_w,_h))
    end
  end
  
  module NewFDModule
    def getItemsStr(option=nil) "" end
    
    def set_attrs(a) end #do nothing
    
    def refreshItems(ar) end #do nothing
    
    def terminate() end #do nothing
    
    def createSourceStr
      cnt=self.substance.class.name.sub /^.*::/,''
      sty = sprintf("%#x", style)
      r =  "    \#$_addControl(#{cnt},'#{name}',\"\",#{x},#{y},24,24)\n"
      r
    end
    
    def createMthodStr(s)
      str = s.sub /\(.*$/ , ''
      "#{str}"
    end
    def post_created(prnt,cnt,name,caption,x,y,w,h,addstyle,items,c)
      @substance = c.klass.new 
    end
  end
end

class FDContainer < VRBitmapPanel
  include VRResizeable
  attr_accessor :substance, :items
  undef :addControl
  
  def construct() self.top; end
  
  def self_resize(x,y) self.move(self.x, self.y, 24, 24); end

  def self_destroy() self.terminate if defined? self.terminate; end
end

=begin
module IgnoreFormDesigner
  attr_accessor :ignore_formdesigner
  
  def self.extended(c)
    return if $__running__
#    c.extend FDDraggable
#    c.draggable_init
    c.ignore_formdesigner = true
  end
end

class FDCoverpanel1 < VRPanel
  undef :addControl
  attr_accessor :substance
  
  def vrinit
    super
    extend IgnoreFormDesigner
  end
end

class FDDummyPanel < VRPanel
  undef :addControl
  def vrinit
    super
    extend IgnoreFormDesigner
  end
end
=end