#r fdresources.rb
# Bitmaps of pallets
#
# Programmed by yukimi_sake@mbi.nifty.com
# Copyright 2001-2003 Yukio Sakaue

require 'vr/vrcontrol'
require 'vr/vrcomctl'

module FDBmps
BmpNoselect = "
BAV1OhFTV2luOjpCaXRtYXACigFCTYoBAAAAAAAAdgAAACgAAAAXAAAAFwAA
AAEABAAAAAAAFAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACAAACAAAAAgIAA
gAAAAIAAgACAgAAAgICAAMDAwAAAAP8AAP8AAAD//wD/AAAA/wD/AP//AAD/
//8AZmZmZmZmZmZmZmZgZmZmZmZmZmZmZmZgZmZmZmZmZmZmZmZgZmZmZmZm
ZmZgZmZgZmZmZmZmZmYPBmZgZmZmZmZmZmD/8GZgZmZmZmZmZg//BmZgZmZm
ZmZmYP/wZmZgZmZmZgZmD/8GZmZgZmZmZgBg//BmZmZgZmZmYP8P/wZmZmZg
ZmZmYP//8GZmZmZgZmZmD///BmZmZmZgZmZmD///8GZmZmZgZmZg////8AZm
ZmZgZmZg///wBmZmZmZgZmYP//AGZmZmZmZgZmYP8AZmZmZmZmZgZmDwBmZm
ZmZmZmZgZmAGZmZmZmZmZmZgZmZmZmZmZmZmZmZgZmZmZmZmZmZmZmZgZmZm
ZmZmZmZmZmZg
"
=begin
BmpBitmapPanel = "
eJxljjEOwjAMRVPUgbGRkJgqVs7QsTsTAzNjBxADMHfuDTpxlR4hPYDlM3Ts
EJnvJFAkvuPk6duJk68flT2emmtV1c39cr6tuqw+dJkJeiL3yG3KzOTB36T6
v9qwTNvGQ0MtbMMwwJGwjEg8NNTCxiNT1Fh4Jh/ZFh6KtnXB1zZLjhVQGkty
JGhhtcHpEVq4/DDLlJgx0uKSBwNlJ8Tsgj2B1Qf3ViT0s8xo0SnaPyMi8w/j
av9aWEUL+/RORKY0V7+gf9AKJf8r9wZVYAi0
"
BmpButton = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEkhmJ8DsZ0tI+9EB
BQPI/g8DZPgFiQ0AAQGY7w==
"
BmpCanvasPanel = "
eJx1kDEOgjAUhothUELSmJh4Bc/AyO7k4OzIoHFQZ2ZuUCbWvnAIDuBhumJI
6v8eRUOMf/va739t2r7Gy3u2PhyLS5blxe18ui6qKN9XkRI9EDvENkSkYslv
wvqvSumqLMeJG6cwdF2HjJeuvB8nbpxi/5XjYXiKmF0q6wPY6UE2M2vP7DUY
TtjNuV8Zaq0x3qdgopassKuZyfCZjoTtH6YPh/e8EhLh4jk3gfGCfmQrTMnI
Glw3bAyKcb0hGMt1g2GUMlPt0z+8AbnV9UA=
"
BmpCheckbox = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEohk/weDbyB2QgcY
YGM3ILEZOODsBg4GOJsByIOyQaoZkM3hIGQ+djYkOIj3C1Y2ADm0ltI=
"
BmpColorDlg = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLAOWP
8EEwKmgAI4aGBggFgiAhIHHgwAGgyH8wYvj/H0KBIEgISKQhQAIKG242W0Ia
R0cHP0gDOWxkc/jeveM5c4b37l0y2MjmcM6cyb17N9eqVWSwkc3B4XcAKnx+
lA==
"
BmpCombobox = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BElDZMLPZgGz+/xAA
Zn8AC/9HF2dxgQAw2x8s7IIuTow5RKhhQHIbVJijA4nNAWKDFfBjqEHWi8Pv
AM+6kB8=
"
BmpEdCombo = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgYcAPGsCI
oaEBQoEgkHHgwAEgDRL5D0YM//9DKBAECQGJNARIQGXDzGYDsvn/QwCY/QEs
/B9dnMUFAsBsf7CwC7o4MeYQoYYByW1QYfZyEPvDfxBiZ0ewMdQg68XhdwAD
z5HT
"
BmpEdit = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEkhlJyAckJDwHwY+
ANkMDB8Y+P8z8APZH/5/gCIEG6YGzkZSA9IF0wsyDW4mbjbcXiT3UOIvAHUl
sxI=
"
BmpFolder = "
eJxj4Si1EgwOz8yzsnLKLMlNLGCaxujkO42RAQzKgFgDiCWgmJGBhQE/aAAj
hoYGCAWCQMaBAweANEjkPxgx/P8PoUAQJAQk0jBBAlAJG4y9e/duNHYCGGAR
x1APMQcqvgFhAcT0BCxW4xYHGcYANTMB6PAPULsS/n/Azv7AwPAB6k5salDM
2QA3Pw3ucygAADeymEc=
"
BmpFontDlg = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEqjFBnISGBLS2BjY
wGw2IMGWkAZjs8HYCSAJKBtmSEICA1AXjI0sjsEG6U0AqWcAWQcEVHM/AHf3
gNg=
"
BmpFullsize = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgYcAPGsCI
oaEBQoEgSAhIHDhwACjyH4wY/v+HUCAIEgISaQiQkACUA9FACo3NBlEBEYco
BrHZIBIMbCB2AkR9GoidBmYDqQRk86nFRjYf1V4k9yC7E9X9WP2IbD4A751t
2Q==
"
BmpGridFrame = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgYcAPGsCI
oaEBQoEgSAhIHDhwACjyH4wY/v+HUCAIEgISaQiQkF9eXv69vLweSCXkp6Wl
f0tLqwdSpLOBBtf///8dSA16M6EgATkcAKjRqG8=
"
BmpGroupbox = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BElDY+f+h4FtCWkU5
FADZ9R0Q0D7Y2S5A4IHE9v///weQXQ5iuwP9AvIviO2G4XcAzuupFA==
"
BmpHoriz2Pane = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgYcAPGsCI
oaEBQoEgSAhIHDhwACjyH4wY/v+HUCAIEgISaQiQACYZ2MhkJ4DZUAaEDeIm
QNkMQDYDjM2WkIBwfAKyT5DFkdWjmINsPoq9lLgfEQ4AwLpn9w==
"
BmpHorizFrame = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgYcAPGsCI
oaEBQoEgSAhIHDhwACjyH4wY/v+HUCAIEgISaQiQkF9eXv69vLweSCXkp6Wl
f0tLqwdSw5f9Hw4SkMMBALrTndM=
"
BmpListbox = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BElDYcLPZEtL4/4MB
RwcSmwPE/sAAMRy7Gog4RA2KXhCbxQUMIGx/kLALhjiKmZjmYNqLxT0caGqQ
/YXD7wD2X5B5
"
BmpListview = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEtL+w8A3NPaZM+eB
+Mx5dPFBrAYULPwggi0h7UdHRwc/EHegsUFK+UEEkI0UDgBj1ukw
"
BmpMenu = "
eJxj4Si1EgwOz8yzsnLKLMlNLGCaxujkO42RAQzKgFgDiCWgmJGBhQE/aAAj
hoYGCAWCQMaBAweANEjkPxgx/P8PoUAQJAQk0nCDjA4QaAOz88tBAAu7gJ2h
gB2L+BkQgLIP8DAc4MEiTow5yOz/IPAtLa0DCZSXV3wHqugHq0NiFzBUfAea
2A80txyXmv9IAFcgAACuwKWh
"
BmpMmedia = "
eJxj4Si1EgwOz8yzsnLKLMlNLGCaxujkO42RAQzKgFgDiCWgmJGBhQE/aAAj
hoYGCAWCQMaBAweANEjkPxgx/P8PoUAQJAQk0nCAjo6Otg4o+3t5edv3NiR2
RRuCXQ7hQNjlFUjs8g4kNogDZwM5CDaYhrErkNj1SOxvCPZ/hN7/CDPrEXbV
f4OzwUwIG8KEsCHMNKD/v/3HFQBQAACwzLSM
"
BmpOpenDlg = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEkhmw6wHsZmNwcAA
LA5hG7OhsbnhitDYG2CKQGyooSD2bjDYADITlQ1VwQBis0GcA2QnQL2TkAB3
ZwIb6f4CAL3RdgA=
"
BmpPanel = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BElDY+f+h4FtCWkU5
FADZ9R0Q0D6U2FCv/ACyYV4pR/MvEhsA5BKvpA==
"
BmpPopupMenu = "
eJxj4Si1EgwOz8yzsnLKLMlNLGCaxujkO42RAQzKgFgDiCWgmJGBhQE/aAAj
hoYGCAWCQMaBAweANEjkPxgx/P8PoUAQJAQk0vCDDiBog7K/l5eXo7IzQNId
3xkK2NvS8stBACIOYf85c+YMkF3ADpT/w3CAB00cWT1YDXZzClDUAJ38/xtU
HOIWiHooG6wGQ3z3fmQ1/yFmgMC2bXCPZqch2NuQ2ADofKJD
"
BmpPrinter = "
eJxj4Si1EgwOz8yzsnLKLMlNLGCaxujkO42RAQzKgFgDiCWgmJGBhQE/aAAj
hoYGCAWCQMaBAweANEjkPxgx/P8PoUAQJAQk0ogACWeAAGIRW8aJjo6eDjBo
Q7BntmWA1MDYHXDQll4OB3jY9f/BAMhOQ7DLgOwPIEuhbIR4Wj6EDXZdPkQN
xKkQ8W9padm7EWyQOEgRP4idnY3QvA2JnZaN1e8Av0+22Q==
"
BmpProgressbar = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEmjB5v8PBx94Tpzp
OXGmAwRIZiN59gOt3QwAeYyYnQ==
"
BmpRadiobutton = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEihm//8GZzN09H+D
shM6Ojr64WwGDhibA+jEjm/42SD1DUjmNCDMb2CD28vARh33Q9kACS+IeA==
"
BmpRebar = "
eJxj4Si1EgwOz8yzsnLKLMlNLGCaxujkO42RAQzKgFgDiCWgmJGBhQE/aAAj
hoYGCAWCQMaBAweANEjkPxgx/P8PoUAQJAQk0kgEyLZ+ryiHg+/f24EkWJgd
zK4HCw8A+z8IlCO77T8SINW/AKANpdA=
"
BmpRichedit = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUIgPgJ8QGHDzeb/8J8fIvhz
PoI9cyac/XM+Mvs/VnEk9QwIc8AkGpvn//8/KGyQE0Fqzpw5D3YhiH3+/3kG
JPZ/GPvPn/9Y2VAlIDayv3D4HQDBB+2t
"
BmpSaveDlg = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEnCzE6D2gNjMIMZ/
ZgMgO8EYH5sByoYA/Gxk9RwdQEAJG+xOKJv/A4jNgOR+wv4FAO2Jbyk=
"
BmpStatic = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEihis6WxJTCwpSUw
QNkwCpnNwABlI6sBEglABNQLZyOLY7CB2oAkChtmL5X8AgAdxHu2
"
BmpStatusbar = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEnCxkW3qQACG/z+A
Jvxv/1Hf3sHQ8aMCKARk/qiAsvuBEjBxsASM3Y9QA5KAqwFJwNkdSGo6+hFq
gBI42eU/yqHgB6o7EQCnH5HZAGmVp/s=
"
BmpTabControl = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEnCxExAWJeR3wEDD
YGH/h4APQHbDjw7+jgaQm5HZaf+/5f8HEvj8iMwGAHNOnv4=
"
BmpTabbedPanel = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEnCxExAWJeR3wEAD
kF0OARVAdv9/CPgOYldAlFDMRjK/A2r+jwY0N8AkPgDZDT86+DsaQG5GZqf9
/5b/H0jg8yMyGwCT/KfD
"
BmpText = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEpDZCQjDExLA2vn/
8///kJDw4f8HIEJi/0ewgcow1ED0fmAAs/+DlEPFkdkMDB+A5gOVwfSCEIIN
UwNnI6kBGw7V+x9q6H88bCR/4fI7ACzzxAo=
"
BmpToolbar = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEkhlI7ugAwT4wSTI
agYgG+wU7t27d3PwdzAwfDCAshsMGBjgbGNjYzT2BgYGuJoNIDMbDDoaDBoa
OBBsiF0NYI8j2/sfAT5Q4i8AOtKFZg==
"
BmpTooltip = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEkhlJyAckJAANKx6
O5D4/wGNfeZ/+ffz//+ch7CrtxNmf6+uh7P/f98OZYMAUOI/nL0dzAZbz70B
5Ia0tPTdZWnV2yHuTN9dXg5jp1Xv3g2UgrDTd+/eDvdLeXkZhr8Aaa+2Fw==
"
BmpTrackbar = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEpDZOWlwSBQb1ZwE
JPYPNjg7v6MBzv7R0cFGgP0fyOb/DwYfGIBsmG+J0ZsG1PQNi7+IYQMAszmR
8g==
"
BmpTreeview = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0KQKbA2Ny7d0PYCQwM
CDayOJL6BFQSWZxcc4BCbDA2UC2EDTEDykYWR1KfAPMBSDVYDMyGqsXLRlYP
ANl8eTo=
"
BmpUpdown = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgAYuLQOUx
QQMYMTQ0QCgQBAkBiQMHDgBF/oMRw///EAoEQUJAIg0BEtDYYJPZIOwfHUCA
ld2AxGbggLOB1mNXj539HwTYkOxNI14vql1IbkBxGx570f0OAC20kdw=
"
BmpVert2Pane = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgYcAPGsCI
oaEBQoEgSAhIHDhwACjyH4wY/v+HUCAIEgISaSCQgEQysMHZCQwMcDZQGxuU
nQCyEcoG286GRS8hdgLC8TjZpJqJ5h5kdyK7H8VfKOZASQAiJWir
"
BmpVertFrame = "
eJxj4Si1EgwOz8yzsnLKLMlNLGDqYnTy7WJkAIMyINYAYnEoZmRgYcAPGsCI
oaEBQoEgSAhIHDhwACjyH4wY/v+HUCAIEgISaQiQkF8OBwn5cOF00tn/YeD7
EDHzfwJyOAAAtD2d4Q==
"
=end
end

module FDFakeClass
  class FDPopup
  end
  
  class FDOpenDlg
    attr_accessor :filters, :flags, :title, :defaultExt
  end
  
  class FDSaveDlg
    attr_accessor :filters, :flags, :title, :defaultExt
  end
  
  class FDFontDlg
  end
  
  class FDColorDlg
  end
  
  class FDSelectDir
    attr_accessor :flags, :title, :initialdir
  end
  
  class FDLayout
    attr_accessor :register,:position
  end
end

module FDComDlgItems

  OpenFileFlag = {
    "OFN_ALLOWMULTISELECT" => 512,
    "OFN_CREATEPROMPT" => 0x2000,
#    "OFN_ENABLEHOOK" => 32,
#    "OFN_ENABLETEMPLATE" => 64,
#    "OFN_ENABLETEMPLATEHANDLE" => 128,
    "OFN_EXPLORER" => 0x80000,
    "OFN_EXTENSIONDIFFERENT" => 0x400,
    "OFN_FILEMUSTEXIST" => 0x1000,
    "OFN_HIDEREADONLY" => 4,
    "OFN_LONGNAMES" => 0x200000,
    "OFN_NOCHANGEDIR" => 8,
    "OFN_NODEREFERENCELINKS" => 0x100000,
    "OFN_NOLONGNAMES" => 0x40000,
    "OFN_NONETWORKBUTTON" => 0x20000,
#    "OFN_NOREADONLYRETURN" => 0x8000,
#    "OFN_NOTESTFILECREATE" => 0x10000,
#    "OFN_NOVALIDATE" => 256,
#    "OFN_OVERWRITEPROMPT" => 2,
    "OFN_PATHMUSTEXIST" => 0x800,
    "OFN_READONLY" => 1,
 #   "OFN_SHAREAWARE" => 0x4000,
    "OFN_SHOWHELP" => 16,
 #   "OFN_SHAREFALLTHROUGH" => 2,
 #   "OFN_SHARENOWARN" => 1,
 #   "OFN_SHAREWARN" => 0,
 #   "OFN_NODEREFERENCELINKS" => 0x100000
  }
  
  SaveFileFlag = {
#    "OFN_ALLOWMULTISELECT" => 512,
    "OFN_CREATEPROMPT" => 0x2000,
#    "OFN_ENABLEHOOK" => 32,
#    "OFN_ENABLETEMPLATE" => 64,
#    "OFN_ENABLETEMPLATEHANDLE" => 128,
    "OFN_EXPLORER" => 0x80000,
    "OFN_EXTENSIONDIFFERENT" => 0x400,
#    "OFN_FILEMUSTEXIST" => 0x1000,
    "OFN_HIDEREADONLY" => 4,
    "OFN_LONGNAMES" => 0x200000,
    "OFN_NOCHANGEDIR" => 8,
    "OFN_NODEREFERENCELINKS" => 0x100000,
    "OFN_NOLONGNAMES" => 0x40000,
    "OFN_NONETWORKBUTTON" => 0x20000,
    "OFN_NOREADONLYRETURN" => 0x8000,
    "OFN_NOTESTFILECREATE" => 0x10000,
    "OFN_NOVALIDATE" => 256,
    "OFN_OVERWRITEPROMPT" => 2,
    "OFN_PATHMUSTEXIST" => 0x800,
    "OFN_READONLY" => 1,
#    "OFN_SHAREAWARE" => 0x4000,
    "OFN_SHOWHELP" => 16,
#    "OFN_SHAREFALLTHROUGH" => 2,
#    "OFN_SHARENOWARN" => 1,
#    "OFN_SHAREWARN" => 0,
#    "OFN_NODEREFERENCELINKS" => 0x100000
  }
  BrowseFolderFlag = {
    "BIF_RETURNONLYFSDIRS"=>1,
    "BIF_DONTGOBELOWDOMAIN"=>2,
    "BIF_STATUSTEXT"=>4,
    "BIF_RETURNFSANCESTORS"=>8,
    "BIF_EDITBOX"=>16,
    "BIF_VALIDATE"=>32,
    "BIF_NEWDIALOGSTYLE"=>64,
    "BIF_BROWSEINCLUDEURLS"=>128,
    "BIF_USENEWUI"=>80,
    "BIF_BROWSEFORCOMPUTER"=>0x1000,
    "BIF_BROWSEFORPRINTER"=>0x2000,
    "BIF_BROWSEINCLUDEFILES"=>0x4000,
    "BIF_SHAREABLE"=>0x8000
  }

end

module OwnerDrawBtnBmp

BmpDN = SWin::Bitmap.loadString(
'
BAh1OhFTV2luOjpCaXRtYXAB7kJN7gAAAAAAAAB2AAAAKAAAAA8AAAAPAAAA
AQAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAAIAAAACAgACA
AAAAgACAAICAAADOzs4AgICAAAAA/wAA/wAAAP//AP8AAAD/AP8A//8AAP//
/wB3d3d3d3d3cHd3d3d3d3dwd3d3d3d3d3B3d3dwd3d3cHd3dwAHd3dwd3dw
AAB3d3B3dwAAAAd3cHdwAAAAAHdwdwAAAAAAB3BwAAAAAAAAcAAAAAAAAAAA
d3d3d3d3d3B3d3d3d3d3cHd3d3d3d3dwd3d3d3d3d3A=
')

BmpUP = SWin::Bitmap.loadString(
'
BAh1OhFTV2luOjpCaXRtYXAB7kJN7gAAAAAAAAB2AAAAKAAAAA8AAAAPAAAA
AQAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAAIAAAACAgACA
AAAAgACAAICAAADOzs4AgICAAAAA/wAA/wAAAP//AP8AAAD/AP8A//8AAP//
/wB3d3d3d3d3cHd3d3d3d3dwd3d3d3d3d3B3d3d3d3d3cAAAAAAAAAAAcAAA
AAAAAHB3AAAAAAAHcHdwAAAAAHdwd3cAAAAHd3B3d3AAAHd3cHd3dwAHd3dw
d3d3cHd3d3B3d3d3d3d3cHd3d3d3d3dwd3d3d3d3d3A=
')

end

module FDHelp
  HH_hash={"VRForm"=>0x1000,
"VRLayoutManager"=>0x1001,
"VRVertLayoutManager"=>0x1002,
"VRHorizLayoutManager"=>0x1003,
"VRGridLayoutManager"=>0x1004,
"VRDropFileTarget"=>0x1005,
"VRVertTwoPane"=>0x1006,
"VRHorizTwoPane"=>0x1007,
"VRDrawable"=>0x1008,
"VRMenuUseable"=>0x1009,
"VRCommonDialog"=>0x100a,
"VRMediaViewModeNotifier"=>0x100b,
"VRButton"=>0x100c,
"VRCheckbox"=>0x100d,
"VRRadiobutton"=>0x100e,
"VRGroupbox"=>0x100f,
"VRStatic"=>0x1010,
"VREdit"=>0x1011,
"VRText"=>0x1012,
"VRListbox"=>0x1013,
"VRCombobox"=>0x1014,
"VREditCombobox"=>0x1015,
"VRRichedit"=>0x1016,
"VRListview"=>0x1017,
"VRTreeview"=>0x1018,
"VRProgressbar"=>0x1019,
"VRTrackbar"=>0x101a,
"VRUpdown"=>0x101b,
"VRStatusbar"=>0x101c,
"VRTabControl"=>0x101d,
"VRTabbedPanel"=>0x101e,
"VRRebar"=>0x101f,
"VRToolbar"=>0x1020,
"VRPanel"=>0x1021,
"VRBitmapPanel"=>0x1022,
"VRCanvasPanel"=>0x1023,
"VRMediaView"=>0x1024,
"VRMenu"=>0x1025,
"VRMenuItem"=>0x1026,
"VRWinComponent"=>0x1027,
"VRMessageHandler"=>0x1028,
"VRParent"=>0x1029,
"VRStdControlContainer"=>0x102a,
"VRComCtlContainer"=>0x102b,
"VRScreen"=>0x102c}
end

module FDSources
  BeginOfFD="##__BEGIN_OF_FORMDESIGNER__\n"
  Caution="## CAUTION!! ## This code was automagically ;-) created by "<<
  "FormDesigner.\n## NEVER modify manualy -- otherwise, you'll have a "<<
  "terrible experience.\n\n"
  EndOfFD="##__END_OF_FORMDESIGNER__\n"
  TagOfFD="##__BY_FDVR"
  Follows=<<EEOOSS
## Now,you can describe freely in subsequent lines.
## But be carefully to change the line tagged  "#{TagOfFD}".

EEOOSS

  StartOfForm="VRLocalScreen.start "
  StartOfModeless="VRLocalScreen.modelessform(nil,WStyle::WS_OVERLAPPEDWINDOW,"
  StartOfMdlsDlg="VRLocalScreen.modelessform(nil,nil,"
  StartOfModeless2=").show\nVRLocalScreen.messageloop"
end

module FDMsg
end

begin
  require 'zlib'
  ZlibUseable = true
rescue
  ZlibUseable = false
end

class SWin::Bitmap
  def self.loadStringZ(str)
    Marshal.load(Zlib::Inflate.inflate(str.unpack('m')[0]))
  end
  
  def dumpStringZ
    [Zlib::Deflate.deflate(Marshal.dump(self))].pack('m')
  end
end
