#Win32API

require 'Win32API'

module ToWin32Functions
  def self.to_win32_functions(mod, ar)
    a = mod.module_eval("Array.new")
    ar.each_with_index do |v,i|
      a << Win32API.new(*v)
      pr = lambda{|*args|a[i].call(*args)}
      s = v[1]
      s[0,1] = s[0,1].downcase
      mod.module_eval("define_method(s, pr)")
      mod.module_eval("module_function :#{s}")
    end
  end
end

module User32
  Point = Struct.new(:x, :y)
  Rect  = Struct.new(:l, :t, :r, :b)
  
  WS_EX_TRANSPARENT = 32
  WS_EX_TOPMOST     = 8
  
  GetDC = Win32API.new('User32', 'GetDC', 'L', 'L')
  IsWindow = Win32API.new('user32','IsWindow','L','L')
  GetForegroundWindow = Win32API.new('user32','GetForegroundWindow','V','L')
  SetForegroundWindow = Win32API.new('user32','SetForegroundWindow','L','L')
  SetActiveWindow = Win32API.new('user32','SetActiveWindow','L','L')
  DestroyWindow = Win32API.new('user32','DestroyWindow','L','L')
  SendDlgItemMessage=Win32API.new('user32','SendDlgItemMessage','LLLLL','L')
  SendDlgItemMessage2=Win32API.new('user32','SendDlgItemMessage','LLLLP','L')
  DrawFrameControl=Win32API.new('user32','DrawFrameControl','LPII','I')
  SetWindowPos = Win32API.new('user32','SetWindowPos','LLLLLLL','L')
  ScreenToClient = Win32API.new('user32','ScreenToClient','LP','L')
  ClientToScreen = Win32API.new('user32','ClientToScreen','LP','L')
  SetParent = Win32API.new('user32','SetParent','LL','L') # child, new parent
  
  def screen_to_client(obj, x, y)
    pos = [x, y].pack('LL')
    ScreenToClient.call(obj.hWnd, pos)
    _x, _y = pos.unpack('LL')
    [_x>=0x80000000 ? _x-0x100000000 : _x, _y>=0x80000000 ? _y-0x100000000 : _y]
  end
  
  def client_to_screen(obj, x, y)
    pos = [x, y].pack('LL')
    ClientToScreen.call(obj.hWnd,pos)
    pos.unpack('LL')
  end

  ToWin32Functions.to_win32_functions self, [
    ['user32', 'GetDC', 'L', 'L'],
    ['user32', 'IsWindow','L','L'],
    ['user32', 'GetForegroundWindow','V','L'],
    ['user32', 'SetForegroundWindow','L','L'],
    ['user32', 'SetActiveWindow','L','L'],
    ['user32', 'DestroyWindow','L','L'],
    ['user32', 'SendDlgItemMessage','LLLLL','L'],
    ['user32', 'SendDlgItemMessage','LLLLP','L'],
    ['user32', 'DrawFrameControl','LPII','I'],
    ['user32', 'SetWindowPos','LLLLLLL','L'],
    ['user32', 'ScreenToClient','LP','L'],
    ['user32', 'SetWindowRgn','LLI','L'],
    ['user32', 'AdjustWindowRect','PLL','L'],
    ['user32', 'GetSystemMetrics','L','L'],
    ['user32', 'ClientToScreen','LP','L'],
    ['user32','SetParent','LL','L'],
    ['user32','InvalidateRect','LPL','L']
  ]
end

module GDI32
  R2_COPYPEN   = 13
  R2_NOTXORPEN = 10

  GetTextFace=Win32API.new('GDI32','GetTextFace','LLP','L')
  CreateRectRgn = Win32API.new('GDI32','CreateRectRgn','LLLL','L')
  SelectClipRgn = Win32API.new('GDI32','SelectClipRgn','LL','L')
  CreatePen = Win32API.new('GDI32', 'CreatePen', 'LLL', 'L')
  CreateBrush = Win32API.new('GDI32', 'CreateSolidBrush', 'L', 'L')
  SelectObject = Win32API.new('GDI32', 'SelectObject', 'LL', 'L')
  DeleteObject = Win32API.new('GDI32', 'DeleteObject', 'L', 'L')
  SetROP2 = Win32API.new('GDI32','SetROP2','LL','L')
  MoveTo = Win32API.new('GDI32', 'MoveToEx', 'LLLP', 'V')
  LineTo = Win32API.new('GDI32', 'LineTo', 'LLL', 'V')
  Rectangle = Win32API.new('GDI32', 'Rectangle', 'LLLLL', 'V')
  SetBkMode = Win32API.new("GDI32", "SetBkMode", ['L']*2, 'L')
  TextOut = Win32API.new("GDI32","TextOut",['L','L','L','P','L'],'L')
  ToWin32Functions.to_win32_functions self, [
    ['GDI32', 'GetTextFace','LLP','L'],
    ['GDI32', 'CreateRectRgn','LLLL','L'],
    ['GDI32', 'SelectClipRgn','LL','L'],
    ['GDI32', 'CreatePen', 'LLL', 'L'],
    ['GDI32', 'CreateSolidBrush', 'L', 'L'],
    ['GDI32', 'SelectObject', 'LL', 'L'],
    ['GDI32', 'DeleteObject', 'L', 'L'],
    ['GDI32', 'SetROP2','LL','L'],
    ['GDI32', 'MoveToEx', 'LLLP', 'V'],
    ['GDI32', 'LineTo', 'LLL', 'V'],
    ['GDI32', 'Rectangle', 'LLLLL', 'V'],
    ["GDI32", 'SetBkMode', 'LL', 'L'],
    ["GDI32", 'TextOut','LLLPL','L']
  ]
end

module Kernel32
end

module Shell32
  ShellExecute = Win32API.new('shell32','ShellExecute','LPPPPI','L')
  ToWin32Functions.to_win32_functions self, [
    ['shell32','ShellExecute','LPPPPI','L']
  ]
end


module Hhctrl
  HtmlHelp=Win32API.new('hhctrl.ocx',"HtmlHelpA","LPLP","L")
  ToWin32Functions.to_win32_functions self, [
    ['hhctrl.ocx',"HtmlHelpA","LPLP","L"]
  ]
end
