unit u_DataGenerator1;

{
  Feeding Origin 2 is software that supports calculation of nutrient requirement of livestock
  and feed design based on Japanese feeding standard.
  Copyright (C) 2017,  Syuichiro Fukagawa.

  This program is free software; you can redistribute it and/or modify it under the terms of
  the GNU General Public License as published by the Free Software Foundation; either version 3
  of the License, or (at your option) any later version.
  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  You should have received a copy of the GNU General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.


  Feeding Origin 2は、日本飼養標準に基づいた家畜の養分要求量の計算および飼料設計を支援するソフ
  トウェアです.
  Copyright (C) 2017,　深川修一郎.

  　このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア財団によって
  発行されたGNU一般公衆利用許諾書(バージョン3か、それ以降のバージョンのうちどれか)が定める
  条件の下で再頒布または改変することができます。
  このプログラムは有用であることを願って頒布されますが、*全くの無保証* です。商業可能性の保証
  や特定目的への適合性は、言外に示されたものも含め、全く存在しません。詳しくはGNU一般公衆利用
  許諾書をご覧ください。
  　あなたはこのプログラムと共に、GNU一般公衆利用許諾書のコピーを一部 受け取っているはずです。
  もし受け取っていなければ、<http://www.gnu.org/licenses/> をご覧ください。
  
  *本日本語訳は、FSFより2007年6月29日に発行されたGNU GPL v3の原文から、八田真行氏が翻訳した
   ものを基にしています。 ＜ https://mag.osdn.jp/07/09/02/130237 ＞
}

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, TAGraph, TASeries, Forms, Controls, Graphics,
  Dialogs, ExtCtrls, math, StrUtils, StdCtrls, Grids, ComCtrls, u_feedingcalc2,
  u_CommonModule, u_Marker, TACustomSeries, u_regWorkData;

type
  astG = Array[0..72065] of reGROW ;
  TreGrowOrign = array[0..72577] of reGROW;

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    RegressionCurveOriginAfter: TLineSeries;
    RegressionCurveOriginBefore: TLineSeries;
    CheckBox4: TCheckBox;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    RegressionCurveJFS: TLineSeries;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Origin2BeforeWeaning: TLineSeries;
    Origin2AfterWeaning: TLineSeries;
    JapaneseFeedingStandard: TLineSeries;
    Chart1: TChart;
    CheckBox1: TCheckBox;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    LabeledEdit1: TLabeledEdit;
    LabeledEdit2: TLabeledEdit;
    PageControl1: TPageControl;
    Panel1: TPanel;
    Panel3: TPanel;
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure CheckBox1Change(Sender: TObject);
    procedure CheckBox2Change(Sender: TObject);
    procedure CheckBox3Change(Sender: TObject);
    procedure CheckBox4Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure Check_of_Weight(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LabeledEdit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LabeledEdit2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure GeneralKeyPress(Sender: TObject; var Key: char);
  private
    { private declarations }
  public
    gstG   : astG;
    gOrign : TreGrowOrign;
    giRow4JFS    : Integer;
    giRow4Orign  : Integer;

    procedure ReadData();
    procedure Spread_JFS_Data();
    procedure Spread_Origin2_Data();
    procedure DispHeader_1();
    procedure DispHeader_2();
    procedure SelectData();
    procedure Class_JFS();
    procedure Class_Origin2();
    procedure GraphOutPut();
    procedure GraphDraw4JFS();
    procedure GraphDraw4Origin2(var iKbn : Integer);
    function  NichZotaijuAnbaichi(var dWt : Double) : Double;
  end;

var
  Form1: TForm1;
  gstR  : reNUTRIENT ;
  giSNo, giRow, giOrgSrc  : Integer;

implementation

{$R *.lfm}

procedure TForm1.Check_of_Weight(Sender: TObject);
var
  TE  :  TLabeledEdit ;
  iEN   : Integer;
  dWt, dWrk1   : Double;
begin
  TE  := Sender as TLabeledEdit ;
  iEN := StrToInt(RightStr(TE.Name, 1));
  dWt := StrToFloat(TE.Text);
  if (dWt < 40) or (dWt > 707) then
    begin
      ShowMessage('体重は40kg以上707kg以下を入力します。');
      TE.SetFocus;
      exit;
    end;

  case  iEN  of
    1 :
      begin
        dWrk1 := StrToFloat(LabeledEdit2.Text);
        if dWrk1 <= dWt then
          begin
            ShowMessage('体重(最大)より小さい値を入力してください。');
            TE.SetFocus;
            exit;
          end;
      end;
    2 :
      begin
        dWrk1 := StrToFloat(LabeledEdit1.Text);
        if dWrk1 >= dWt then
          begin
            ShowMessage('体重(最小)より大きい値を入力してください。');
            TE.SetFocus;
            exit;
          end;
      end;
  end;

  SelectData();
  GraphOutPut();
end;

procedure TForm1.FormActivate(Sender: TObject);
begin

end;

procedure TForm1.FormShow(Sender: TObject);
begin
  if not FileExists('IkuseiData.dat') then
  begin
    ShowMessage('データ・ファイルの「IkuseiData.dat」が見つかりません。'+#$0D+#$0A+'プログラムを終了します。');
    close();
  end;

  Application.ProcessMessages;
  ReadData();
  Application.ProcessMessages;
  Spread_JFS_Data();
  Application.ProcessMessages;
  Spread_Origin2_Data();
  Application.ProcessMessages;

  Form1.Cursor:=crDefault;
  Form1.Panel1.Cursor:=crDefault;
  Form1.PageControl1.Cursor:=crDefault;
  Form1.TabSheet3.Cursor:=crDefault;

  Form1.Panel3.Cursor:=crDefault;
  Form1.Chart1.Cursor:=crDefault;

  Form1.Panel1.Enabled:=true;
  Form1.TabSheet3.Enabled:=true ;

  Application.ProcessMessages;

  SelectData();
  GraphOutPut();
end;

procedure TForm1.LabeledEdit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    ComEditKeyDown(Form1, Sender, Key, Shift);
end;

procedure TForm1.GeneralKeyPress(Sender: TObject; var Key: char);
begin
    ComEditKeyPress(Form1, Sender, Key);
end;

procedure TForm1.LabeledEdit2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    ComEditKeyDown(Form1, Sender, Key, Shift);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   SelectData();
   GraphOutPut();
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  m, n, i, iK  :  Integer;
  X, Yxm, Yxn, Yx_1, YxYx_1, Yx2 : Double;
  SigmaYxm, SigmaYxn, SigmaYx_1, SigmaYxYx_1, SigmaYx2 : Double;
  a, b, c : Double;
  Cx, CxYx, C2x : Double;
  SigmaCx, SigmaCxYx, SigmaC2x : Double;
  dWt, dRg : Double;
  dMeanY, SgmaYiFi2, SgmaYiMY2, dR2 : Double;
  sMb : String;
begin
  if giRow4JFS > 0 then
    begin
      n := giRow4JFS ;
      m := n - 1;
      iK := ComboBox2.ItemIndex + 7;
      SigmaYxn    := 0;
      SigmaYxm    := 0;
      SigmaYx_1   := 0;
      SigmaYxYx_1 := 0;
      SigmaYx2    := 0;
      SigmaCx     := 0;
      SigmaCxYx   := 0;
      SigmaC2x    := 0;
      dMeanY      := 0;
      SgmaYiFi2   := 0;
      SgmaYiMY2   := 0;
      for i:=1 to m do
        begin
          Yxm         := StrToFloat(StringGrid1.Cells[iK, i]);
          SigmaYxm    += Yxm;
          Yx_1        := StrToFloat(StringGrid1.Cells[iK, i+1]);
          SigmaYx_1   += Yx_1;
          YxYx_1      := Yxm * Yx_1;
          SigmaYxYx_1 += YxYx_1;
          Yx2         := Power(Yxm, 2);
          SigmaYx2    += Yx2;
        end;
      c := (n*SigmaYxYx_1-SigmaYxm*SigmaYx_1)/(n*SigmaYx2-Power(SigmaYxm,2));
      for i:=1 to n do
        begin
          X   := StrToFloat(StringGrid1.Cells[1, i]);
          Yxn := StrToFloat(StringGrid1.Cells[iK, i]);
          SigmaYxn += Yxn ;
          Cx        := Power(c, X) ;
          SigmaCx   += Cx ;
          CxYx      := Cx * Yxn;
          SigmaCxYx += CxYx;
          C2x       := Power(Cx, 2);
          SigmaC2x  += C2x ;
        end;

      dMeanY := SigmaYxn / n;

      b := (n*SigmaCxYx-SigmaCx*SigmaYxn)/(n*SigmaC2x-Power(SigmaCx,2));
      a := (SigmaYxn/n)-b*(SigmaCx/n);
      if b < 0 then
          sMb := ' - ' + FloatToStrF(abs(b), ffGeneral, 8, 4 ) + ' * '
      else
          sMb := ' + ' + FloatToStrF(b, ffGeneral, 8, 4 ) + ' * ';
      Label7.Caption := 'Y= '+FloatToStrF(a, ffGeneral, 8, 4 )+sMb+FloatToStrF(c, ffGeneral, 8, 4 )+' ^ X ';

      RegressionCurveJFS.Clear;
      for i:=1 to n do
        begin
          dWt := StrToFloat(StringGrid1.Cells[1, i]);
          dRg := a + b * Power(c, dWt);
          RegressionCurveJFS.AddXY(dWt, dRg);
          Yxn := StrToFloat(StringGrid1.Cells[iK, i]);
          SgmaYiFi2 += Power((Yxn - dRg), 2);
          SgmaYiMY2 += Power((Yxn - dMeanY), 2);
        end;
      dR2 := 1.0 - ( SgmaYiFi2 / SgmaYiMY2 );
      Label7.Caption := Label7.Caption + ' ; R2= ' + FloatToStr(dR2);
    end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  NofArticles : Integer;
  n, i, j, iK  :  Integer;
  X, Yxm, Yxn, Yx_1, YxYx_1, Yx2 : Double;
  SigmaYxm, SigmaYxn, SigmaYx_1, SigmaYxYx_1, SigmaYx2 : Double;
  a, b, c : Double;
  Cx, CxYx, C2x : Double;
  SigmaCx, SigmaCxYx, SigmaC2x : Double;
  dWt, dRg : Double;
  dMeanY, SgmaYiFi2, SgmaYiMY2, dR2 : Double;
  sMb : String;
begin
  if giRow4JFS > 0 then
    begin
      n := giRow4Orign ;
      iK := ComboBox2.ItemIndex + 7;
      NofArticles := 0;
      SigmaYxn    := 0;
      SigmaYxm    := 0;
      SigmaYx_1   := 0;
      SigmaYxYx_1 := 0;
      SigmaYx2    := 0;
      SigmaCx     := 0;
      SigmaCxYx   := 0;
      SigmaC2x    := 0;
      dMeanY      := 0;
      SgmaYiFi2   := 0;
      SgmaYiMY2   := 0;
      for i:=1 to 72599 do
        begin
          for j:=0 to 17 do
            begin
                 RegWorkForm.StringGrid3.Cells[ j, i] := '';
            end;
        end;
      for i:=1 to n do
        begin
          if Trim(StringGrid2.Cells[5, i]) = '離乳前' then
            begin
              NofArticles += 1;
              RegWorkForm.StringGrid3.Cells[ 0, NofArticles] := StringGrid2.Cells[ 0, i] ;
              RegWorkForm.StringGrid3.Cells[ 1, NofArticles] := StringGrid2.Cells[ 1, i] ;
              RegWorkForm.StringGrid3.Cells[ 2, NofArticles] := StringGrid2.Cells[ 2, i] ;
              RegWorkForm.StringGrid3.Cells[ 3, NofArticles] := StringGrid2.Cells[ 3, i] ;
              RegWorkForm.StringGrid3.Cells[ 4, NofArticles] := StringGrid2.Cells[ 4, i] ;
              RegWorkForm.StringGrid3.Cells[ 5, NofArticles] := StringGrid2.Cells[ 5, i] ;
              RegWorkForm.StringGrid3.Cells[ 6, NofArticles] := StringGrid2.Cells[ 6, i] ;
              RegWorkForm.StringGrid3.Cells[ 7, NofArticles] := StringGrid2.Cells[ 7, i] ;
              RegWorkForm.StringGrid3.Cells[ 8, NofArticles] := StringGrid2.Cells[ 8, i] ;
              RegWorkForm.StringGrid3.Cells[ 9, NofArticles] := StringGrid2.Cells[ 9, i] ;
              RegWorkForm.StringGrid3.Cells[10, NofArticles] := StringGrid2.Cells[10, i] ;
              RegWorkForm.StringGrid3.Cells[11, NofArticles] := StringGrid2.Cells[11, i] ;
              RegWorkForm.StringGrid3.Cells[12, NofArticles] := StringGrid2.Cells[12, i] ;
              RegWorkForm.StringGrid3.Cells[13, NofArticles] := StringGrid2.Cells[13, i] ;
              RegWorkForm.StringGrid3.Cells[14, NofArticles] := StringGrid2.Cells[14, i] ;
              RegWorkForm.StringGrid3.Cells[15, NofArticles] := StringGrid2.Cells[15, i] ;
              RegWorkForm.StringGrid3.Cells[16, NofArticles] := StringGrid2.Cells[16, i] ;
              RegWorkForm.StringGrid3.Cells[17, NofArticles] := StringGrid2.Cells[17, i] ;
            end;
        end;
      if NofArticles = 0 then exit;
      for i:=1 to (NofArticles-1) do
        begin
              Yxm         := StrToFloat(RegWorkForm.StringGrid3.Cells[iK, i]);
              SigmaYxm    += Yxm;
              Yx_1        := StrToFloat(RegWorkForm.StringGrid3.Cells[iK, i+1]);
              SigmaYx_1   += Yx_1;
              YxYx_1      := Yxm * Yx_1;
              SigmaYxYx_1 += YxYx_1;
              Yx2         := Power(Yxm, 2);
              SigmaYx2    += Yx2;
        end;
      c := (NofArticles*SigmaYxYx_1-SigmaYxm*SigmaYx_1)/(NofArticles*SigmaYx2-Power(SigmaYxm,2));
      for i:=1 to NofArticles do
        begin
              X   := StrToFloat(RegWorkForm.StringGrid3.Cells[1, i]);
              Yxn := StrToFloat(RegWorkForm.StringGrid3.Cells[iK, i]);
              SigmaYxn  += Yxn ;
              Cx        := Power(c, X) ;
              SigmaCx   += Cx ;
              CxYx      := Cx * Yxn;
              SigmaCxYx += CxYx;
              C2x       := Power(Cx, 2);
              SigmaC2x  += C2x ;
        end;

      dMeanY := SigmaYxn / NofArticles;

      b := (NofArticles*SigmaCxYx-SigmaCx*SigmaYxn)/(NofArticles*SigmaC2x-Power(SigmaCx,2));
      a := (SigmaYxn/NofArticles)-b*(SigmaCx/NofArticles);
      if b < 0 then
          sMb := ' - ' + FloatToStrF(abs(b), ffGeneral, 8, 4 ) + ' * '
      else
          sMb := ' + ' + FloatToStrF(b, ffGeneral, 8, 4 ) + ' * ';
      Label8.Caption := 'Y= '+FloatToStrF(a, ffGeneral, 8, 4 )+sMb+FloatToStrF(c, ffGeneral, 8, 4 )+' ^ X ';
      RegressionCurveOriginBefore.Clear;
      for i:=1 to NofArticles do
        begin
              dWt := StrToFloat(RegWorkForm.StringGrid3.Cells[1, i]);
              dRg := a + b * Power(c, dWt);
              RegressionCurveOriginBefore.AddXY(dWt, dRg);
              Yxn := StrToFloat(StringGrid1.Cells[iK, i]);
              SgmaYiFi2 += Power((Yxn - dRg), 2);
              SgmaYiMY2 += Power((Yxn - dMeanY), 2);
        end;
      dR2 := 1.0 - ( SgmaYiFi2 / SgmaYiMY2 );
      Label8.Caption := Label8.Caption + ' ; R2= ' + FloatToStr(dR2);
    end;
end;

procedure TForm1.Button5Click(Sender: TObject);
var
  NofArticles : Integer;
  n, i, j, iK  :  Integer;
  X, Yxm, Yxn, Yx_1, YxYx_1, Yx2 : Double;
  SigmaYxm, SigmaYxn, SigmaYx_1, SigmaYxYx_1, SigmaYx2 : Double;
  a, b, c : Double;
  Cx, CxYx, C2x : Double;
  SigmaCx, SigmaCxYx, SigmaC2x : Double;
  dWt, dRg : Double;
  dMeanY, SgmaYiFi2, SgmaYiMY2, dR2 : Double;
  sMb : String;
begin
  if giRow4JFS > 0 then
    begin
      n := giRow4Orign ;
      iK := ComboBox2.ItemIndex + 7;
      NofArticles := 0;
      SigmaYxn    := 0;
      SigmaYxm    := 0;
      SigmaYx_1   := 0;
      SigmaYxYx_1 := 0;
      SigmaYx2    := 0;
      SigmaCx     := 0;
      SigmaCxYx   := 0;
      SigmaC2x    := 0;
      dMeanY      := 0;
      SgmaYiFi2   := 0;
      SgmaYiMY2   := 0;
      for i:=1 to 72599 do
        begin
          for j:=0 to 17 do
            begin
                 RegWorkForm.StringGrid3.Cells[ j, i] := '';
            end;
        end;
      for i:=1 to n do
        begin
          if Trim(StringGrid2.Cells[5, i]) = '離乳後' then
            begin
              NofArticles += 1;
              RegWorkForm.StringGrid3.Cells[ 0, NofArticles] := StringGrid2.Cells[ 0, i] ;
              RegWorkForm.StringGrid3.Cells[ 1, NofArticles] := StringGrid2.Cells[ 1, i] ;
              RegWorkForm.StringGrid3.Cells[ 2, NofArticles] := StringGrid2.Cells[ 2, i] ;
              RegWorkForm.StringGrid3.Cells[ 3, NofArticles] := StringGrid2.Cells[ 3, i] ;
              RegWorkForm.StringGrid3.Cells[ 4, NofArticles] := StringGrid2.Cells[ 4, i] ;
              RegWorkForm.StringGrid3.Cells[ 5, NofArticles] := StringGrid2.Cells[ 5, i] ;
              RegWorkForm.StringGrid3.Cells[ 6, NofArticles] := StringGrid2.Cells[ 6, i] ;
              RegWorkForm.StringGrid3.Cells[ 7, NofArticles] := StringGrid2.Cells[19, i] ;
              RegWorkForm.StringGrid3.Cells[ 8, NofArticles] := StringGrid2.Cells[20, i] ;
              RegWorkForm.StringGrid3.Cells[ 9, NofArticles] := StringGrid2.Cells[21, i] ;
              RegWorkForm.StringGrid3.Cells[10, NofArticles] := StringGrid2.Cells[22, i] ;
              RegWorkForm.StringGrid3.Cells[11, NofArticles] := StringGrid2.Cells[23, i] ;
              RegWorkForm.StringGrid3.Cells[12, NofArticles] := StringGrid2.Cells[24, i] ;
              RegWorkForm.StringGrid3.Cells[13, NofArticles] := StringGrid2.Cells[25, i] ;
              RegWorkForm.StringGrid3.Cells[14, NofArticles] := StringGrid2.Cells[26, i] ;
              RegWorkForm.StringGrid3.Cells[15, NofArticles] := StringGrid2.Cells[27, i] ;
              RegWorkForm.StringGrid3.Cells[16, NofArticles] := StringGrid2.Cells[28, i] ;
              RegWorkForm.StringGrid3.Cells[17, NofArticles] := StringGrid2.Cells[29, i] ;
            end;
        end;
      for i:=1 to (NofArticles-1) do
        begin
              Yxm         := StrToFloat(RegWorkForm.StringGrid3.Cells[iK, i]);
              SigmaYxm    += Yxm;
              Yx_1        := StrToFloat(RegWorkForm.StringGrid3.Cells[iK, i+1]);
              SigmaYx_1   += Yx_1;
              YxYx_1      := Yxm * Yx_1;
              SigmaYxYx_1 += YxYx_1;
              Yx2         := Power(Yxm, 2);
              SigmaYx2    += Yx2;
        end;
      c := (NofArticles*SigmaYxYx_1-SigmaYxm*SigmaYx_1)/(NofArticles*SigmaYx2-Power(SigmaYxm,2));
      for i:=1 to NofArticles do
        begin
              X   := StrToFloat(RegWorkForm.StringGrid3.Cells[1, i]);
              Yxn := StrToFloat(RegWorkForm.StringGrid3.Cells[iK, i]);
              SigmaYxn += Yxn ;
              Cx        := Power(c, X) ;
              SigmaCx   += Cx ;
              CxYx      := Cx * Yxn;
              SigmaCxYx += CxYx;
              C2x       := Power(Cx, 2);
              SigmaC2x  += C2x ;
        end;

      dMeanY := SigmaYxn / NofArticles;

      b := (NofArticles*SigmaCxYx-SigmaCx*SigmaYxn)/(NofArticles*SigmaC2x-Power(SigmaCx,2));
      a := (SigmaYxn/NofArticles)-b*(SigmaCx/NofArticles);
      if b < 0 then
          sMb := ' - ' + FloatToStrF(abs(b), ffGeneral, 8, 4 ) + ' * '
      else
          sMb := ' + ' + FloatToStrF(b, ffGeneral, 8, 4 ) + ' * ';
      Label9.Caption := 'Y= '+FloatToStrF(a, ffGeneral, 8, 4 )+sMb+FloatToStrF(c, ffGeneral, 8, 4 )+' ^ X ';
      RegressionCurveOriginAfter.Clear;
      for i:=1 to NofArticles do
        begin
              dWt := StrToFloat(RegWorkForm.StringGrid3.Cells[1, i]);
              dRg := a + b * Power(c, dWt);
              RegressionCurveOriginAfter.AddXY(dWt, dRg);
              Yxn := StrToFloat(StringGrid1.Cells[iK, i]);
              SgmaYiFi2 += Power((Yxn - dRg), 2);
              SgmaYiMY2 += Power((Yxn - dMeanY), 2);
        end;
      dR2 := 1.0 - ( SgmaYiFi2 / SgmaYiMY2 );
      Label9.Caption := Label9.Caption + ' ; R2= ' + FloatToStr(dR2);
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  fMarker.Show;
end;

procedure TForm1.CheckBox1Change(Sender: TObject);
begin
    SelectData();
    GraphOutPut();
end;

procedure TForm1.CheckBox2Change(Sender: TObject);
begin
  SelectData();
  GraphOutPut();
end;

procedure TForm1.CheckBox3Change(Sender: TObject);
begin
    SelectData();
    GraphOutPut();
end;

procedure TForm1.CheckBox4Change(Sender: TObject);
begin
    SelectData();
    GraphOutPut();
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
    SelectData();
    GraphOutPut();
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
    SelectData();
    GraphOutPut();
end;

procedure TForm1.ComboBox3Change(Sender: TObject);
begin
    SelectData();
    GraphOutPut();
end;

procedure TForm1.Spread_Origin2_Data();
var
  i, iSN, iPN : Integer ;
  dWeight, dGain : Double;
  sLowest, sSeason  : String;
  stG  : reGROW ;

begin
  DispHeader_2();
  iSN := giSNo;
  iPN := 0;
  for i:=1 to iSN do
    begin
      dWeight := gstG[i].dWt1;
      dGain   := gstG[i].dInWt1;
      sLowest := gstG[i].cLVCP;
      sSeason := gstG[i].cKset;
      Inc(iPN);
      if (dWeight <= 66.00) then
        begin
          StringGrid2.Cells[0, iPN] := IntToStr(iPN);
          StringGrid2.Cells[1, iPN] := FloatToStr(dWeight);
          StringGrid2.Cells[2, iPN] := FloatToStr(dGain);
          StringGrid2.Cells[3, iPN] := sLowest;
          StringGrid2.Cells[4, iPN] := sSeason;
          StringGrid2.Cells[5, iPN] := '離乳前';
          gOrign[iPN].dWt1   := dWeight;
          gOrign[iPN].dInWt1 := dGain;
          gOrign[iPN].cLVCP  := sLowest;
          gOrign[iPN].cKset  := sSeason;
          gOrign[iPN].cWean  := '離乳前';
          stG := gOrign[iPN];
          gOrign[iPN].Nutrient := GrowingCow_A( stG );
          StringGrid2.Cells[ 6, iPN] := FloatToStr(gOrign[iPN].Nutrient.dFCM);
          StringGrid2.Cells[ 7, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDMI);
          StringGrid2.Cells[ 8, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCP);
          StringGrid2.Cells[ 9, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDCP);
          StringGrid2.Cells[10, iPN] := FloatToStr(gOrign[iPN].Nutrient.dTDN);
          StringGrid2.Cells[11, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDE);
          StringGrid2.Cells[12, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEC);
          StringGrid2.Cells[13, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEJ);
          StringGrid2.Cells[14, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCa);
          StringGrid2.Cells[15, iPN] := FloatToStr(gOrign[iPN].Nutrient.dP);
          StringGrid2.Cells[16, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVA);
          StringGrid2.Cells[17, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVD);
        end
      else if (dWeight > 66.00) and (dWeight < 75.00) then
        begin
          StringGrid2.Cells[0, iPN] := IntToStr(iPN);
          StringGrid2.Cells[1, iPN] := FloatToStr(dWeight);
          StringGrid2.Cells[2, iPN] := FloatToStr(dGain);
          StringGrid2.Cells[3, iPN] := sLowest;
          StringGrid2.Cells[4, iPN] := sSeason;
          StringGrid2.Cells[5, iPN] := '離乳前';
          gOrign[iPN].dWt1   := dWeight;
          gOrign[iPN].dInWt1 := dGain;
          gOrign[iPN].cLVCP  := sLowest;
          gOrign[iPN].cKset  := sSeason;
          gOrign[iPN].cWean  := '離乳前';
          stG := gOrign[iPN];
          gOrign[iPN].Nutrient := GrowingCow_A( stG );
          StringGrid2.Cells[ 6, iPN] := FloatToStr(gOrign[iPN].Nutrient.dFCM);
          StringGrid2.Cells[ 7, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDMI);
          StringGrid2.Cells[ 8, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCP);
          StringGrid2.Cells[ 9, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDCP);
          StringGrid2.Cells[10, iPN] := FloatToStr(gOrign[iPN].Nutrient.dTDN);
          StringGrid2.Cells[11, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDE);
          StringGrid2.Cells[12, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEC);
          StringGrid2.Cells[13, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEJ);
          StringGrid2.Cells[14, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCa);
          StringGrid2.Cells[15, iPN] := FloatToStr(gOrign[iPN].Nutrient.dP);
          StringGrid2.Cells[16, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVA);
          StringGrid2.Cells[17, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVD);
          Inc(iPN);
          StringGrid2.Cells[0, iPN] := IntToStr(iPN);
          StringGrid2.Cells[1, iPN] := FloatToStr(dWeight);
          StringGrid2.Cells[2, iPN] := FloatToStr(dGain);
          StringGrid2.Cells[3, iPN] := sLowest;
          StringGrid2.Cells[4, iPN] := sSeason;
          StringGrid2.Cells[5, iPN] := '離乳後';
          gOrign[iPN].dWt1   := dWeight;
          gOrign[iPN].dInWt1 := dGain;
          gOrign[iPN].cLVCP  := sLowest;
          gOrign[iPN].cKset  := sSeason;
          gOrign[iPN].cWean  := '離乳後';
          stG := gOrign[iPN];
          gOrign[iPN].Nutrient := GrowingCow_A( stG );
          StringGrid2.Cells[ 6, iPN] := FloatToStr(gOrign[iPN].Nutrient.dFCM);
          StringGrid2.Cells[ 7, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDMI);
          StringGrid2.Cells[ 8, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCP);
          StringGrid2.Cells[ 9, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDCP);
          StringGrid2.Cells[10, iPN] := FloatToStr(gOrign[iPN].Nutrient.dTDN);
          StringGrid2.Cells[11, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDE);
          StringGrid2.Cells[12, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEC);
          StringGrid2.Cells[13, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEJ);
          StringGrid2.Cells[14, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCa);
          StringGrid2.Cells[15, iPN] := FloatToStr(gOrign[iPN].Nutrient.dP);
          StringGrid2.Cells[16, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVA);
          StringGrid2.Cells[17, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVD);
        end
      else
        begin
          StringGrid2.Cells[0, iPN] := IntToStr(iPN);
          StringGrid2.Cells[1, iPN] := FloatToStr(dWeight);
          StringGrid2.Cells[2, iPN] := FloatToStr(dGain);
          StringGrid2.Cells[3, iPN] := sLowest;
          StringGrid2.Cells[4, iPN] := sSeason;
          StringGrid2.Cells[5, iPN] := '離乳後';
          gOrign[iPN].dWt1   := dWeight;
          gOrign[iPN].dInWt1 := dGain;
          gOrign[iPN].cLVCP  := sLowest;
          gOrign[iPN].cKset  := sSeason;
          gOrign[iPN].cWean  := '離乳後';
          stG := gOrign[iPN];
          gOrign[iPN].Nutrient := GrowingCow_A( stG );
          StringGrid2.Cells[ 6, iPN] := FloatToStr(gOrign[iPN].Nutrient.dFCM);
          StringGrid2.Cells[ 7, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDMI);
          StringGrid2.Cells[ 8, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCP);
          StringGrid2.Cells[ 9, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDCP);
          StringGrid2.Cells[10, iPN] := FloatToStr(gOrign[iPN].Nutrient.dTDN);
          StringGrid2.Cells[11, iPN] := FloatToStr(gOrign[iPN].Nutrient.dDE);
          StringGrid2.Cells[12, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEC);
          StringGrid2.Cells[13, iPN] := FloatToStr(gOrign[iPN].Nutrient.dMEJ);
          StringGrid2.Cells[14, iPN] := FloatToStr(gOrign[iPN].Nutrient.dCa);
          StringGrid2.Cells[15, iPN] := FloatToStr(gOrign[iPN].Nutrient.dP);
          StringGrid2.Cells[16, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVA);
          StringGrid2.Cells[17, iPN] := FloatToStr(gOrign[iPN].Nutrient.dVD);
        end;
    end;
    giOrgSrc := iPN;
end;

procedure TForm1.ReadData();
var
    inf      : TextFile;
    u_String, sWrk, sDat : string;
    iRow, iNo, iP, iL, iT  : Integer ;
    bKomk    : Boolean;
begin
    iRow := 1 ;
    AssignFile(inf,'IkuseiData.dat');
    Reset( inf ) ;
    if IOResult <> 0  then
        begin
          ShowMessage('ファイルアクセスエラー');
          exit;
        end;
    bKomk := False;
    while not Eof( inf ) do
      begin
        ReadLn( inf, u_String );
        if bKomk then
          begin
            iNo := 1 ;
            iP  := 1 ;
            iL  := Length(u_String);
            Repeat
              iT   := PosEx( '	', u_String, iP ) ;
              sWrk := MidStr(u_String, iP , (iT-iP) );
              iP   := iT + 1 ;
              sDat := UTF8Encode( sWrk ) ;
              case  iNo  of
                 1 : gstG[iRow].dWt1	 := StrToFloat( sDat ) ;
     	           2 : gstG[iRow].dInWt1	 := StrToFloat( sDat ) ;
     	           3 : gstG[iRow].cLVCP	 := sDat  ;
     	           4 : gstG[iRow].cKset	 := sDat  ;
                 5 : gstG[iRow].Nutrient.dFCM := StrToFloat( sDat ) ;
                 6 : gstG[iRow].Nutrient.dDMI := StrToFloat( sDat ) ;
                 7 : gstG[iRow].Nutrient.dCP  := StrToFloat( sDat ) ;
                 8 : gstG[iRow].Nutrient.dDCP := StrToFloat( sDat ) ;
                 9 : gstG[iRow].Nutrient.dTDN := StrToFloat( sDat ) ;
                10 : gstG[iRow].Nutrient.dDE  := StrToFloat( sDat ) ;
                11 : gstG[iRow].Nutrient.dMEC := StrToFloat( sDat ) ;
                12 : gstG[iRow].Nutrient.dMEJ := StrToFloat( sDat ) ;
                13 : gstG[iRow].Nutrient.dCa  := StrToFloat( sDat ) ;
                14 : gstG[iRow].Nutrient.dP   := StrToFloat( sDat ) ;
                15 : gstG[iRow].Nutrient.dVA  := StrToFloat( sDat ) ;
                16 : gstG[iRow].Nutrient.dVD  := StrToFloat( sDat ) ;
              end;
              Inc(iNo);
            until iT = iL ;
          Inc( iRow ) ;
          Application.ProcessMessages;
        end;
        bKomk := True;
      end;
    giSNo := iRow - 1;
    CloseFile( inf ) ;
end;

procedure TForm1.Spread_JFS_Data();
var
  i, j, iR         : Integer;
begin
  StringGrid1.Clean;
  DispHeader_1();
  iR := 1;
  for j:=1 to giSNo do
    begin
      for i:=0 to 17 do
        begin
          case  i  of
             0 : StringGrid1.Cells[i, iR] := IntToStr(j) ;
             1 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].dWt1)   ;
             2 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].dInWt1) ;
             3 : StringGrid1.Cells[i, iR] := gstG[j].cLVCP  ;
             4 : StringGrid1.Cells[i, iR] := gstG[j].cKset  ;
             5 : StringGrid1.Cells[i, iR] := gstG[j].cWean  ;
             6 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dFCM) ;
             7 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dDMI) ;
             8 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dCP)  ;
             9 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dDCP) ;
            10 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dTDN) ;
            11 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dDE)  ;
            12 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dMEC) ;
            13 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dMEJ) ;
            14 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dCa)  ;
            15 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dP)   ;
            16 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dVA)  ;
            17 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dVD)  ;
          end;
        end;
        Inc( iR );
        Application.ProcessMessages;
    end;
end;

procedure TForm1.DispHeader_1();
var
    iNO  :  Integer;
begin
    iNO := 0 ;
    StringGrid1.Clean;
    StringGrid1.Cols[iNO].Text := 'No.';
    for iNO := 0 to 4 do
      begin
    		case iNo of
    	 	  0 :
    		    begin
    		      StringGrid1.Columns[iNo].Title.Caption := '体重' ;
    		      StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    		    end;
    	 	  1 :
    		    begin
    		      StringGrid1.Columns[iNo].Title.Caption := '日増体重' ;
    		      StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    		    end;
    		  2 :
    		    begin
    		      StringGrid1.Columns[iNo].Title.Caption := 'CPの最低値' ;
    		      StringGrid1.Columns[iNo].Alignment := taCenter ;
    		    end;
    		  3 :
    		    begin
    		      StringGrid1.Columns[iNo].Title.Caption := '季節の考慮';
    		      StringGrid1.Columns[iNo].Alignment := taLeftJustify ;
    		    end;
    		  4 :
    		    begin
    		      StringGrid1.Columns[iNo].Title.Caption := '育成牛の離乳' ;
    		      StringGrid1.Columns[iNo].Alignment := taLeftJustify ;
    		    end;
    		end;
      end;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'FCM' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'DMI' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'CP' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'DCP' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'TDN' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'DE' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'ME(Mcal)' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'ME(MJ)' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'Ca' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'P' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'VA' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := 'VD' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid1.Columns[iNo].Title.Caption := ' ' ;
    StringGrid1.Columns[iNo].Alignment := taRightJustify ;
    Application.ProcessMessages;
end;

procedure TForm1.DispHeader_2();
var
    iNO  :  Integer;
begin
    iNO := 0 ;
    StringGrid2.Clean;
    StringGrid2.Cols[iNO].Text := 'No.';
    for iNO := 0 to 4 do
      begin
    		case iNo of
    	 	  0 :
    		    begin
    		      StringGrid2.Columns[iNo].Title.Caption := '体重' ;
    		      StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    		    end;
    	 	  1 :
    		    begin
    		      StringGrid2.Columns[iNo].Title.Caption := '日増体重' ;
    		      StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    		    end;
    		  2 :
    		    begin
    		      StringGrid2.Columns[iNo].Title.Caption := 'CPの最低値' ;
    		      StringGrid2.Columns[iNo].Alignment := taCenter ;
    		    end;
    		  3 :
    		    begin
    		      StringGrid2.Columns[iNo].Title.Caption := '季節の考慮';
    		      StringGrid2.Columns[iNo].Alignment := taLeftJustify ;
    		    end;
    		  4 :
    		    begin
    		      StringGrid2.Columns[iNo].Title.Caption := '育成牛の離乳' ;
    		      StringGrid2.Columns[iNo].Alignment := taLeftJustify ;
    		    end;
    		end;
      end;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'FCM' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'DMI' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'CP' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'DCP' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'TDN' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'DE' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'ME(Mcal)' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'ME(MJ)' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'Ca' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'P' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'VA' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := 'VD' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := ' ' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<DMI>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<CP>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<DCP>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<TDN>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<DE>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<ME(Mcal)>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<ME(MJ)>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<Ca>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<P>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<VA>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := '<VD>' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := ' ' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Inc( iNO ) ;
    StringGrid2.Columns[iNo].Title.Caption := ' ' ;
    StringGrid2.Columns[iNo].Alignment := taRightJustify ;
    Application.ProcessMessages;
end;

procedure TForm1.SelectData();
begin
  Class_JFS();
  Class_Origin2();
end;

procedure TForm1.Class_JFS();
var
  dBW, dLW, dZoTj  : Double;
  sKset, sCP12     : String;
  i, j, iR         : Integer;
  sZotj            : String;
  bC12Flg          : Boolean;
begin
  dLW := StrToFloat(LabeledEdit1.Text);
  dBW := StrToFloat(LabeledEdit2.Text);
  sZotj := ComboBox3.Caption;
  if (sZotj <> '標準値') then dZoTj := StrToFloat(sZotj);
  sKset := ComboBox1.Caption;
  if CheckBox1.Checked then sCP12 := 'ON' else sCP12 := 'OFF';
  StringGrid1.Clean;
  iR := 1;
  for j:=1 to giSNo do
  begin
      if (gstG[j].dWt1 >= dLW) and (gstG[j].dWt1 <= dBW) then
      begin
          if (sZotj = '標準値') then dZoTj := NichZotaijuAnbaichi(gstG[j].dWt1);
          if gstG[j].dInWt1 = dZoTj then
          begin
              if gstG[j].cKset = sKset then
              begin
                  bC12Flg := False;
                  if  gstG[j].dWt1 < 250 then
                    bC12Flg := True
                  else
                    if gstG[j].cLVCP = sCP12 then  bC12Flg := True;
                  if bC12Flg then
                   begin
                     for i:=0 to 17 do
                     begin
                         case  i  of
                            0 : StringGrid1.Cells[i, iR] := IntToStr(j) ;
                            1 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].dWt1)   ;
                            2 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].dInWt1) ;
                            3 : StringGrid1.Cells[i, iR] := gstG[j].cLVCP  ;
                            4 : StringGrid1.Cells[i, iR] := gstG[j].cKset  ;
                            5 : StringGrid1.Cells[i, iR] := gstG[j].cWean  ;
                            6 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dFCM) ;
                            7 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dDMI) ;
                            8 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dCP)  ;
                            9 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dDCP) ;
                           10 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dTDN) ;
                           11 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dDE)  ;
                           12 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dMEC) ;
                           13 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dMEJ) ;
                           14 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dCa)  ;
                           15 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dP)   ;
                           16 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dVA)  ;
                           17 : StringGrid1.Cells[i, iR] := FloatToStr(gstG[j].Nutrient.dVD)  ;
                         end;
                     end;
                     Inc( iR );
                     Application.ProcessMessages;
                   end;
              end;
          end;
      end;
  end;
  giRow4JFS := iR - 1 ;
end;

procedure TForm1.Class_Origin2();
var
  dBW, dLW, dZoTj  : Double;
  sKset, sCP12     : String;
  i, j, iR         : Integer;
  sZotj            : String;
  bC12Flg          : Boolean;
begin
  dLW := StrToFloat(LabeledEdit1.Text);
  dBW := StrToFloat(LabeledEdit2.Text);
  sZotj := ComboBox3.Caption;
  if (sZotj <> '標準値') then dZoTj := StrToFloat(sZotj);
  sKset := ComboBox1.Caption;
  if CheckBox1.Checked then sCP12 := 'ON' else sCP12 := 'OFF';
  StringGrid2.Clean;
  iR := 1;
  for j:=1 to giOrgSrc do
  begin
      if (gOrign[j].dWt1 >= dLW) and (gOrign[j].dWt1 <= dBW) then
      begin
          if (sZotj = '標準値') then dZoTj := NichZotaijuAnbaichi(gOrign[j].dWt1);
          if gOrign[j].dInWt1 = dZoTj then
          begin
              if gOrign[j].cKset = sKset then
              begin
                  bC12Flg := False;
                  if gOrign[j].dWt1 < 250 then
                    bC12Flg := True
                  else
                    if gOrign[j].cLVCP = sCP12 then  bC12Flg := True;
                  if bC12Flg then
                  begin
                      if gOrign[j].cWean = '離乳前' then
                      begin
                          for i:=0 to 17 do
                          begin
                              case  i  of
                                 0 : StringGrid2.Cells[i, iR] := IntToStr(j) ;
                                 1 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].dWt1)   ;
                                 2 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].dInWt1) ;
                                 3 : StringGrid2.Cells[i, iR] := gOrign[j].cLVCP  ;
                                 4 : StringGrid2.Cells[i, iR] := gOrign[j].cKset  ;
                                 5 : StringGrid2.Cells[i, iR] := gOrign[j].cWean  ;
                                 6 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dFCM) ;
                                 7 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dDMI) ;
                                 8 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dCP)  ;
                                 9 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dDCP) ;
                                10 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dTDN) ;
                                11 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dDE)  ;
                                12 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dMEC) ;
                                13 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dMEJ) ;
                                14 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dCa)  ;
                                15 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dP)   ;
                                16 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dVA)  ;
                                17 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dVD)  ;
                              end;
                          end;
                      end
                      else
                      begin
                          for i:=0 to 17 do
                          begin
                              case  i  of
                                 0 : StringGrid2.Cells[i, iR] := IntToStr(j) ;
                                 1 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].dWt1)   ;
                                 2 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].dInWt1) ;
                                 3 : StringGrid2.Cells[i, iR] := gOrign[j].cLVCP  ;
                                 4 : StringGrid2.Cells[i, iR] := gOrign[j].cKset  ;
                                 5 : StringGrid2.Cells[i, iR] := gOrign[j].cWean  ;
                                 6 : StringGrid2.Cells[i, iR] := FloatToStr(gOrign[j].Nutrient.dFCM) ;
                                 7 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dDMI) ;
                                 8 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dCP)  ;
                                 9 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dDCP) ;
                                10 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dTDN) ;
                                11 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dDE)  ;
                                12 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dMEC) ;
                                13 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dMEJ) ;
                                14 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dCa)  ;
                                15 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dP)   ;
                                16 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dVA)  ;
                                17 : StringGrid2.Cells[i+12, iR] := FloatToStr(gOrign[j].Nutrient.dVD)  ;
                              end;
                          end;
                      end;
                      Inc( iR );
                      Application.ProcessMessages;
                  end;
              end;
          end;
      end;
  end;
  giRow4Orign := iR - 1 ;
end;

procedure TForm1.GraphOutPut();
  var iKbn : Integer;
begin
  JapaneseFeedingStandard.Clear;
  Origin2BeforeWeaning.Clear;
  Origin2AfterWeaning.Clear;
  RegressionCurveJFS.Clear;
  RegressionCurveOriginBefore.Clear;
  RegressionCurveOriginAfter.Clear;
  Label7.Caption := '';
  Label8.Caption := '';
  Label9.Caption := '';
  JapaneseFeedingStandard.LinePen.Color:=clRed;
  Origin2BeforeWeaning.LinePen.Color:=clGreen;
  Origin2AfterWeaning.LinePen.Color:=clBlue;
  JapaneseFeedingStandard.Pointer.HorizSize := fMarker.gMrkSze[1];
  JapaneseFeedingStandard.Pointer.VertSize  := fMarker.gMrkSze[1];
  Origin2BeforeWeaning.Pointer.HorizSize := fMarker.gMrkSze[2];
  Origin2BeforeWeaning.Pointer.VertSize  := fMarker.gMrkSze[2];
  Origin2AfterWeaning.Pointer.HorizSize := fMarker.gMrkSze[3];
  Origin2AfterWeaning.Pointer.VertSize  := fMarker.gMrkSze[3];
  if ComboBox2.Text = 'DMI' then
      Chart1.AxisList.Axes[0].Title.Caption := 'DMI (kg)'
  else if ComboBox2.Text = 'CP'  then
      Chart1.AxisList.Axes[0].Title.Caption := 'CP (g)'
  else if ComboBox2.Text = 'DCP' then
      Chart1.AxisList.Axes[0].Title.Caption := 'DCP (g)'
  else if ComboBox2.Text = 'TDN' then
      Chart1.AxisList.Axes[0].Title.Caption := 'TDN (kg)'
  else if ComboBox2.Text = 'DE' then
      Chart1.AxisList.Axes[0].Title.Caption := 'DE (Mcal)'
  else if ComboBox2.Text = 'ME(Mcal)' then
      Chart1.AxisList.Axes[0].Title.Caption := 'ME (Mcal)'
  else if ComboBox2.Text = 'ME(MJ)' then
      Chart1.AxisList.Axes[0].Title.Caption := 'ME (MJ)'
  else if ComboBox2.Text = 'Ca' then
      Chart1.AxisList.Axes[0].Title.Caption := 'Ca (g)'
  else if ComboBox2.Text = 'P' then
      Chart1.AxisList.Axes[0].Title.Caption := 'P (g)'
  else if ComboBox2.Text = 'VA' then
      Chart1.AxisList.Axes[0].Title.Caption := 'VA (1000IU)'
  else if ComboBox2.Text = 'VD' then
      Chart1.AxisList.Axes[0].Title.Caption := 'VD (1000IU)';
  if CheckBox2.Checked then  GraphDraw4JFS();
  iKbn := 0;
  if CheckBox3.Checked then  iKbn := iKbn +  1;
  if CheckBox4.Checked then  iKbn := iKbn + 10;
  if iKbn > 0 then  GraphDraw4Origin2( iKbn );
end;

procedure TForm1.GraphDraw4JFS();
var
  i, iB : Integer;
  dWt, dWrk : Double;
  sWrk : String;
begin
  if ComboBox2.Text = 'DMI' then
      iB := 7
  else if ComboBox2.Text = 'CP'  then
      iB := 8
  else if ComboBox2.Text = 'DCP' then
      iB := 9
   else if ComboBox2.Text = 'TDN' then
      iB := 10
   else if ComboBox2.Text = 'DE' then
      iB := 11
   else if ComboBox2.Text = 'ME(Mcal)' then
      iB := 12
   else if ComboBox2.Text = 'ME(MJ)' then
      iB := 13
   else if ComboBox2.Text = 'Ca' then
      iB := 14
   else if ComboBox2.Text = 'P' then
      iB := 15
   else if ComboBox2.Text = 'VA' then
      iB := 16
   else if ComboBox2.Text = 'VD' then
      iB := 17;
  for i:=1 to giRow4JFS do
    begin
      dWt  := StrToFloat(StringGrid1.Cells[1,i]);
      sWrk := StringGrid1.Cells[iB,i];
      if Trim(sWrk) <> '' then
        begin
          dWrk := StrToFloat(StringGrid1.Cells[iB,i]);
          JapaneseFeedingStandard.AddXY(dWt, dWrk);
        end;
    end;
end;

procedure TForm1.GraphDraw4Origin2(var iKbn : Integer);
var
  i, iA, iB : Integer;
  dWt, dWrk : Double;
  sWrk : String;
begin
  if ComboBox2.Text = 'DMI' then
    begin
      iB := 7;
      iA := 19;
    end
  else if ComboBox2.Text = 'CP'  then
    begin
      iB := 8;
      iA := 20;
    end
  else if ComboBox2.Text = 'DCP' then
    begin
      iB := 9;
      iA := 21;
    end
   else if ComboBox2.Text = 'TDN' then
    begin
      iB := 10;
      iA := 22;
    end
   else if ComboBox2.Text = 'DE' then
     begin
       iB := 11;
       iA := 23;
     end
   else if ComboBox2.Text = 'ME(Mcal)' then
     begin
       iB := 12;
       iA := 24;
     end
   else if ComboBox2.Text = 'ME(MJ)' then
     begin
       iB := 13;
       iA := 25;
     end
   else if ComboBox2.Text = 'Ca' then
     begin
       iB := 14;
       iA := 26;
     end
   else if ComboBox2.Text = 'P' then
     begin
       iB := 15;
       iA := 27;
     end
   else if ComboBox2.Text = 'VA' then
     begin
       iB := 16;
       iA := 28;
     end
   else if ComboBox2.Text = 'VD' then
     begin
       iB := 17;
       iA := 29;
     end;
  for i:=1 to giRow4Orign do
    begin
      if (iKbn = 1) or (iKbn = 11) then
      begin
        dWt  := StrToFloat(StringGrid2.Cells[1,i]);
        sWrk := StringGrid2.Cells[iB,i];
        if Trim(sWrk) <> '' then
          begin
            dWrk := StrToFloat(StringGrid2.Cells[iB,i]);
            Origin2BeforeWeaning.AddXY(dWt, dWrk);
          end;
      end;
      if (iKbn = 10) or (iKbn = 11) then
      begin
        dWt  := StrToFloat(StringGrid2.Cells[1,i]);
        sWrk := StringGrid2.Cells[iA,i];
        if Trim(sWrk) <> '' then
          begin
            dWrk := StrToFloat(StringGrid2.Cells[iA,i]);
            Origin2AfterWeaning.AddXY(dWt, dWrk);
          end;
      end;
    end;
end;

function TForm1.NichZotaijuAnbaichi(var dWt : Double) : Double;
begin
  if( dWt >=  40 ) then NichZotaijuAnbaichi := 0.0 ;
  if( dWt >=  43 ) then NichZotaijuAnbaichi := 0.1 ;
  if( dWt >=  44 ) then NichZotaijuAnbaichi := 0.2 ;
  if( dWt >=  45 ) then NichZotaijuAnbaichi := 0.3 ;
  if( dWt >=  46 ) then NichZotaijuAnbaichi := 0.4 ;
  if( dWt >=  48 ) then NichZotaijuAnbaichi := 0.5 ;
  if( dWt >=  51 ) then NichZotaijuAnbaichi := 0.6 ;
  if( dWt >=  55 ) then NichZotaijuAnbaichi := 0.7 ;
  if( dWt >=  60 ) then NichZotaijuAnbaichi := 0.8 ;
  if( dWt >=  69 ) then NichZotaijuAnbaichi := 0.9 ;
  if( dWt >=  73 ) then NichZotaijuAnbaichi := 1.0 ;
  if( dWt >= 130 ) then NichZotaijuAnbaichi := 0.9 ;
  if( dWt >= 214 ) then NichZotaijuAnbaichi := 0.8 ;
  if( dWt >= 282 ) then NichZotaijuAnbaichi := 0.7 ;
  if( dWt >= 345 ) then NichZotaijuAnbaichi := 0.6 ;
  if( dWt >= 404 ) then NichZotaijuAnbaichi := 0.5 ;
  if( dWt >= 462 ) then NichZotaijuAnbaichi := 0.4 ;
  if( dWt >= 518 ) then NichZotaijuAnbaichi := 0.3 ;
  if( dWt >= 573 ) then NichZotaijuAnbaichi := 0.2 ;
  if( dWt >= 627 ) then NichZotaijuAnbaichi := 0.1 ;
  if( dWt >= 681 ) then NichZotaijuAnbaichi := 0.0 ;
end;


end.

