/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of CRAWLING_SESSION.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsCrawlingSessionCQ extends
        AbstractConditionQuery {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsCrawlingSessionCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "CRAWLING_SESSION";
    }

    public String getTableSqlName() {
        return "CRAWLING_SESSION";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {PK : ID : NotNull : BIGINT}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        regId(CK_NE, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    public void inScopeCrawlingSessionInfoList(
            SubQuery<CrawlingSessionInfoCB> subQuery) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeSubQuery_CrawlingSessionInfoList(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "CRAWLING_SESSION_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery);

    public void notInScopeCrawlingSessionInfoList(
            SubQuery<CrawlingSessionInfoCB> subQuery) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeSubQuery_CrawlingSessionInfoList(cb
                .query()); // for saving query-value.
        registerNotInScopeSubQuery(cb.query(), "ID", "CRAWLING_SESSION_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery);

    /**
     * Set up 'exists' sub-query. {exists (select CRAWLING_SESSION_ID from CRAWLING_SESSION_INFO where ...)}
     * @param subQuery The sub-query of Id_ExistsSubQuery_CrawlingSessionInfoList for 'exists'. (NotNull)
     */
    public void existsCrawlingSessionInfoList(
            SubQuery<CrawlingSessionInfoCB> subQuery) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsSubQuery_CrawlingSessionInfoList(cb
                .query()); // for saving query-value.
        registerExistsSubQuery(cb.query(), "ID", "CRAWLING_SESSION_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery);

    /**
     * Set up 'not exists' sub-query. {not exists (select CRAWLING_SESSION_ID from CRAWLING_SESSION_INFO where ...)}
     * @param subQuery The sub-query of Id_NotExistsSubQuery_CrawlingSessionInfoList for 'not exists'. (NotNull)
     */
    public void notExistsCrawlingSessionInfoList(
            SubQuery<CrawlingSessionInfoCB> subQuery) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForExistsSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsSubQuery_CrawlingSessionInfoList(cb
                .query()); // for saving query-value.
        registerNotExistsSubQuery(cb.query(), "ID", "CRAWLING_SESSION_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsSubQuery_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery);

    public void xsderiveCrawlingSessionInfoList(String function,
            SubQuery<CrawlingSessionInfoCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_CrawlingSessionInfoList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "CRAWLING_SESSION_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery);

    public QDRFunction<CrawlingSessionInfoCB> derivedCrawlingSessionInfoList() {
        return xcreateQDRFunctionCrawlingSessionInfoList();
    }

    protected QDRFunction<CrawlingSessionInfoCB> xcreateQDRFunctionCrawlingSessionInfoList() {
        return new QDRFunction<CrawlingSessionInfoCB>(
                new QDRSetupper<CrawlingSessionInfoCB>() {
                    public void setup(String function,
                            SubQuery<CrawlingSessionInfoCB> subQuery,
                            String operand, Object value) {
                        xqderiveCrawlingSessionInfoList(function, subQuery,
                                operand, value);
                    }
                });
    }

    public void xqderiveCrawlingSessionInfoList(String function,
            SubQuery<CrawlingSessionInfoCB> subQuery, String operand,
            Object value) {
        assertObjectNotNull("subQuery<CrawlingSessionInfoCB>", subQuery);
        CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_CrawlingSessionInfoList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_CrawlingSessionInfoListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "CRAWLING_SESSION_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_CrawlingSessionInfoList(
            CrawlingSessionInfoCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_CrawlingSessionInfoListParameter(
            Object parameterValue);

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. {NotNull : VARCHAR(20)}
     * @param sessionId The value of sessionId as equal.
     */
    public void setSessionId_Equal(String sessionId) {
        regSessionId(CK_EQ, fRES(sessionId));
    }

    /**
     * NotEqual(!=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param sessionId The value of sessionId as notEqual.
     */
    public void setSessionId_NotEqual(String sessionId) {
        regSessionId(CK_NE, fRES(sessionId));
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param sessionId The value of sessionId as greaterThan.
     */
    public void setSessionId_GreaterThan(String sessionId) {
        regSessionId(CK_GT, fRES(sessionId));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param sessionId The value of sessionId as lessThan.
     */
    public void setSessionId_LessThan(String sessionId) {
        regSessionId(CK_LT, fRES(sessionId));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param sessionId The value of sessionId as greaterEqual.
     */
    public void setSessionId_GreaterEqual(String sessionId) {
        regSessionId(CK_GE, fRES(sessionId));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param sessionId The value of sessionId as lessEqual.
     */
    public void setSessionId_LessEqual(String sessionId) {
        regSessionId(CK_LE, fRES(sessionId));
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param sessionId The value of sessionId as prefixSearch.
     */
    public void setSessionId_PrefixSearch(String sessionId) {
        setSessionId_LikeSearch(sessionId, cLSOP());
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param sessionIdList The collection of sessionId as inScope.
     */
    public void setSessionId_InScope(Collection<String> sessionIdList) {
        regINS(CK_INS, cTL(sessionIdList), getCValueSessionId(), "SESSION_ID");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param sessionIdList The collection of sessionId as notInScope.
     */
    public void setSessionId_NotInScope(Collection<String> sessionIdList) {
        regINS(CK_NINS, cTL(sessionIdList), getCValueSessionId(), "SESSION_ID");
    }

    /**
     * LikeSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param sessionId The value of sessionId as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setSessionId_LikeSearch(String sessionId,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(sessionId), getCValueSessionId(), "SESSION_ID",
                likeSearchOption);
    }

    /**
     * NotLikeSearch(not like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param sessionId The value of sessionId as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setSessionId_NotLikeSearch(String sessionId,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(sessionId), getCValueSessionId(), "SESSION_ID",
                likeSearchOption);
    }

    protected void regSessionId(ConditionKey k, Object v) {
        regQ(k, v, getCValueSessionId(), "SESSION_ID");
    }

    abstract protected ConditionValue getCValueSessionId();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param createdTime The value of createdTime as equal.
     */
    public void setCreatedTime_Equal(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_EQ, createdTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterThan.
     */
    public void setCreatedTime_GreaterThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GT, createdTime);
    }

    /**
     * LessThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessThan.
     */
    public void setCreatedTime_LessThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LT, createdTime);
    }

    /**
     * GreaterEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterEqual.
     */
    public void setCreatedTime_GreaterEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GE, createdTime);
    }

    /**
     * LessEqual(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessEqual.
     */
    public void setCreatedTime_LessEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LE, createdTime);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt;= toDate). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param fromDate The from-date of createdTime. (Nullable)
     * @param toDate The to-date of createdTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setCreatedTime_FromTo(java.util.Date fromDate,
            java.util.Date toDate, FromToOption fromToOption) {
        regFTQ((fromDate != null ? new java.sql.Timestamp(fromDate.getTime())
                : null), (toDate != null ? new java.sql.Timestamp(toDate
                .getTime()) : null), getCValueCreatedTime(), "CREATED_TIME",
                fromToOption);
    }

    /**
     * FromTo(fromDate &lt;= COLUMN_NAME &lt; toDate + 1). And NullIgnored, OnlyOnceRegistered. {NotNull : TIMESTAMP}
     * @param fromDate The from-date of createdTime. (Nullable)
     * @param toDate The to-date of createdTime. (Nullable)
     */
    public void setCreatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setCreatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected void regCreatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedTime(), "CREATED_TIME");
    }

    abstract protected ConditionValue getCValueCreatedTime();

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    public SSQFunction<CrawlingSessionCB> scalar_Equal() {
        return xcreateSSQFunction("=");
    }

    public SSQFunction<CrawlingSessionCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(">=");
    }

    public SSQFunction<CrawlingSessionCB> scalar_GreaterThan() {
        return xcreateSSQFunction(">");
    }

    public SSQFunction<CrawlingSessionCB> scalar_LessEqual() {
        return xcreateSSQFunction("<=");
    }

    public SSQFunction<CrawlingSessionCB> scalar_LessThan() {
        return xcreateSSQFunction("<");
    }

    protected SSQFunction<CrawlingSessionCB> xcreateSSQFunction(
            final String operand) {
        return new SSQFunction<CrawlingSessionCB>(
                new SSQSetupper<CrawlingSessionCB>() {
                    public void setup(String function,
                            SubQuery<CrawlingSessionCB> subQuery) {
                        xscalarSubQuery(function, subQuery, operand);
                    }
                });
    }

    protected void xscalarSubQuery(String function,
            SubQuery<CrawlingSessionCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<CrawlingSessionCB>", subQuery);
        CrawlingSessionCB cb = new CrawlingSessionCB();
        cb.xsetupForScalarSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarSubQuery(cb.query()); // for saving query-value.
        registerScalarSubQuery(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarSubQuery(CrawlingSessionCQ subQuery);

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    /**
     * Myself InScope SubQuery. {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<CrawlingSessionCB> subQuery) {
        assertObjectNotNull("subQuery<CrawlingSessionCB>", subQuery);
        CrawlingSessionCB cb = new CrawlingSessionCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeSubQuery(cb.query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeSubQuery(CrawlingSessionCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return CrawlingSessionCB.class.getName();
    }

    String xCQ() {
        return CrawlingSessionCQ.class.getName();
    }

    String xLSO() {
        return LikeSearchOption.class.getName();
    }
}
