/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import jp.sf.fess.db.exentity.OverlappingHost;
import jp.sf.fess.service.OverlappingHostService;

public class OverlappingHostHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<OverlappingHost> overlappingHostList;

    @Resource
    protected OverlappingHostService overlappingHostService;

    public void init() {
        overlappingHostList = overlappingHostService.getOverlappingHostList();
    }

    public void setOverlappingHostList(List<OverlappingHost> overlappingHostList) {
        this.overlappingHostList = overlappingHostList;
    }

    public void add(OverlappingHost overlappingHost) {
        if (overlappingHostList == null) {
            overlappingHostList = new ArrayList<OverlappingHost>();
        }
        overlappingHostList.add(overlappingHost);
    }

    public String convert(String url) {
        if (overlappingHostList == null) {
            return url;
        }

        for (OverlappingHost overlappingHost : overlappingHostList) {
            url = overlappingHost.convert(url);
        }
        return url;
    }
}
