<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.solr_title_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="solr" />
	<tiles:put name="headerScript" type="string"></tiles:put>
	<tiles:put name="body" type="string">

      <div id="main">

	<div>
		<html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages>
		<html:errors/>
	</div>

	<s:form>
	<div class="form-table">
		<table style="width:500px;">
            <caption><bean:message key="labels.solr_title_edit"/></caption>
			<tbody>
				<tr>
					<th>
						<bean:message key="labels.solr_process_running"/>
					</th>
					<td>
						<c:if test="${solrProcessRunning}"><bean:message key="labels.solr_running"/>　(${f:h(runningSessionId)})</c:if>
						<c:if test="${!solrProcessRunning}"><bean:message key="labels.solr_stopped"/></c:if>
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.solr_current_select_server"/>
					</th>
					<td>
						${f:h(currentServerForSelect)}
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.solr_current_update_server"/>
					</th>
					<td>
						${f:h(currentServerForUpdate)}
					</td>
				</tr>
			<c:forEach var="serverStatus" items="${serverStatusList}">
				<tr>
					<th style="width:200px;">
					${f:h(serverStatus.serverName)}
					</th>
					<td>
					<html:select name="serverStatusList" property="${serverStatus.serverName}" value="${serverStatus.status}" indexed="true">
						<html:option value="ACTIVE"><bean:message key="labels.solr_active"/></html:option>
						<html:option value="INACTIVE"><bean:message key="labels.solr_inactive"/></html:option>
					</html:select>
					</td>
				</tr>
			</c:forEach>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" name="update" value="<bean:message key="labels.solr_button_update"/>"/>
					</td>
				</tr>
			</tfoot>
		</table>
	</div>
	</s:form>

	<div class="form-table" style="margin-top:5px;">
		<table style="width:500px;">
            <caption><bean:message key="labels.solr_title_action"/></caption>
			<tbody>
			<c:forEach var="groupAction" items="${groupActionItems}">
				<tr>
					<td style="padding:0;margin:0;">
				<s:form style="margin:0;padding:0;">
				<table style="width:100%;">
				<tr>
					<th style="width:200px;" rowspan="2">
					${f:h(groupAction.groupName)}
					</th>
					<td>
					<html:hidden property="groupName" value="${f:u(groupAction.groupName)}"/>
					<html:submit property="commit" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_commit"/></html:submit>
					<html:submit property="optimize" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_optimize"/></html:submit>
					</td>
				</tr>
				<tr>
					<td>
					<html:select property="sessionId">
						<html:option value=""><bean:message key="labels.solr_action_none"/></html:option>
						<c:forEach var="sessionIdItem" items="${groupAction.sessionIdItems}">
							<html:option value="${f:u(sessionIdItem.value)}">${f:h(sessionIdItem.label)}</html:option>
						</c:forEach>
						<html:option value="*"><bean:message key="labels.solr_action_all"/></html:option>
					</html:select>
					<html:submit property="delete" disabled="${solrProcessRunning}"><bean:message key="labels.solr_action_delete"/></html:submit>
					</td>
				</tr>
				</table>
				</s:form>
					</td>
				</tr>
			</c:forEach>
			</tbody>
		</table>
	</div>

      </div>

	</tiles:put>
</tiles:insert>
